/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.server.model.validation;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeId;
import de.justsoftware.onx.container.server.model.validation.constraint.EntityDynamicAttributeConstraint;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.IEntityDynamicAttribute;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@EntityDynamicAttributeConstraint
public class EntityDynamicAttributeValidationModel {
    public static final Function<EntityDynamicAttributeValidationModel, DynamicAttributeId> TO_ATTRIBUTE_ID = new Function<EntityDynamicAttributeValidationModel, DynamicAttributeId>(){

        public DynamicAttributeId apply(@Nullable EntityDynamicAttributeValidationModel attribute) {
            return attribute != null ? attribute.getAttributeId() : null;
        }
    };
    private final EntityType _type;
    private final DynamicAttributeId _attributeId;
    private final ImmutableList<String> _values;

    public EntityDynamicAttributeValidationModel(@Nonnull IEntityDynamicAttribute origin, @Nonnull EntityType type) {
        this._type = type;
        this._attributeId = origin.getAttributeId();
        this._values = origin.getValues();
    }

    @Nonnull
    public EntityType getType() {
        return this._type;
    }

    @Nonnull
    public DynamicAttributeId getAttributeId() {
        return this._attributeId;
    }

    @Nonnull
    public ImmutableList<String> getValues() {
        return this._values;
    }

    @Nonnull
    public static Function<IEntityDynamicAttribute, EntityDynamicAttributeValidationModel> validationModelFunctionForType(final @Nonnull EntityType type) {
        return new Function<IEntityDynamicAttribute, EntityDynamicAttributeValidationModel>(){

            public EntityDynamicAttributeValidationModel apply(@Nullable IEntityDynamicAttribute input) {
                return input != null ? new EntityDynamicAttributeValidationModel(input, type) : null;
            }
        };
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this._type).add("attributeId", (Object)this._attributeId).add("values", this._values == null ? null : Integer.valueOf(this._values.size())).toString();
    }
}

