/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.integration.persistence.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import de.justsoftware.onx.container.shared.model.EntityStatusId;
import de.justsoftware.onx.container.shared.model.EntityStatusImpl;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.HasEntityType;
import de.justsoftware.onx.container.shared.model.Identifiable;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DBEntityStatus
implements Identifiable<EntityStatusId>,
HasEntityType {
    public static final Function<DBEntityStatus, EntityStatus> TO_BUSINESS_STATUS = new Function<DBEntityStatus, EntityStatus>(){

        public EntityStatus apply(DBEntityStatus input) {
            return input != null ? new EntityStatusImpl(input) : null;
        }
    };
    public static final Function<EntityStatus, DBEntityStatus> TO_DB_STATUS = new Function<EntityStatus, DBEntityStatus>(){

        public DBEntityStatus apply(EntityStatus input) {
            if (input == null) {
                return null;
            }
            DBEntityStatus dbStatus = new DBEntityStatus();
            dbStatus.setId((EntityStatusId)input.getId());
            dbStatus.setStatusName(input.getName());
            dbStatus.setEntityType(input.getEntityType());
            dbStatus.setDefaultStatus(input.isDefault());
            dbStatus.setPublishedStatus(input.isPublished());
            dbStatus.setArchivedStatus(input.isArchived());
            return dbStatus;
        }
    };
    private EntityStatusId _id;
    private EntityType _entityType;
    private String _statusName;
    private String _iconType;
    private boolean _defaultStatus;
    private boolean _archivedStatus;
    private boolean _publishedStatus;
    private int _order;

    @Override
    @Nonnull
    public EntityStatusId getId() {
        return this._id;
    }

    public void setId(EntityStatusId id) {
        this._id = id;
    }

    @Override
    @Nonnull
    public EntityType getEntityType() {
        return this._entityType;
    }

    public void setEntityType(EntityType entityType) {
        this._entityType = entityType;
    }

    @Nonnull
    public String getStatusName() {
        return this._statusName;
    }

    public void setStatusName(String statusName) {
        this._statusName = statusName;
    }

    public String getIconType() {
        return this._iconType;
    }

    public void setIconType(String iconType) {
        this._iconType = iconType;
    }

    public boolean isDefaultStatus() {
        return this._defaultStatus;
    }

    public void setDefaultStatus(boolean defaultStatus) {
        this._defaultStatus = defaultStatus;
    }

    public boolean isArchivedStatus() {
        return this._archivedStatus;
    }

    public void setArchivedStatus(boolean archiveStatus) {
        this._archivedStatus = archiveStatus;
    }

    public boolean isPublishedStatus() {
        return this._publishedStatus;
    }

    public void setPublishedStatus(boolean publishedStatus) {
        this._publishedStatus = publishedStatus;
    }

    public int getOrder() {
        return this._order;
    }

    public void setOrder(int order) {
        this._order = order;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass().equals(obj.getClass()) && Objects.equal((Object)this._id, (Object)((DBEntityStatus)obj)._id);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this._id});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("entityType", (Object)this._entityType).add("statusName", (Object)this._statusName).add("iconType", (Object)this._iconType).add("defaultStatus", this._defaultStatus).add("publishedStatus", this._publishedStatus).add("archivedStatus", this._archivedStatus).add("order", this._order).toString();
    }
}

