/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStandardResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.container.integration.persistence.EntityVersionDriveChangeDAO;
import de.justsoftware.onx.container.shared.model.DriveChangeId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class IbatisEntityVersionDriveChangeDAO
implements EntityVersionDriveChangeDAO {
    private final IbatisStatementBuilder _statementBuilder;

    @Autowired
    public IbatisEntityVersionDriveChangeDAO(StatementBuilderFactory statementBuilderFactory) {
        this._statementBuilder = statementBuilderFactory.ibatistStatementBuilder("EntityVersionDriveChange");
    }

    @Override
    public void setDriveChangeForVersion(EntityVersionId entityVersionId, DriveChangeId driveChangeId) {
        this._statementBuilder.insert("setDriveChangeForVersion").param("entityVersionId", entityVersionId, "driveChangeId", driveChangeId);
    }

    @Override
    public ImmutableSetMultimap<EntityId, DriveChangeId> getDriveChangesForEntity(Set<EntityId> entityIds) {
        return entityIds.isEmpty() ? ImmutableSetMultimap.of() : this._statementBuilder.select("getDriveChangesForEntity").param(IbatisDAOUtil.toIbatisList(entityIds)).asSetMultimap("entityId", "driveChangeId");
    }

    @Override
    public void updateDriveChangeForAllEntityVersions(EntityId entityId, DriveChangeId driveChangeId) {
        this._statementBuilder.update("updateDriveChangeVersionForEntity").param("entityId", entityId, "driveChangeId", driveChangeId);
    }

    @Override
    public ImmutableSetMultimap<DriveChangeId, EntityVersionId> getEntityVersionsForDriveChanges(Set<DriveChangeId> changes) {
        return ((IbatisPartitionResultBuilder)this._statementBuilder.select("getEntityVersionsForDriveChanges").partition(changes)).asSetMultimap("driveChangeId", "entityVersionId");
    }

    @Override
    public ImmutableMap<EntityVersionId, DriveChangeId> getDriveChangesForEntityVersions(Set<EntityVersionId> entityVersions) {
        return ((IbatisPartitionResultBuilder)this._statementBuilder.select("getDriveChangesForEntityVersions").partition(entityVersions)).asMap("entityVersionId", "driveChangeId");
    }

    @Override
    public void deleteByEntityVersions(Set<EntityVersionId> entityVersions) {
        this._statementBuilder.delete("deleteByEntityVersions").partition(entityVersions);
    }

    @Override
    public void setInitialDriveChangeVersion(EntityId entityId, DriveChangeId driveChangeId) {
        this._statementBuilder.insert("setInitialDriveChangeVersion").param("entityId", entityId, "driveChangeId", driveChangeId);
    }

    @Override
    public void forAllDriveChanges(int chunkSize, Consumer<ImmutableSet<DriveChangeId>> chunkConsumer) {
        ((IbatisStandardResultBuilder)this._statementBuilder.select("getAllDriveChanges").noParam()).consumeChunkedSet(chunkSize, chunkConsumer);
    }
}

