/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStandardResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.model.IEntityVersion;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.Numbers;
import de.justsoftware.onx.container.business.model.EntityVersion;
import de.justsoftware.onx.container.integration.persistence.EntityVersionDAO;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import de.justsoftware.onx.container.shared.model.EntityStatusId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.EntityVersionType;
import de.justsoftware.onx.container.shared.model.db.DBEntityVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class IbatisEntityVersionDAO
implements EntityVersionDAO {
    private static final String STATUS = "status";
    private static final String ENTITY_ID = "entityId";
    private static final String ID = "id";
    private final SqlMapClient _sqlMapClient;
    private final IbatisStatementBuilder _ibatisBuilder;

    @Autowired
    @ParametersAreNonnullByDefault
    public IbatisEntityVersionDAO(@Qualifier(value="sqlMapClient") SqlMapClient sqlMapper, StatementBuilderFactory statementBuilderFactory) {
        this._sqlMapClient = sqlMapper;
        this._ibatisBuilder = statementBuilderFactory.ibatistStatementBuilder("EntityVersion");
    }

    @Override
    public ImmutableSet<EntityVersion> getVersionsByIds(Set<? extends EntityVersionId> ids) {
        ImmutableList result = IbatisDAOUtil.wrappedPartitionQueryForImmutableList(this._sqlMapClient, Statement.SELECT_BY_IDS.getStatement(), ids, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
        return FluentIterable.from(result).transform(EntityVersion.TO_ENTITY_VERSION).toSet();
    }

    @Override
    public int getDraftCountForAuthor(PersonId personId) {
        return Numbers.intValue((Number)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapClient, Statement.SELECT_PERSONAL_DRAFTS_COUNT.getStatement(), personId));
    }

    @Override
    public ListAndCount<EntityId> getEntityDraftsForAuthor(int offset, int limit, PersonId personId) {
        int count = this.getDraftCountForAuthor(personId);
        ListAndCount<EntityId> result = new ListAndCount<EntityId>(limit);
        result.setMaxCount(count);
        if (count > 0 && count > offset) {
            List dbList = IbatisDAOUtil.wrappedQueryForList(this._sqlMapClient, Statement.SELECT_ENTITY_ID_OF_PERSONAL_DRAFTS.getStatement(), personId, offset, limit);
            result.addAll(dbList);
        }
        return result;
    }

    @Nonnull
    private ListAndCount<EntityVersion> getEntityVersionListForStatemenentByPerson(int offset, int limit, @Nonnull Statement statementForCount, @Nonnull Statement statement, @Nonnull PersonId personId) {
        int count = Numbers.intValue((Number)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapClient, statementForCount.getStatement(), personId));
        if (count > offset) {
            ArrayList<EntityVersion> list = new ArrayList<EntityVersion>();
            List<DBEntityVersion> dbList = IbatisDAOUtil.wrappedQueryForList(this._sqlMapClient, statement.getStatement(), personId, offset, limit);
            for (DBEntityVersion dbVersion : dbList) {
                list.add(new EntityVersion(dbVersion));
            }
            return new ListAndCount<EntityVersion>(count, (Collection<EntityVersion>)list);
        }
        return new ListAndCount<EntityVersion>(count, (Collection<EntityVersion>)ImmutableList.of());
    }

    @Override
    public ListAndCount<EntityVersion> getDeclinedForPerson(int offset, int limit, PersonId personId) {
        return this.getEntityVersionListForStatemenentByPerson(offset, limit, Statement.SELECT_DECLINED_FOR_PERSON_COUNT, Statement.SELECT_DECLINED_FOR_PERSON, personId);
    }

    @Override
    public void updateReadDateByEntityVersionId(EntityVersionId id, DateWithoutTimezone readDate) {
        ImmutableMap params = ImmutableMap.of((Object)"entityVersionId", (Object)id, (Object)"readDate", (Object)readDate);
        IbatisDAOUtil.wrappedUpdate(this._sqlMapClient, Statement.UPDATE_READ_DATE_BY_ENTITY_VERSION_ID.getStatement(), params);
    }

    @Override
    public EntityVersionId create(IEntityVersion version) {
        return (EntityVersionId)IbatisDAOUtil.wrappedInsert(this._sqlMapClient, Statement.INSERT_ENTITY_VERSION.getStatement(), version);
    }

    @Override
    public void update(DBEntityVersion version) {
        IbatisDAOUtil.wrappedUpdate(this._sqlMapClient, Statement.UPDATE_BY_ID.getStatement(), version);
    }

    @Override
    public void updateForImport(DBEntityVersion version) {
        IbatisDAOUtil.wrappedUpdate(this._sqlMapClient, Statement.UDDATE_FOR_IMPORT_BY_ID.getStatement(), version);
    }

    @Override
    public ImmutableList<EntityVersion> getVersionsForEntity(EntityId entityId, Iterable<EntityStatus> status, int offset, int limit) {
        ImmutableMap params = ImmutableMap.of((Object)ENTITY_ID, (Object)entityId, (Object)STATUS, IbatisDAOUtil.toIbatisList(status));
        List<DBEntityVersion> versions = IbatisDAOUtil.wrappedQueryForList(this._sqlMapClient, Statement.SELECT_VERSION_BY_STATUS.getStatement(), params, offset, limit);
        return this.transformToImmutableEntityVersionList(versions);
    }

    @Nonnull
    private ImmutableList<EntityVersion> transformToImmutableEntityVersionList(@Nonnull List<DBEntityVersion> versions) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DBEntityVersion version : versions) {
            builder.add((Object)new EntityVersion(version));
        }
        return builder.build();
    }

    @Override
    public int countVersionsForEntity(EntityId entityId, Iterable<EntityStatus> status) {
        ImmutableMap params = ImmutableMap.of((Object)ENTITY_ID, (Object)entityId, (Object)STATUS, IbatisDAOUtil.toIbatisList(status));
        Integer count = (Integer)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapClient, Statement.COUNT_VERSION_BY_STATUS.getStatement(), params);
        return count != null ? count : 0;
    }

    @Override
    public void deleteVersion(EntityVersionId id) {
        IbatisDAOUtil.wrappedDelete(this._sqlMapClient, Statement.DELETE_VERSION_BY_ID.getStatement(), id);
    }

    @Override
    public void deleteVersionsById(Set<EntityVersionId> versionIds) {
        IbatisDAOUtil.wrappedPartitionDelete(this._sqlMapClient, Statement.DELETE_VERSIONS_BY_ID.getStatement(), versionIds, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public ImmutableList<EntityVersion> getReleasedVersions(Date latestPublishingDate) {
        List<DBEntityVersion> versions = IbatisDAOUtil.wrappedQueryForList(this._sqlMapClient, Statement.SELECT_RELEASED_VERSIONS.getStatement(), latestPublishingDate);
        return this.transformToImmutableEntityVersionList(versions);
    }

    @Override
    public ImmutableList<EntityVersion> getPublishedVersionsWithExpirationDate(Date latestExpirationDate) {
        List<DBEntityVersion> versions = IbatisDAOUtil.wrappedQueryForList(this._sqlMapClient, Statement.SELECT_PUBLISHED_VERSIONS_WITH_EXPIRATION_DATE.getStatement(), ImmutableMap.of((Object)"toDate", (Object)latestExpirationDate));
        return this.transformToImmutableEntityVersionList(versions);
    }

    @Override
    public ImmutableList<EntityVersion> getPublishedVersionsWithExpirationDateBetween(Date from, Date to) {
        List<DBEntityVersion> versions = IbatisDAOUtil.wrappedQueryForList(this._sqlMapClient, Statement.SELECT_PUBLISHED_VERSIONS_WITH_EXPIRATION_DATE.getStatement(), ImmutableMap.of((Object)"toDate", (Object)to, (Object)"fromDate", (Object)from));
        return this.transformToImmutableEntityVersionList(versions);
    }

    @Override
    public void updateStatusForEntityVersions(EntityId entityId, Iterable<EntityStatus> oldStatus, EntityStatus newStatus) {
        IbatisDAOUtil.wrappedUpdate(this._sqlMapClient, Statement.UPDATE_STATUS_FOR_ENTITY_VERSIONS_WITH_STATUS.getStatement(), ImmutableMap.of((Object)ENTITY_ID, (Object)entityId, (Object)"oldStatus", IbatisDAOUtil.toIbatisList(oldStatus), (Object)"newStatus", (Object)newStatus));
    }

    @Override
    public void updateStatus(EntityVersionId versionId, EntityStatus targetStatus) {
        IbatisDAOUtil.wrappedUpdate(this._sqlMapClient, Statement.UPDATE_STATUS.getStatement(), ImmutableMap.of((Object)ID, (Object)versionId, (Object)"targetStatus", (Object)targetStatus));
    }

    @Override
    public ImmutableSet<EntityVersionId> getAllVersionsForEntity(EntityId entityId) {
        return IbatisDAOUtil.wrappedQueryForImmutableSet(this._sqlMapClient, Statement.SELECT_ALL_VERSION_IDS_FOR_ENTITY.getStatement(), entityId);
    }

    @Override
    public ImmutableSet<EntityVersion> getNewestVersionsForEntity(Set<? extends EntityId> entityIds) {
        ImmutableSet dbVersions = IbatisDAOUtil.wrappedPartitionQueryForImmutableSet(this._sqlMapClient, Statement.SELECT_NEWEST_VERSIONS_GROUPED_BY_STATUS_FOR_ENTITY.getStatement(), entityIds, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
        return FluentIterable.from(dbVersions).transform(EntityVersion.TO_ENTITY_VERSION).toSet();
    }

    @Override
    public void updateStatusOfVersionsWithStatus(Set<EntityStatusId> currentStatus, EntityStatus targetStatus) {
        if (currentStatus.isEmpty()) {
            return;
        }
        IbatisDAOUtil.wrappedUpdate(this._sqlMapClient, Statement.UPDATE_STATUS_FOR_VERSIONS_WITH_STATUS.getStatement(), ImmutableMap.of((Object)"currentStatus", IbatisDAOUtil.toIbatisList(currentStatus), (Object)"targetStatus", (Object)targetStatus));
    }

    @Override
    public ImmutableSet<EntityVersion> getNewestVersionsForEntityType(EntityType type) {
        ImmutableSet dbVersions = IbatisDAOUtil.wrappedQueryForImmutableSet(this._sqlMapClient, Statement.SELECT_NEWEST_VERSIONS_FOR_ENTITY_TYPE.getStatement(), type);
        return FluentIterable.from(dbVersions).transform(EntityVersion.TO_ENTITY_VERSION).toSet();
    }

    @Override
    public EntityVersionId getLatestVersionByType(EntityId entityId, EntityVersionType versionType) {
        return (EntityVersionId)((IbatisStandardResultBuilder)this._ibatisBuilder.select("selectLatestVersionByType").param(ENTITY_ID, entityId, "type", (Object)versionType)).singleObject();
    }

    @Override
    public EntityVersion getLastNonDraftVersionBefore(EntityVersionId versionId) {
        return (EntityVersion)EntityVersion.TO_ENTITY_VERSION.apply((Object)((IEntityVersion)this._ibatisBuilder.select("selectLastNonDraftVersionBefore").param(versionId).singleObject()));
    }

    @Override
    public EntityVersionId getFirstVersionForEntity(EntityId entityId) {
        return (EntityVersionId)this._ibatisBuilder.select("selectFirstVersionForEntity").param(entityId).singleObject();
    }

    private static enum Statement {
        SELECT_BY_IDS("selectByIds"),
        SELECT_DECLINED_FOR_PERSON_COUNT("selectDeclinedForPersonCount"),
        SELECT_DECLINED_FOR_PERSON("selectDeclinedForPerson"),
        SELECT_PERSONAL_DRAFTS_COUNT("selectDraftCountForAuthor"),
        SELECT_ENTITY_ID_OF_PERSONAL_DRAFTS("selectEntityIdOfDraftsByAuthor"),
        UPDATE_READ_DATE_BY_ENTITY_VERSION_ID("updateReadDateByEntityVersionId"),
        INSERT_ENTITY_VERSION("insertEntityVersion"),
        SELECT_VERSION_BY_STATUS("selectVersionByStatus"),
        COUNT_VERSION_BY_STATUS("countVersionByStatus"),
        UPDATE_BY_ID("updateById"),
        UDDATE_FOR_IMPORT_BY_ID("updateForImportById"),
        DELETE_VERSION_BY_ID("deleteVersionById"),
        DELETE_VERSIONS_BY_ID("deleteVersionsById"),
        SELECT_RELEASED_VERSIONS("selectReleasedVersions"),
        SELECT_PUBLISHED_VERSIONS_WITH_EXPIRATION_DATE("selectPublishedVersionsWithExpirationDate"),
        UPDATE_STATUS_FOR_ENTITY_VERSIONS_WITH_STATUS("updateStatusForEntityVersionsWithStatus"),
        UPDATE_STATUS("updateStatus"),
        UPDATE_STATUS_FOR_VERSIONS_WITH_STATUS("updateStatusForVersionsWithStatus"),
        SELECT_ALL_VERSION_IDS_FOR_ENTITY("selectAllVersionIdsForEntity"),
        SELECT_NEWEST_VERSIONS_GROUPED_BY_STATUS_FOR_ENTITY("selectNewestVersionsForEntity"),
        SELECT_NEWEST_VERSIONS_FOR_ENTITY_TYPE("selectNewestVersionsForEntityType");

        private static final String NAMESPACE = "EntityVersion";
        private final String _id;

        private Statement(String ibatisId) {
            this._id = ibatisId;
        }

        @Nonnull
        public String getStatement() {
            return "EntityVersion." + this._id;
        }
    }
}

