/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.integration.persistence.ibatis;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.appswitcher.shared.model.AppId;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.integration.persistence.EntityTypeAppMappingDAO;
import de.justsoftware.onx.container.shared.model.EntityType;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@Repository
public class IbatisEntityTypeAppMappingDAO
implements EntityTypeAppMappingDAO {
    private final IbatisStatementBuilder _statementBuilder;
    private final TransactionHelper _transactionHelper;

    @Autowired
    public IbatisEntityTypeAppMappingDAO(StatementBuilderFactory statementBuilderFactory, TransactionHelper transactionHelper) {
        this._transactionHelper = transactionHelper;
        this._statementBuilder = statementBuilderFactory.ibatistStatementBuilder("EntityTypeAppMapping");
    }

    @Override
    public ImmutableMap<EntityType, AppId> getMapping(Set<? extends EntityType> entityTypes) {
        return ((IbatisPartitionResultBuilder)this._statementBuilder.select("getAppsForEntityTypes").partition(entityTypes)).asMap("entity_type", "app_id");
    }

    @Override
    public void setMapping(final EntityType entityType, final AppId appId) {
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                IbatisEntityTypeAppMappingDAO.this._statementBuilder.delete("deleteMapping").param("entityType", entityType);
                if (appId != null) {
                    IbatisEntityTypeAppMappingDAO.this._statementBuilder.insert("insertMapping").param("entityType", entityType, "appId", appId);
                }
            }
        });
    }
}

