/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.integration.persistence.EntityRecommendationDAO;
import de.justsoftware.onx.container.integration.persistence.model.DBEntityRecommendation;
import de.justsoftware.onx.container.server.shared.model.EntityRecommendation;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@Repository
public class IbatisEntityRecommendationDAO
implements EntityRecommendationDAO {
    private static final String NAMESPACE = "EntityRecommendation.";
    private static final Function<DBEntityRecommendation, EntityRecommendation> TO_BUSINESS_RECOMMENDATION = new Function<DBEntityRecommendation, EntityRecommendation>(){

        public EntityRecommendation apply(@Nullable DBEntityRecommendation recommendation) {
            return IbatisEntityRecommendationDAO.convertRecommendation(recommendation);
        }
    };
    private final SqlMapClient _sqlMapper;
    private final TransactionHelper _transactionHelper;

    @Autowired
    public IbatisEntityRecommendationDAO(@Nonnull @Qualifier(value="sqlMapClient") SqlMapClient sqlMapper, @Nonnull TransactionHelper transactionHelper) {
        this._sqlMapper = sqlMapper;
        this._transactionHelper = transactionHelper;
    }

    @Override
    public void insertRecommendation(EntityId entityId, PersonId personId, PersonId recommenderId, String recommendationMessage) {
        IbatisDAOUtil.wrappedInsert(this._sqlMapper, "EntityRecommendation.insertRecommendation", ImmutableMap.of((Object)"entityId", (Object)entityId, (Object)"personId", (Object)personId, (Object)"recommenderId", (Object)recommenderId, (Object)"recommendationMessage", (Object)recommendationMessage));
    }

    @Override
    public EntityRecommendation getRecommendationById(EntityId entityId, PersonId personId) {
        DBEntityRecommendation dbModel = (DBEntityRecommendation)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapper, "EntityRecommendation.getRecommendationById", ImmutableMap.of((Object)"personId", (Object)personId, (Object)"entityId", (Object)entityId));
        return IbatisEntityRecommendationDAO.convertRecommendation(dbModel);
    }

    @Override
    public void deleteRecommendation(EntityId entityId, PersonId personId) {
        IbatisDAOUtil.wrappedDelete(this._sqlMapper, "EntityRecommendation.deleteRecommendation", ImmutableMap.of((Object)"entityId", (Object)entityId, (Object)"personId", (Object)personId));
    }

    @Override
    public void updateRecommendation(final EntityId entityId, final PersonId personId, final PersonId recommenderId, final String recommendationMessage) {
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus transactionstatus) {
                IbatisEntityRecommendationDAO.this.deleteRecommendation(entityId, personId);
                IbatisEntityRecommendationDAO.this.insertRecommendation(entityId, personId, recommenderId, recommendationMessage);
            }
        });
    }

    @CheckForNull
    private static EntityRecommendation convertRecommendation(@Nullable DBEntityRecommendation recommendation) {
        if (recommendation == null) {
            return null;
        }
        return new EntityRecommendation(recommendation.getEntityId(), recommendation.getPersonId(), recommendation.getRecommenderId(), recommendation.getRecommendationMessage(), recommendation.getCreateDate());
    }

    @Override
    public ImmutableSet<PersonId> getPersonsWithRecommendationForEntity(EntityId entityId) {
        return IbatisDAOUtil.wrappedQueryForImmutableSet(this._sqlMapper, "EntityRecommendation.getPersonsWithRecommendationByEntityId", entityId);
    }

    @Override
    public void deleteRecommendationsByPersonIds(Set<PersonId> personIds) {
        IbatisDAOUtil.wrappedPartitionDelete(this._sqlMapper, "EntityRecommendation.deleteRecommendationByPersonIds", personIds, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public void deleteRecommendationsByEntityIds(Set<EntityId> entityIds) {
        IbatisDAOUtil.wrappedPartitionDelete(this._sqlMapper, "EntityRecommendation.deleteRecommendationByEntityIds", entityIds, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public ImmutableList<EntityRecommendation> getRecommendationsForUser(PersonId personId, ImmutableSet<EntityType> entityTypes) {
        if (CollectionUtil.isEmpty(entityTypes)) {
            return ImmutableList.of();
        }
        ImmutableList result = IbatisDAOUtil.wrappedQueryForImmutableList(this._sqlMapper, "EntityRecommendation.getRecommendationsForUser", ImmutableMap.of((Object)"personId", (Object)personId, (Object)"entityTypes", (Object)entityTypes.asList()));
        return ImmutableList.copyOf((Iterable)Iterables.transform(result, TO_BUSINESS_RECOMMENDATION));
    }
}

