/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.integration.persistence.ibatis;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.integration.persistence.EntityMemberDAO;
import de.justsoftware.onx.container.integration.persistence.EntityMemberRoleDAO;
import de.justsoftware.onx.container.integration.persistence.model.DBEntityMemberIdAndRole;
import de.justsoftware.onx.container.integration.persistence.model.DBEntityMemberIdAndRoleWithEntityType;
import de.justsoftware.onx.container.integration.persistence.model.DBEntityMemberIdAndRoleWithPerson;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMember;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberWithEntityType;
import de.justsoftware.onx.container.shared.model.EntityMemberWithPerson;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.person.integration.persistence.DBPersonRelation;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class IbatisEntityMemberDAO
implements EntityMemberDAO {
    private static final Function<DBEntityMemberIdAndRole, ImmutableList<?>> GROUP_BY_ENTITY_AND_PERSON = new Function<DBEntityMemberIdAndRole, ImmutableList<?>>(){

        public ImmutableList<?> apply(@Nullable DBEntityMemberIdAndRole input) {
            return input != null ? ImmutableList.of((Object)input.getEntityId(), (Object)input.getPersonId()) : null;
        }
    };
    private static final Function<Collection<DBEntityMemberIdAndRoleWithEntityType>, EntityMemberWithEntityType> TO_BUSINESS_ENTITY_TYPE = new Function<Collection<DBEntityMemberIdAndRoleWithEntityType>, EntityMemberWithEntityType>(){

        public EntityMemberWithEntityType apply(@Nullable Collection<DBEntityMemberIdAndRoleWithEntityType> input) {
            if (input == null || input.isEmpty()) {
                return null;
            }
            EntityId entityId = (EntityId)Iterables.getOnlyElement((Iterable)ImmutableSet.copyOf((Iterable)Iterables.transform(input, DBEntityMemberIdAndRole.GET_ENTITY_ID)));
            PersonId personId = (PersonId)Iterables.getOnlyElement((Iterable)ImmutableSet.copyOf((Iterable)Iterables.transform(input, DBEntityMemberIdAndRole.GET_PERSON_ID)));
            ImmutableSet roles = ImmutableSet.copyOf((Iterable)Iterables.transform(input, DBEntityMemberIdAndRole.GET_ROLE));
            EntityType type = (EntityType)Iterables.getOnlyElement((Iterable)ImmutableSet.copyOf((Iterable)Iterables.transform(input, DBEntityMemberIdAndRoleWithEntityType.GET_ENTITY_TYPE)));
            return new EntityMemberWithEntityType(personId, entityId, (Iterable<EntityMemberRole>)roles, type, EntityMember.InheritanceType.NONE);
        }
    };
    private static final Function<Collection<DBEntityMemberIdAndRoleWithPerson>, EntityMemberWithPerson> TO_BUSINESS_PERSON = new Function<Collection<DBEntityMemberIdAndRoleWithPerson>, EntityMemberWithPerson>(){

        public EntityMemberWithPerson apply(@Nullable Collection<DBEntityMemberIdAndRoleWithPerson> input) {
            if (input == null || input.isEmpty()) {
                return null;
            }
            EntityId entityId = this.loadOnlyFieldFromMember(input, DBEntityMemberIdAndRole.GET_ENTITY_ID);
            PersonId personId = this.loadOnlyFieldFromMember(input, DBEntityMemberIdAndRole.GET_PERSON_ID);
            ImmutableSet roles = ImmutableSet.copyOf((Iterable)Iterables.transform(input, DBEntityMemberIdAndRole.GET_ROLE));
            Boolean active = this.loadOnlyFieldFromMember(input, DBEntityMemberIdAndRoleWithPerson.IS_ACTIVE);
            Boolean hasImage = this.loadOnlyFieldFromMember(input, DBEntityMemberIdAndRoleWithPerson.HAS_IMAGE);
            String firstname = this.loadOnlyFieldFromMember(input, DBEntityMemberIdAndRoleWithPerson.FIRSTNAME);
            String lastname = this.loadOnlyFieldFromMember(input, DBEntityMemberIdAndRoleWithPerson.LASTNAME);
            String title = this.loadOnlyFieldFromMember(input, DBEntityMemberIdAndRoleWithPerson.TITLE);
            String additionalTitle = this.loadOnlyFieldFromMember(input, DBEntityMemberIdAndRoleWithPerson.ADDITIONAL_TITLE);
            return new EntityMemberWithPerson(personId, entityId, (Iterable<EntityMemberRole>)roles, active, hasImage, EntityMember.InheritanceType.NONE, Strings.nullToEmpty((String)firstname), Strings.nullToEmpty((String)lastname), title, additionalTitle);
        }

        @Nonnull
        @ParametersAreNonnullByDefault
        private <T> T loadOnlyFieldFromMember(Collection<DBEntityMemberIdAndRoleWithPerson> members, Function<? super DBEntityMemberIdAndRoleWithPerson, T> fieldFunction) {
            return (T)Iterables.getOnlyElement((Iterable)ImmutableSet.copyOf((Iterable)Iterables.transform(members, fieldFunction)));
        }
    };
    private final EntityMemberRoleDAO _entityMemberRoleDAO;

    @Autowired
    @ParametersAreNonnullByDefault
    public IbatisEntityMemberDAO(EntityMemberRoleDAO entityMemberRoleDAO) {
        this._entityMemberRoleDAO = entityMemberRoleDAO;
    }

    @Override
    public ImmutableList<DBPersonRelation> getMembersOfSameEntityOfPersons(Set<? extends PersonId> personIds) {
        return this._entityMemberRoleDAO.getMembersOfSameEntityOfPersons(personIds);
    }

    @Nonnull
    private Iterable<EntityMemberWithEntityType> toBusinessEntityType(@Nonnull Iterable<DBEntityMemberIdAndRoleWithEntityType> dbRoles) {
        Iterable unfiltered = Iterables.transform((Iterable)Multimaps.index(dbRoles, GROUP_BY_ENTITY_AND_PERSON).asMap().values(), TO_BUSINESS_ENTITY_TYPE);
        return Iterables.filter((Iterable)unfiltered, (Predicate)Predicates.notNull());
    }

    @Nonnull
    private Iterable<EntityMemberWithPerson> toBusinessPerson(@Nonnull Iterable<DBEntityMemberIdAndRoleWithPerson> dbRoles) {
        Iterable unfiltered = Iterables.transform((Iterable)Multimaps.index(dbRoles, GROUP_BY_ENTITY_AND_PERSON).asMap().values(), TO_BUSINESS_PERSON);
        return Iterables.filter((Iterable)unfiltered, (Predicate)Predicates.notNull());
    }

    @Override
    public Iterable<EntityMemberWithPerson> getByEntityIds(Set<? extends EntityId> entityIds) {
        return this.toBusinessPerson((Iterable<DBEntityMemberIdAndRoleWithPerson>)this._entityMemberRoleDAO.getByEntityIds(entityIds));
    }

    @Override
    public Iterable<EntityMemberWithEntityType> getByPersonIds(Set<? extends PersonId> personIds) {
        return this.toBusinessEntityType((Iterable<DBEntityMemberIdAndRoleWithEntityType>)this._entityMemberRoleDAO.getByPersonIds(personIds));
    }
}

