/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.BatchStatementProcessor;
import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStandardResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeId;
import de.justsoftware.onx.container.integration.persistence.EntityDynamicAttributeDAO;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.db.DBEntityDynamicAttribute;
import de.justsoftware.onx.container.shared.server.model.EntityDynamicAttribute;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
public class IbatisEntityDynamicAttributeDAO
implements EntityDynamicAttributeDAO {
    private static final String NAMESPACE = "EntityDynamicAttribute.";
    private final IbatisStatementBuilder _ibatisBuilder;
    @Autowired
    @Qualifier(value="sqlMapClient")
    private SqlMapClient _sqlMapper;

    public IbatisEntityDynamicAttributeDAO(@Nonnull StatementBuilderFactory statementBuilderFactory) {
        this._ibatisBuilder = statementBuilderFactory.ibatistStatementBuilder("EntityDynamicAttribute");
    }

    @Override
    public void insertAttributes(List<EntityDynamicAttribute> attributes) {
        IbatisDAOUtil.executeInBatch(this._sqlMapper, attributes, 1000, new BatchStatementProcessor<EntityDynamicAttribute>(){

            @Override
            public void process(SqlMapClient client, EntityDynamicAttribute attr) throws SQLException {
                int position = 0;
                for (String value : attr.getValues()) {
                    DBEntityDynamicAttribute dbAttr = new DBEntityDynamicAttribute(attr.getEntityId(), attr.getAttributeId(), value, position);
                    client.insert("EntityDynamicAttribute.insertDynamicAttribute", (Object)dbAttr);
                    ++position;
                }
            }
        });
    }

    @Override
    public ImmutableListMultimap<EntityId, EntityDynamicAttribute> getDynamicAttributesForEntities(Set<EntityId> entityIds) {
        ImmutableListMultimap dbResults = IbatisDAOUtil.wrappedPartitionQueryForMultimap(this._sqlMapper, "EntityDynamicAttribute.selectDynamicAttributesForEntities", "entityId", entityIds, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
        ImmutableListMultimap.Builder resultBuilder = ImmutableListMultimap.builder();
        for (Map.Entry entry : dbResults.asMap().entrySet()) {
            ImmutableListMultimap.Builder valuesMap = ImmutableListMultimap.builder();
            for (DBEntityDynamicAttribute attribute : (Collection)entry.getValue()) {
                String attributeValue = attribute.getValue();
                if (attributeValue == null) continue;
                valuesMap.put((Object)attribute.getAttributeId(), (Object)attributeValue);
            }
            for (Map.Entry valuesMapEntry : valuesMap.build().asMap().entrySet()) {
                resultBuilder.put((Object)((EntityId)entry.getKey()), (Object)new EntityDynamicAttribute((EntityId)entry.getKey(), (DynamicAttributeId)valuesMapEntry.getKey(), (ImmutableList<String>)ImmutableList.copyOf((Collection)((Collection)valuesMapEntry.getValue()))));
            }
        }
        return resultBuilder.build();
    }

    @Override
    public void deleteAttributesForEntity(EntityId entityId, ImmutableSet<DynamicAttributeId> configuredDynamicAttributeIds) {
        if (configuredDynamicAttributeIds.isEmpty()) {
            return;
        }
        IbatisDAOUtil.wrappedDelete(this._sqlMapper, "EntityDynamicAttribute.deleteForEntity", ImmutableMap.of((Object)"entityId", (Object)entityId, (Object)"attributeIds", IbatisDAOUtil.toIbatisList(configuredDynamicAttributeIds)));
    }

    @Override
    public ImmutableSet<EntityId> getEntityIdsWithDynamicAttributes(Iterable<DynamicAttributeId> entityDynamicAttributeIds, Set<String> values) {
        return ((IbatisStandardResultBuilder)this._ibatisBuilder.selectDbSpecific("selectEntityIdsWithDynamicAttributes").param("ids", IbatisDAOUtil.toIbatisList(entityDynamicAttributeIds), "values", IbatisDAOUtil.toIbatisList(values))).asSet();
    }
}

