/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.integration.persistence.ibatis;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStandardResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.container.integration.persistence.EntityAnchorDAO;
import de.justsoftware.onx.container.shared.model.EntityAnchorComponent;
import de.justsoftware.onx.container.shared.model.EntityId;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class IbatisEntityAnchorDAO
implements EntityAnchorDAO {
    private final IbatisStatementBuilder _statementBuilder;

    @Autowired
    public IbatisEntityAnchorDAO(StatementBuilderFactory statementBuilderFactory) {
        this._statementBuilder = statementBuilderFactory.ibatistStatementBuilder("EntityAnchor");
    }

    @Override
    public void insertEntityAnchors(final EntityId entityId, final EntityAnchorComponent component, final Set<String> anchors) {
        this._statementBuilder.batch(new IbatisStatementBuilder.BatchCallback(){

            @Override
            public void execute(SqlMapClient sqlMapClient) {
                IbatisEntityAnchorDAO.this._statementBuilder.delete("deleteEntityAnchor").param("entityId", entityId, "component", (Object)component);
                for (String anchor : anchors) {
                    IbatisEntityAnchorDAO.this._statementBuilder.insert("insertEntityAnchor").param("entityId", entityId, "component", (Object)component, "anchor", anchor);
                }
            }
        });
    }

    @Override
    public ImmutableSetMultimap<EntityId, String> getAnchorsByEntityIds(Set<EntityId> entityIds) {
        return ((IbatisPartitionResultBuilder)this._statementBuilder.select("selectByEntityIds").partition(entityIds)).asSetMultimap("entityId", "anchor");
    }

    @Override
    public ImmutableSet<EntityAnchorComponent> getComponentTypeByEntityIdAndAnchor(EntityId entityId, String anchor) {
        return ((IbatisStandardResultBuilder)this._statementBuilder.select("selectComponentByEntityIdAndAnchor").param("entityId", entityId, "anchor", anchor)).asSet();
    }
}

