/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.model;

import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Ordering;
import de.justsoftware.onx.common.shared.model.IEntityVersion;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import de.justsoftware.onx.container.shared.model.EntityStatusImpl;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.EntityVersionType;
import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.Nonnull;

public class EntityVersion
implements IEntityVersion,
Serializable {
    public static final Function<IEntityVersion, EntityVersion> TO_ENTITY_VERSION = new Function<IEntityVersion, EntityVersion>(){

        public EntityVersion apply(IEntityVersion input) {
            return input != null ? new EntityVersion(input) : null;
        }
    };
    public static final Function<EntityVersion, EntityStatus> TO_ENTITY_STATUS = new Function<EntityVersion, EntityStatus>(){

        public EntityStatus apply(EntityVersion input) {
            return input != null ? input.getStatus() : null;
        }
    };
    public static final Ordering<EntityVersion> ENTITY_VERSION_ID_ORDERING = new Ordering<EntityVersion>(){

        public int compare(EntityVersion left, EntityVersion right) {
            return left._id.compareTo(right._id);
        }
    };
    private static final int HASH_SALT = -859048600;
    private static final long serialVersionUID = 1L;
    private final EntityVersionId _id;
    private final EntityId _entityId;
    private final PersonId _authorId;
    private final int _majorVersion;
    private final int _minorVersion;
    private final int _draftVersion;
    private final String _changeMessage;
    private final String _commentForReviewers;
    private final String _declineMessage;
    private final EntityStatus _status;
    private final EntityVersionType _versionType;
    private final EntityVersionType _targetType;
    private final DateWithoutTimezone _releaseDate;
    private final DateWithoutTimezone _expirationDate;
    private final DateWithoutTimezone _creationDate;
    private final DateWithoutTimezone _modificationDate;
    private final int _hashCode;
    private final Object[] _hashObjects;

    public EntityVersion(@Nonnull IEntityVersion origin) {
        this._id = origin.getId();
        this._hashObjects = new Object[]{this._id};
        this._hashCode = 0xCCCBF568 ^ Arrays.hashCode(this._hashObjects);
        this._entityId = origin.getEntityId();
        this._authorId = origin.getAuthorId();
        this._majorVersion = origin.getMajorVersion();
        this._minorVersion = origin.getMinorVersion();
        this._draftVersion = origin.getDraftVersion();
        this._changeMessage = origin.getChangeMessage();
        this._commentForReviewers = origin.getCommentForReviewers();
        this._declineMessage = origin.getDeclineMessage();
        this._status = (EntityStatus)EntityStatusImpl.TO_BUSINESS_MODEL.apply((Object)origin.getStatus());
        this._versionType = origin.getVersionType();
        this._targetType = origin.getTargetType();
        this._releaseDate = origin.getReleaseDate();
        this._expirationDate = origin.getExpirationDate();
        this._creationDate = origin.getCreationDate();
        this._modificationDate = origin.getModificationDate();
    }

    @Override
    public EntityVersionId getId() {
        return this._id;
    }

    @Override
    public EntityId getEntityId() {
        return this._entityId;
    }

    @Override
    public PersonId getAuthorId() {
        return this._authorId;
    }

    @Override
    public int getMajorVersion() {
        return this._majorVersion;
    }

    @Override
    public int getMinorVersion() {
        return this._minorVersion;
    }

    @Override
    public int getDraftVersion() {
        return this._draftVersion;
    }

    @Override
    public String getChangeMessage() {
        return this._changeMessage;
    }

    @Override
    public String getCommentForReviewers() {
        return this._commentForReviewers;
    }

    @Override
    public String getDeclineMessage() {
        return this._declineMessage;
    }

    @Override
    public EntityStatus getStatus() {
        return this._status;
    }

    @Override
    public EntityVersionType getVersionType() {
        return this._versionType;
    }

    @Override
    @Deprecated
    public EntityVersionType getTargetType() {
        return this._targetType;
    }

    @Override
    public DateWithoutTimezone getReleaseDate() {
        return DateWithoutTimezone.clone(this._releaseDate);
    }

    @Override
    public DateWithoutTimezone getExpirationDate() {
        return DateWithoutTimezone.clone(this._expirationDate);
    }

    @Override
    public String getVersionString() {
        return this._majorVersion + "." + this._minorVersion + "." + this._draftVersion;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", (Object)this.getVersionString()).add("id", (Object)this._id).add("entityId", (Object)this._entityId).add("authorId", (Object)this._authorId).add("changeMessage", (Object)this._changeMessage).add("commentForReviewers", (Object)this._commentForReviewers).add("declineMessage", (Object)this._declineMessage).add("status", (Object)this._status).add("versionType", (Object)this._versionType).add("targetType", (Object)this._targetType).add("releaseDate", (Object)this._releaseDate).add("expirationDate", (Object)this._expirationDate).add("creationDate", (Object)this._creationDate).add("modificationDate", (Object)this._modificationDate).toString();
    }

    @Override
    public DateWithoutTimezone getCreationDate() {
        return DateWithoutTimezone.clone(this._creationDate);
    }

    @Override
    public DateWithoutTimezone getModificationDate() {
        return DateWithoutTimezone.clone(this._modificationDate);
    }

    public final int hashCode() {
        return this._hashCode;
    }

    public final boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass().equals(obj.getClass()) && Arrays.equals(this._hashObjects, ((EntityVersion)obj)._hashObjects);
    }
}

