/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.model.action.StaticItemAction;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.ComponentTypes;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.StartpageTeaserService;
import de.justsoftware.onx.container.shared.model.ComponentPositionConfig;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityTeaserStartpageComponent;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.like.business.LikeService;
import de.justsoftware.onx.person.shared.model.startpage.EmptyStartpageComponent;
import de.justsoftware.onx.person.shared.model.startpage.EntityTeaserStartpageComponentConf;
import de.justsoftware.onx.person.shared.model.startpage.StartpageComponent;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StartpageTeaserServiceImpl
implements StartpageTeaserService {
    private final LikeService _likeService;
    private final EntityService _entityService;

    @Autowired
    @ParametersAreNonnullByDefault
    public StartpageTeaserServiceImpl(LikeService likeService, EntityService entityService) {
        this._likeService = likeService;
        this._entityService = entityService;
    }

    @Override
    public StartpageComponent getTeaserForStartpage(EntityTeaserStartpageComponentConf c, AuthorizationCheckContextWithUserId authCtx) {
        EntityId entityId = c.getEntityId();
        DBEntity entity = this._entityService.getById(entityId);
        if (entity == null) {
            return EmptyStartpageComponent.EMPTY;
        }
        EntityItem entityItem = new EntityItem(entity);
        if (!authCtx.may((Item<?>)entityItem, (Action)StaticEntityAction.ENTITY_READ_DETAILS)) {
            return EmptyStartpageComponent.EMPTY;
        }
        if (!(!c.isSubscriptionRequired() || this._likeService.isSubscribed((Iterable<? extends Item<?>>)ImmutableList.of((Object)entityItem), authCtx.getUserId()) && authCtx.may((Item<?>)entityItem, (Action)StaticItemAction.LIKE_SUBSCRIBE))) {
            return EmptyStartpageComponent.EMPTY;
        }
        Map<ComponentType, ComponentPositionConfig> components = this._entityService.getAllowedComponentsByEntity(entityItem, authCtx);
        EntityType childType = c.getChildType();
        ComponentPositionConfig component = components.get(ComponentTypes.childEntities(childType));
        return new EntityTeaserStartpageComponent(entityId, childType, c.getOrder(), c.getTeaserType(), c.getPageSize(), component == null ? null : component.getCustomizedTitle());
    }
}

