/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.business.EntityMemberReadDataService;
import de.justsoftware.onx.container.business.RandomEntityMemberService;
import de.justsoftware.onx.container.shared.model.EntityId;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class RandomEntityMemberServiceImpl
implements RandomEntityMemberService {
    private final EntityMemberReadDataService _entityMemberReadDataService;

    @Autowired
    public RandomEntityMemberServiceImpl(EntityMemberReadDataService entityMemberReadDataService) {
        this._entityMemberReadDataService = entityMemberReadDataService;
    }

    @Override
    public ImmutableSet<PersonId> getRandomMemberIds(EntityId id, int count) {
        ImmutableSet randomSublist = ImmutableSet.copyOf(CollectionUtil.randomSublist(this._entityMemberReadDataService.getMemberIdsWithProfileImage(id), count));
        int unusedSpace = count - randomSublist.size();
        if (unusedSpace <= 0) {
            return randomSublist;
        }
        return ImmutableSet.builder().addAll((Iterable)randomSublist).addAll(CollectionUtil.randomSublist(this._entityMemberReadDataService.getMemberIdsWithoutProfileImage(id), unusedSpace)).build();
    }
}

