/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.AuthorizationContextWithUserId;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.MyContentsService;
import de.justsoftware.onx.container.business.MyContentsReadDataService;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.MyContentEntity;
import de.justsoftware.onx.searchnew.shared.model.SearchConfigurationProvider;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class MyContentsServiceImpl
implements MyContentsService {
    private final Settings _settings;
    private final EntityConfigService _entityConfigService;
    private final MyContentsReadDataService _readDataService;

    @Autowired
    public MyContentsServiceImpl(Settings settings, EntityConfigService entityConfigService, SearchConfigurationProvider searchConfigurationProvider, MyContentsReadDataService readDataService) {
        this._settings = settings;
        this._entityConfigService = entityConfigService;
        this._readDataService = readDataService;
    }

    @Override
    public ImmutableListMultimap<EntityType, MyContentEntity> getMyContents(Set<EntityType> entityTypes, SearchAuthorizationCheckContext authContext) {
        final PersonId userId = authContext.getUserId();
        if (entityTypes.isEmpty()) {
            return ImmutableListMultimap.of();
        }
        final int fetchCount = this._settings.getMyContentTeaserCount();
        return FluentIterable.from(entityTypes).filter(this._entityConfigService.entityTypeActivated()).transformAndConcat((Function)new NullPermeableFunction<EntityType, Iterable<MyContentEntity>>(){

            @Override
            protected Iterable<MyContentEntity> applySafe(EntityType type) {
                return MyContentsServiceImpl.this.getMyContentsFromDataService(userId, fetchCount, (Set<EntityType>)ImmutableSet.of((Object)type));
            }
        }).filter(Predicates.notNull()).index(MyContentEntity::getType);
    }

    @Override
    public ImmutableList<MyContentEntity> getMySubscribedPages(EntityType rootEntityType, AuthorizationContextWithUserId authContext) {
        PersonId userId = authContext.getUserId();
        ImmutableSet rootEntityTypes = ImmutableSet.of((Object)rootEntityType);
        int maxCount = this._settings.getMyContentTeaserCount();
        ImmutableSet<EntityType> activatedEntityTypes = this._entityConfigService.getOrderedActivatedEntityTypes();
        ImmutableList<MyContentEntity> subscribedRootEntities = activatedEntityTypes.contains((Object)rootEntityType) ? this.getMyContentsFromDataService(userId, maxCount, (Set<EntityType>)rootEntityTypes) : ImmutableList.of();
        int remainingCount = maxCount - subscribedRootEntities.size();
        ImmutableList<MyContentEntity> subscribedOtherEntities = this.getMyContentsFromDataService(userId, remainingCount, (Set<EntityType>)Sets.difference(activatedEntityTypes, (Set)rootEntityTypes));
        return FluentIterable.from(subscribedRootEntities).append(subscribedOtherEntities).toList();
    }

    @Override
    public ImmutableList<MyContentEntity> getSubscriptionsByTypes(Set<EntityType> entityTypes, int teaserCount, AuthorizationContext authContext) {
        if (entityTypes.isEmpty() || teaserCount <= 0) {
            return ImmutableList.of();
        }
        return this._readDataService.getSubscribedMyContent(authContext.getUserId(), (ImmutableSet<EntityType>)ImmutableSet.copyOf(entityTypes), teaserCount);
    }

    @Nonnull
    private ImmutableList<MyContentEntity> getMyContentsFromDataService(PersonId subscriberId, int teaserCount, Set<EntityType> entityTypes) {
        return teaserCount > 0 && !entityTypes.isEmpty() ? this._readDataService.getSubscribedMyContent(subscriberId, (ImmutableSet<EntityType>)ImmutableSet.copyOf(entityTypes), teaserCount) : ImmutableList.of();
    }
}

