/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.business.ItemPublishService;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.toolbox.kafka.client.KafkaCleaningProducer;
import de.justsoftware.toolbox.kafka.client.KafkaCleaningProducerState;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class ItemPublishServiceImpl
implements ItemPublishService {
    private static final Logger LOG = LoggerFactory.getLogger(ItemPublishServiceImpl.class);
    private static final String ITEMS_TOPIC = "just.items";
    @CheckForNull
    private final KafkaCleaningProducer<String, String> _producer;

    @Autowired
    public ItemPublishServiceImpl(@Nullable @Qualifier(value="KAFKA_STRING_PRODUCER") KafkaCleaningProducer<String, String> producer) {
        this._producer = producer;
    }

    @Nonnull
    private static Callback callback(String text) {
        return (metadata, exception) -> {
            if (exception != null) {
                LOG.error(text, (Throwable)exception);
            }
        };
    }

    @Override
    public void publishItemDeletions(Set<? extends ItemId> deletedItems) {
        if (this._producer != null) {
            deletedItems.forEach(this::publishDelete);
        }
    }

    private void publishDelete(ItemId itemId) {
        this._producer.send(this.record(itemId, null), ItemPublishServiceImpl.callback("could not publish delete"));
    }

    @Nonnull
    private ProducerRecord<String, String> record(ItemId itemId, @Nullable String value) {
        return new ProducerRecord(ITEMS_TOPIC, (Object)itemId.asString(), (Object)value);
    }

    @Override
    public void publishItem(ItemId itemId, String name, boolean newVersionPublic, PersonId admin) {
        if (this._producer != null) {
            JSONObject value = new JSONObject();
            value.put("name", (Object)name);
            value.put("newVersionPublic", newVersionPublic);
            if (admin != null) {
                value.put("admin", admin.getId());
            }
            this._producer.send(this.record(itemId, value.toString()), ItemPublishServiceImpl.callback("could not publish entity"));
        }
    }

    @Override
    public boolean isReady() {
        return this._producer != null;
    }

    @Override
    public KafkaCleaningProducerState<String> beginRefill() {
        if (this._producer == null) {
            throw new IllegalStateException("Producer is not ready you have to check by calling isReady()!");
        }
        return this._producer.beginRefill(new String[]{ITEMS_TOPIC});
    }

    @Override
    public boolean keyHasType(String key, ItemType itemType) {
        return key != null && key.startsWith(itemType.name() + ",");
    }
}

