/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.google.common.collect.Sets;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.container.business.ItemDeletionExportHandler;
import de.justsoftware.onx.container.business.ItemPublishService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ItemDeletionExportHandlerImpl
implements ItemDeletionExportHandler {
    private final ItemPublishService _itemEventPublishService;

    @Autowired
    public ItemDeletionExportHandlerImpl(ItemPublishService itemEventPublishService) {
        this._itemEventPublishService = itemEventPublishService;
    }

    @Override
    public void handleCascadeDelete(Set<? extends ItemId> parentIds, DeletionContext deletionContext) {
        this._itemEventPublishService.publishItemDeletions(Sets.filter(parentIds, ItemDeletionExportHandlerImpl::shouldBePublished));
    }

    private static final boolean shouldBePublished(ItemId itemId) {
        return itemId instanceof EntityId || itemId instanceof WorkstreamMessageId || itemId instanceof ConversationId;
    }
}

