/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.freiheit.toro.cache.CacheClient;
import com.freiheit.toro.cache.ehcache.EhCacheName;
import com.freiheit.toro.cache.ehcache.EhcacheClient;
import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import de.justsoftware.onx.common.cache.AbstractListLoadingCacheAccessor;
import de.justsoftware.onx.common.cache.AbstractSetMultiMapCacheAccessor;
import de.justsoftware.onx.common.shared.model.IEntityVersion;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.business.EntityVersionReadWriteDataService;
import de.justsoftware.onx.container.business.EntityWriteDataService;
import de.justsoftware.onx.container.business.model.EntityVersion;
import de.justsoftware.onx.container.integration.persistence.EntityVersionDAO;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import de.justsoftware.onx.container.shared.model.EntityStatusId;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.EntityVersionType;
import de.justsoftware.onx.container.shared.model.db.DBEntityVersion;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class EntityVersionReadWriteDataServiceImpl
implements EntityVersionReadWriteDataService {
    private final EntityVersionByEntityIdCacheAccessor _entityIdCache;
    private final EntityVersionByIdCacheAccessor _idCache;
    private final EntityVersionDAO _entityVersionDao;
    private final EntityWriteDataService _entityWriteDataService;

    @Autowired
    public EntityVersionReadWriteDataServiceImpl(EhcacheClient ehcacheClient, EntityVersionDAO entityVersionDao, EntityWriteDataService entityWriteDataService) {
        this._entityWriteDataService = entityWriteDataService;
        this._entityIdCache = new EntityVersionByEntityIdCacheAccessor(ehcacheClient, entityVersionDao);
        this._idCache = new EntityVersionByIdCacheAccessor(ehcacheClient, entityVersionDao);
        this._entityVersionDao = entityVersionDao;
    }

    @Override
    public ImmutableMultimap<EntityId, EntityVersion> getNewestVersionByStatus(Set<EntityId> entityIds, Set<EntityStatus> status) {
        Predicate statusPredicate = status.isEmpty() ? Predicates.alwaysTrue() : Predicates.compose((Predicate)Predicates.in(status), EntityVersion.TO_ENTITY_STATUS);
        return ImmutableMultimap.copyOf((Multimap)Multimaps.filterValues(this.getNewestVersions(entityIds), (Predicate)statusPredicate));
    }

    @Override
    public ImmutableSetMultimap<EntityId, EntityVersion> getNewestVersions(Set<EntityId> entityIds) {
        return (ImmutableSetMultimap)this._entityIdCache.getMultiMap(entityIds);
    }

    @Override
    public ImmutableMap<EntityStatus, EntityVersion> getNewestVersionByStatus(EntityId entityId, Set<EntityStatus> status) {
        return Maps.uniqueIndex((Iterable)this.getNewestVersionByStatus((Set<EntityId>)ImmutableSet.of((Object)entityId), status).get((Object)entityId), EntityVersion.TO_ENTITY_STATUS);
    }

    @Override
    public EntityVersionId create(DBEntityVersion entityVersion) {
        EntityVersionId versionId = this._entityVersionDao.create(entityVersion);
        this.clearCacheForEntityId((Set<EntityId>)ImmutableSet.of((Object)entityVersion.getEntityId()));
        return versionId;
    }

    @Override
    public ImmutableSet<EntityVersion> getNewestVersions(EntityId entityId) {
        return (ImmutableSet)this._entityIdCache.getSingle(entityId);
    }

    @Override
    public void update(DBEntityVersion entityVersion) {
        this._entityVersionDao.update(entityVersion);
        this.clearCacheForEntityId((Set<EntityId>)ImmutableSet.of((Object)entityVersion.getEntityId()));
        this._idCache.invalidateKey(entityVersion.getId());
    }

    @Override
    public void delete(EntityVersionId versionId) {
        EntityVersion versionToDelete = this.getById(versionId);
        this._entityVersionDao.deleteVersion(versionId);
        this._idCache.invalidateKey(versionId);
        if (versionToDelete != null) {
            this.clearCacheForEntityId((Set<EntityId>)ImmutableSet.of((Object)versionToDelete.getEntityId()));
        }
    }

    @Override
    public void deleteVersions(Set<EntityVersionId> versionsToDelete) {
        ImmutableSet affectedEntityIds = FluentIterable.from(this._idCache.getList(versionsToDelete)).transform(IEntityVersion.GET_ENTITY_ID).toSet();
        this._entityVersionDao.deleteVersionsById(versionsToDelete);
        this._idCache.invalidateKeys(versionsToDelete);
        this.clearCacheForEntityId((Set<EntityId>)affectedEntityIds);
    }

    @Override
    public void updateStatusForEntityVersions(EntityId entityId, Set<EntityStatus> withStatus, EntityStatus targetStaus) {
        this._entityVersionDao.updateStatusForEntityVersions(entityId, withStatus, targetStaus);
        this.clearCacheForEntityId((Set<EntityId>)ImmutableSet.of((Object)entityId));
        this._idCache.invalidateKeys(Iterables.transform(this._entityIdCache.getSingle(entityId), IEntityVersion.GET_ID));
    }

    @Override
    public void updateStatus(EntityVersionId entityVersionId, EntityStatus targetStatus) {
        EntityVersion version = this.getById(entityVersionId);
        if (version != null) {
            this._entityVersionDao.updateStatus(entityVersionId, targetStatus);
            this.clearCacheForEntityId((Set<EntityId>)ImmutableSet.of((Object)version.getEntityId()));
            this._idCache.invalidateKey(entityVersionId);
        }
    }

    @Override
    public void clearCacheForEntityId(Set<EntityId> affectedEntityIds) {
        this._entityIdCache.invalidateKeys(affectedEntityIds);
        this._entityWriteDataService.deleteEntityCache(affectedEntityIds);
    }

    @Override
    public void clearIdCacheForVersions(Set<EntityVersionId> versionIds) {
        this._idCache.invalidateKeys(versionIds);
    }

    @Override
    public EntityVersion getById(EntityVersionId entityVersionId) {
        return (EntityVersion)this._idCache.getSingle(entityVersionId);
    }

    @Override
    public ImmutableMap<EntityVersionId, EntityVersion> getByIdsAsMap(Set<EntityVersionId> entityVersionIds) {
        return this._idCache.getMap(entityVersionIds);
    }

    @Override
    public void updateStatusOfVersionsWithStatus(Set<EntityStatusId> currentStatus, EntityStatus targetStatus) {
        this._entityVersionDao.updateStatusOfVersionsWithStatus(currentStatus, targetStatus);
        this._idCache.invalidateAll();
        this._entityIdCache.invalidateAll();
    }

    @Override
    public ListAndCount<EntityVersion> getDeclinedForPerson(int offset, int limit, PersonId personId) {
        return this._entityVersionDao.getDeclinedForPerson(offset, limit, personId);
    }

    @Override
    public void updateReadDateByEntityVersionId(EntityVersionId id, DateWithoutTimezone readDate) {
        EntityVersion version = this.getById(id);
        if (version != null) {
            this.clearCacheForEntityId((Set<EntityId>)ImmutableSet.of((Object)version.getEntityId()));
        }
        this._entityVersionDao.updateReadDateByEntityVersionId(id, readDate);
    }

    @Override
    public int countVersionsForEntity(EntityId entityId, Iterable<EntityStatus> status) {
        return this._entityVersionDao.countVersionsForEntity(entityId, status);
    }

    @Override
    public ImmutableList<EntityVersion> getVersionsForEntity(EntityId entityId, Iterable<EntityStatus> status, int offset, int limit) {
        return this._entityVersionDao.getVersionsForEntity(entityId, status, offset, limit);
    }

    @Override
    public EntityVersionId getLatestVersionByType(EntityId entityId, EntityVersionType versionType) {
        return this._entityVersionDao.getLatestVersionByType(entityId, versionType);
    }

    @Override
    public void updateForImport(DBEntityVersion version) {
        this._entityVersionDao.updateForImport(version);
        this.clearCacheForEntityId((Set<EntityId>)ImmutableSet.of((Object)version.getEntityId()));
    }

    @Override
    public EntityVersion getLastNonDraftVersionBefore(EntityVersionId versionId) {
        return this._entityVersionDao.getLastNonDraftVersionBefore(versionId);
    }

    @Override
    public ListAndCount<EntityId> getEntityDraftsForAuthor(int offset, int limit, PersonId authorId) {
        return this._entityVersionDao.getEntityDraftsForAuthor(offset, limit, authorId);
    }

    @Override
    public int getDraftCountForAuthor(PersonId authorId) {
        return this._entityVersionDao.getDraftCountForAuthor(authorId);
    }

    @Override
    public EntityVersionId getFirstVersionForEntity(EntityId entityId) {
        return this._entityVersionDao.getFirstVersionForEntity(entityId);
    }

    @ParametersAreNonnullByDefault
    private static class EntityVersionByIdCacheAccessor
    extends AbstractListLoadingCacheAccessor<EntityVersionEhCacheName, EntityVersionId, EntityVersion> {
        private final EntityVersionDAO _dao;

        protected EntityVersionByIdCacheAccessor(CacheClient<? super EntityVersionEhCacheName> cache, EntityVersionDAO dao) {
            super(cache, EntityVersionEhCacheName.VERSION_BY_ID);
            this._dao = dao;
        }

        @Override
        protected Iterable<? extends EntityVersion> getListFromDatabase(Set<? extends EntityVersionId> inputs) {
            return this._dao.getVersionsByIds(inputs);
        }

        @Override
        protected String keyToString(EntityVersionId key) {
            return key.toString();
        }

        @Override
        protected EntityVersionId objectToKey(EntityVersion dbResult) {
            return dbResult.getId();
        }
    }

    @ParametersAreNonnullByDefault
    private static class EntityVersionByEntityIdCacheAccessor
    extends AbstractSetMultiMapCacheAccessor<EntityVersionEhCacheName, EntityId, EntityVersion> {
        private final EntityVersionDAO _dao;

        protected EntityVersionByEntityIdCacheAccessor(CacheClient<? super EntityVersionEhCacheName> cache, EntityVersionDAO dao) {
            super(cache, EntityVersionEhCacheName.NEWEST_VERSION_BY_STATUS);
            this._dao = dao;
        }

        @Override
        protected EntityId objectToKey(EntityVersion result) {
            return result.getEntityId();
        }

        @Override
        protected Iterable<? extends EntityVersion> getListFromDatabase(Set<? extends EntityId> inputs) {
            return this._dao.getNewestVersionsForEntity(inputs);
        }

        @Override
        protected String keyToString(EntityId key) {
            return key.toString();
        }
    }

    public static enum EntityVersionEhCacheName implements EhCacheName
    {
        NEWEST_VERSION_BY_STATUS("EntityVersion.newestVersionByStatus"),
        VERSION_BY_ID("EntityVersion.versionById");

        private final String _prefix;

        private EntityVersionEhCacheName(String prefix) {
            this._prefix = prefix;
        }

        @Override
        public String getCacheName() {
            return this._prefix;
        }
    }
}

