/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.business.configfile.parser.ConfOption;
import de.justsoftware.onx.common.business.configfile.parser.ConfOptionsFor;
import de.justsoftware.onx.common.shared.model.AuthorityModel;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.container.shared.model.ComponentPosition;
import javax.annotation.Nonnull;

public class EntityTypeAllowedComponent {
    private final ComponentType _componentType;
    private final ComponentPosition _position;
    private final int _defaultOrder;
    private final ConfOptionsFor _options;
    private final boolean _defaultVisible;

    public EntityTypeAllowedComponent(@Nonnull ComponentType componentType, @Nonnull ComponentPosition position, int defaultOrder, @Nonnull ConfOptionsFor options, boolean defaultVisible) {
        this._componentType = componentType;
        this._position = position;
        this._defaultOrder = defaultOrder;
        this._options = options;
        this._defaultVisible = defaultVisible;
    }

    @Nonnull
    public ComponentType getComponentType() {
        return this._componentType;
    }

    @Nonnull
    public ComponentPosition getPosition() {
        return this._position;
    }

    public int getDefaultOrder() {
        return this._defaultOrder;
    }

    public boolean isDefaultVisible() {
        return this._defaultVisible;
    }

    @Nonnull
    public ConfOptionsFor getOptions() {
        return this._options;
    }

    @Nonnull
    public ImmutableSet<AuthorityModel> getOptionsAsAuthorityModels() {
        return FluentIterable.from((Iterable)this._options.getOptions().values()).transform(ConfOption.GET_AUTHORITY_MODEL).toSet();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this._componentType).addValue((Object)this._position).addValue((Object)this._defaultOrder).addValue((Object)this._options).addValue((Object)this._defaultVisible).toString();
    }
}

