/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.freiheit.toro.common.shared.server.util.StringUtil;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.EntityTeaserService;
import de.justsoftware.onx.container.business.EntityVersionService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityTeaser;
import de.justsoftware.onx.container.shared.model.EntityTeaserBean;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.db.DBEntityComponent;
import de.justsoftware.onx.container.shared.model.teasers.MemoTeaser;
import de.justsoftware.onx.container.shared.model.teasers.TeaserType;
import de.justsoftware.onx.container.shared.model.teasers.TeaserTypeVisitor;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.multiwiki.business.MultiWikiService;
import de.justsoftware.onx.wikieditor.business.WikiEditorService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EntityTeaserServiceImpl
implements EntityTeaserService {
    private static final int TEASER_MAX_TEXT_LENGTH = 130;
    private final EntityService _entityService;
    private final EntityVersionService _entityVersionService;
    @Autowired
    private Settings _settings;
    @Autowired
    private MultiWikiService _multiWikiService;
    @Autowired
    private WikiEditorService _wikiEditorService;

    @Autowired
    public EntityTeaserServiceImpl(@Nonnull EntityService entityService, @Nonnull EntityVersionService entityVersionService) {
        this._entityService = entityService;
        this._entityVersionService = entityVersionService;
    }

    @Nonnull
    private ImmutableMap<EntityId, String> resolveUserTeaserText(@Nonnull Map<EntityId, DBEntity> entities, @Nonnull AuthorizationCheckContext authCtx) {
        ImmutableTable<EntityId, ComponentType, DBEntityComponent> componentsByEntity = this._entityService.getComponentsByEntities(entities);
        ImmutableMap.Builder wikis = ImmutableMap.builder();
        ImmutableMap.Builder multiWikis = ImmutableMap.builder();
        for (DBEntity entity : entities.values()) {
            boolean hasMultiWiki;
            EntityId entityId = entity.getId();
            ImmutableMap components = componentsByEntity.row((Object)entityId);
            DBEntityComponent multiWikiComponent = (DBEntityComponent)components.get(StaticComponentType.MULTI_WIKI);
            boolean bl = hasMultiWiki = multiWikiComponent != null && multiWikiComponent.isVisible();
            if (hasMultiWiki) {
                multiWikis.put((Object)entityId, (Object)entity);
                continue;
            }
            DBEntityComponent wikiComponent = (DBEntityComponent)components.get(StaticComponentType.WIKI_EDITOR);
            boolean hasWiki = wikiComponent != null && wikiComponent.isVisible();
            if (!hasWiki) continue;
            wikis.put((Object)entityId, (Object)entity);
        }
        ImmutableMap<EntityId, String> multiWikiTeasers = this._multiWikiService.getTeaserTexts((Map<EntityId, DBEntity>)multiWikis.build(), authCtx);
        ImmutableMap<EntityId, String> wikiTeasers = this._wikiEditorService.getTeaserTexts((Map<EntityId, DBEntity>)wikis.build(), authCtx);
        Map remaining = Maps.filterKeys(entities, (Predicate)Predicates.not((Predicate)Predicates.or((Predicate)Predicates.in((Collection)multiWikiTeasers.keySet()), (Predicate)Predicates.in((Collection)wikiTeasers.keySet()))));
        Map<EntityId, String> descriptionTeasers = this.resolveEntityDescriptionTeaserText(remaining, authCtx);
        ImmutableMap allDescriptions = ImmutableMap.builder().putAll(multiWikiTeasers).putAll(wikiTeasers).putAll(descriptionTeasers).build();
        Map result = Maps.transformValues((Map)allDescriptions, (Function)new Function<String, String>(){

            public String apply(String input) {
                return StringUtil.makeShortDescription(input, 130);
            }
        });
        return ImmutableMap.copyOf((Map)result);
    }

    @Nonnull
    private Map<EntityId, String> resolveEntityDescriptionTeaserText(@Nonnull Map<EntityId, DBEntity> remaining, @Nonnull AuthorizationCheckContext authCtx) {
        if (remaining.isEmpty()) {
            return ImmutableMap.of();
        }
        final ImmutableSetMultimap may = authCtx.may(Iterables.transform(remaining.values(), EntityItem.FROM_DBENTITY), ImmutableSet.of((Object)StaticEntityAction.ENTITY_READ_DETAILS));
        return Maps.transformValues(remaining, (Function)new Function<DBEntity, String>(){

            public String apply(DBEntity entity) {
                return entity != null && may.get((Object)Optional.fromNullable((Object)entity.getId())).contains((Object)StaticEntityAction.ENTITY_READ_DETAILS) ? entity.getDescription() : "";
            }
        });
    }

    @Override
    public List<EntityTeaser> getTeasersByIds(TeaserType teaserType, List<EntityId> entityIdList, AuthorizationCheckContextWithUserId authorizationContext) {
        Map<EntityId, DBEntity> entityMap = this._entityService.getByIds(Sets.newHashSet(entityIdList));
        ImmutableMap<EntityId, EntityInfo> entityInfos = this._entityService.createInfos(entityMap.values(), authorizationContext);
        ImmutableMap<EntityId, String> teaserTexts = this.getTeaserTexts(teaserType, entityMap, authorizationContext);
        ImmutableMap<EntityId, DateWithoutTimezone> publicationDates = this.getPublicationDates(teaserType, entityMap.keySet());
        ImmutableList.Builder builder = ImmutableList.builder();
        for (EntityId entityId : entityIdList) {
            DBEntity entity = entityMap.get(entityId);
            EntityInfo entityInfo = (EntityInfo)entityInfos.get((Object)entityId);
            String teaserText = (String)MoreObjects.firstNonNull((Object)((String)teaserTexts.get((Object)entityId)), (Object)"");
            if (entity == null || entityInfo == null) continue;
            builder.add((Object)new EntityTeaserBean(entityInfo, teaserType, teaserText, (DateWithoutTimezone)publicationDates.get((Object)entityId)));
        }
        return builder.build();
    }

    private ImmutableMap<EntityId, DateWithoutTimezone> getPublicationDates(TeaserType teaserType, final Set<EntityId> entities) {
        if (entities.isEmpty()) {
            return ImmutableMap.of();
        }
        return teaserType.accept(new TeaserTypeVisitor.DefaultTeaserTypeVisitor<ImmutableMap<EntityId, DateWithoutTimezone>>(){

            @Override
            public ImmutableMap<EntityId, DateWithoutTimezone> visitDefault() {
                return ImmutableMap.of();
            }

            @Override
            public ImmutableMap<EntityId, DateWithoutTimezone> visitSlideshowTeaser() {
                return EntityTeaserServiceImpl.this._entityVersionService.getPublicationDates(entities);
            }
        });
    }

    @Override
    public ImmutableMap<EntityId, String> getTeaserTexts(TeaserType teaserType, final Map<EntityId, DBEntity> entities, final AuthorizationCheckContextWithLocale authCtx) {
        if (entities.isEmpty()) {
            return ImmutableMap.of();
        }
        return teaserType.accept(new TeaserTypeVisitor<ImmutableMap<EntityId, String>>(){

            @Override
            public ImmutableMap<EntityId, String> visitIconWithEntityName() {
                return ImmutableMap.of();
            }

            @Override
            public ImmutableMap<EntityId, String> visitIconWithTeaserText() {
                return EntityTeaserServiceImpl.this.resolveUserTeaserText(entities, authCtx);
            }

            @Override
            public ImmutableMap<EntityId, String> visitMemoTeaser(MemoTeaser memoTeaser) {
                return EntityTeaserServiceImpl.this.resolveUserTeaserText(entities, authCtx);
            }

            @Override
            public ImmutableMap<EntityId, String> visitNewsTeaser() {
                return ImmutableMap.of();
            }

            @Override
            public ImmutableMap<EntityId, String> visitNewsTeaserWithTeaserText() {
                return EntityTeaserServiceImpl.this.resolveUserTeaserText(entities, authCtx);
            }

            @Override
            public ImmutableMap<EntityId, String> visitOneLineEntityName() {
                return ImmutableMap.of();
            }

            @Override
            public ImmutableMap<EntityId, String> visitSearchResultWithTeaserText() {
                return EntityTeaserServiceImpl.this.resolveUserTeaserText(entities, authCtx);
            }

            @Override
            public ImmutableMap<EntityId, String> visitSlideshowTeaser() {
                return EntityTeaserServiceImpl.this.resolveUserTeaserText(entities, authCtx);
            }
        });
    }
}

