/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.freiheit.toro.common.shared.server.storage.StorageServerHelper;
import com.freiheit.toro.common.shared.server.util.DateUtil;
import com.freiheit.toro.common.shared.util.ImageType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.album.business.events.ImageCreatedEvent;
import de.justsoftware.onx.album.shared.model.DBAlbum;
import de.justsoftware.onx.analytics.business.AnalyticsService;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationContextWithUserId;
import de.justsoftware.onx.authorization.business.Roles;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.StaticPredefinedRole;
import de.justsoftware.onx.comments.business.events.CommentCreatedEvent;
import de.justsoftware.onx.common.business.AntiSamyService;
import de.justsoftware.onx.common.business.Command;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.common.business.LazyLoader;
import de.justsoftware.onx.common.business.configfile.ConfFile;
import de.justsoftware.onx.common.business.configfile.ConfigFileService;
import de.justsoftware.onx.common.business.configfile.ConfigService;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.business.configfile.boolexpr.EvalException;
import de.justsoftware.onx.common.business.configfile.parser.ConfComponentType;
import de.justsoftware.onx.common.business.configfile.parser.ConfOption;
import de.justsoftware.onx.common.business.configfile.parser.ConfOptionsFor;
import de.justsoftware.onx.common.business.configfile.pathmatcher.Path;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.business.events.util.CollectingServerEventCollector;
import de.justsoftware.onx.common.business.events.util.DummyServerEventCollector;
import de.justsoftware.onx.common.business.events.util.ImmediatelyFiringServerEventCollector;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.deletion.DeletionService;
import de.justsoftware.onx.common.deletion.TransactionCallbackWithDeleteAction;
import de.justsoftware.onx.common.deletion.model.DeleteAction;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.model.AuthorityModel;
import de.justsoftware.onx.common.shared.model.ComponentModel;
import de.justsoftware.onx.common.shared.model.EntityPlaceholderBadgeBean;
import de.justsoftware.onx.common.shared.model.EntityVersionClientModel;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.Role;
import de.justsoftware.onx.common.shared.model.SaveCKResult;
import de.justsoftware.onx.common.shared.model.TimeZone;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.Actions;
import de.justsoftware.onx.common.shared.model.action.DynamicActionCreator;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.model.action.StaticItemAction;
import de.justsoftware.onx.common.shared.model.action.TabNameForConfiguration;
import de.justsoftware.onx.common.shared.model.action.VisibleActionSet;
import de.justsoftware.onx.common.shared.model.attributes.ArithmeticOperationInput;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeConfig;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeEditModel;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeId;
import de.justsoftware.onx.common.shared.model.attributes.EntityDynamicAttributeCalculator;
import de.justsoftware.onx.common.shared.model.attributes.Input;
import de.justsoftware.onx.common.shared.model.attributes.NumberInput;
import de.justsoftware.onx.common.shared.model.attributes.PersonSuggestInput;
import de.justsoftware.onx.common.shared.model.attributes.SelectionInput;
import de.justsoftware.onx.common.shared.model.attributes.TextAreaInput;
import de.justsoftware.onx.common.shared.model.attributes.TextInput;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.server.AfterCommitCallback;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.common.shared.util.ValueOfMap;
import de.justsoftware.onx.container.business.EntityAdministrationWorkflowService;
import de.justsoftware.onx.container.business.EntityMemberCacheService;
import de.justsoftware.onx.container.business.EntityMemberNotificationService;
import de.justsoftware.onx.container.business.EntityMemberService;
import de.justsoftware.onx.container.business.EntityModuleService;
import de.justsoftware.onx.container.business.EntityPrivacyMigrationService;
import de.justsoftware.onx.container.business.EntityReadWriteDataService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.EntityTypeAppMappingService;
import de.justsoftware.onx.container.business.EntityVersionService;
import de.justsoftware.onx.container.business.ItemService;
import de.justsoftware.onx.container.business.ObjectWithDepth;
import de.justsoftware.onx.container.business.TestEntityService;
import de.justsoftware.onx.container.business.events.DriveDocumentUpdatedEvent;
import de.justsoftware.onx.container.business.events.DriveDocumentsDeletedEvent;
import de.justsoftware.onx.container.business.events.EntityComponentPositionsChangedEvent;
import de.justsoftware.onx.container.business.events.EntityCreatedEvent;
import de.justsoftware.onx.container.business.events.EntityDescriptionUpdatedEvent;
import de.justsoftware.onx.container.business.events.EntityNameUpdatedEvent;
import de.justsoftware.onx.container.business.events.EntityParentsChangedByUserEvent;
import de.justsoftware.onx.container.business.events.EntityParticipantLimitIncreasedEvent;
import de.justsoftware.onx.container.business.events.EntityPrivacyChangedEvent;
import de.justsoftware.onx.container.business.events.EntityVersionDeletedEvent;
import de.justsoftware.onx.container.business.events.EntityVersionPublishedEvent;
import de.justsoftware.onx.container.business.events.EntityVersionReleaseEvent;
import de.justsoftware.onx.container.business.events.EntityVersionStatusUpdateEvent;
import de.justsoftware.onx.container.business.events.EntityVersionUpdateEvent;
import de.justsoftware.onx.container.business.events.ItemDeletedEvent;
import de.justsoftware.onx.container.business.impl.EntityTypeAllowedComponent;
import de.justsoftware.onx.container.business.model.EntityVersion;
import de.justsoftware.onx.container.integration.persistence.EntityDAO;
import de.justsoftware.onx.container.integration.persistence.EntityDynamicAttributeDAO;
import de.justsoftware.onx.container.server.model.DBPrivacySelection;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.ComponentPosition;
import de.justsoftware.onx.container.shared.model.ComponentPositionConfig;
import de.justsoftware.onx.container.shared.model.DefaultEntityBaseData;
import de.justsoftware.onx.container.shared.model.DeleteEntityReferenceException;
import de.justsoftware.onx.container.shared.model.EditEntityHistoryTokenTabName;
import de.justsoftware.onx.container.shared.model.EntityBadge;
import de.justsoftware.onx.container.shared.model.EntityBadgeBean;
import de.justsoftware.onx.container.shared.model.EntityBadgeSetters;
import de.justsoftware.onx.container.shared.model.EntityBadgeWithRole;
import de.justsoftware.onx.container.shared.model.EntityBaseData;
import de.justsoftware.onx.container.shared.model.EntityDurationTimeOption;
import de.justsoftware.onx.container.shared.model.EntityDynamicAttributeClientModel;
import de.justsoftware.onx.container.shared.model.EntityExtendedData;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityInfoBean;
import de.justsoftware.onx.container.shared.model.EntityInfoSetters;
import de.justsoftware.onx.container.shared.model.EntityInfoTabPrivacySettings;
import de.justsoftware.onx.container.shared.model.EntityInheritValue;
import de.justsoftware.onx.container.shared.model.EntityMember;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberWithEntityType;
import de.justsoftware.onx.container.shared.model.EntityMemberWithPerson;
import de.justsoftware.onx.container.shared.model.EntityMemberWorkflow;
import de.justsoftware.onx.container.shared.model.EntityStatistics;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import de.justsoftware.onx.container.shared.model.EntityStatusClientModel;
import de.justsoftware.onx.container.shared.model.EntityTab;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.EntityVersionType;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.IEntityDynamicAttribute;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.container.shared.model.LinkedEntityNoPermission;
import de.justsoftware.onx.container.shared.model.LinkedEntityRecursionException;
import de.justsoftware.onx.container.shared.model.MemberChangeOptions;
import de.justsoftware.onx.container.shared.model.MenuCreateEntityInfo;
import de.justsoftware.onx.container.shared.model.ModuleData;
import de.justsoftware.onx.container.shared.model.MyMemberStatus;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.container.shared.model.UpdateEntityResponse;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.db.DBEntityComponent;
import de.justsoftware.onx.container.shared.model.db.DBEntityLink;
import de.justsoftware.onx.container.shared.model.db.DBEntityLinkedEntityPrivacy;
import de.justsoftware.onx.container.shared.model.db.DBPrivacyType;
import de.justsoftware.onx.container.shared.model.right.Right;
import de.justsoftware.onx.container.shared.model.right.Rights;
import de.justsoftware.onx.container.shared.model.right.StaticRight;
import de.justsoftware.onx.container.shared.model.util.EntityMemberUtil;
import de.justsoftware.onx.container.shared.model.validation.group.ServerGroup;
import de.justsoftware.onx.container.shared.server.model.EntityDynamicAttribute;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.EntityWithDynamicAttributes;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.container.shared.server.model.PseudoEntityItem;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.events.EntityParentUpdateEvent;
import de.justsoftware.onx.events.EntityUpdateEvent;
import de.justsoftware.onx.events.EntityUpdateModifyDateEvent;
import de.justsoftware.onx.events.EntityVisibilitiesUpdateEvent;
import de.justsoftware.onx.events.RawEditorVersionCreatedEvent;
import de.justsoftware.onx.events.business.UpdateEventHandler;
import de.justsoftware.onx.like.business.LikeService;
import de.justsoftware.onx.like.business.model.SubscriptionModel;
import de.justsoftware.onx.like.integration.persistence.LikeDAO;
import de.justsoftware.onx.like.shared.model.SubscriptionState;
import de.justsoftware.onx.like.shared.model.SubscriptionStatus;
import de.justsoftware.onx.like.shared.model.SubscriptionType;
import de.justsoftware.onx.mail.business.GlobalMailTemplateKeys;
import de.justsoftware.onx.mail.business.MailTemplateContext;
import de.justsoftware.onx.mail.business.MailType;
import de.justsoftware.onx.multiwiki.business.events.MultiWikiVersionCreatedEvent;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.business.events.ProfileChangedEvent;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.searchnew.business.SearchService;
import de.justsoftware.onx.searchnew.shared.model.ArticleSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.ChapterSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.ChatSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.ConversationSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.DriveDocumentSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.EntitySearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.FederatedSearchResultEntry;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypes;
import de.justsoftware.onx.searchnew.shared.model.JucoOnlySearchResultVisitor;
import de.justsoftware.onx.searchnew.shared.model.NewsChannelSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.NewsPostSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.PersonSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.SearchContext;
import de.justsoftware.onx.searchnew.shared.model.SearchContextModel;
import de.justsoftware.onx.searchnew.shared.model.SearchResult;
import de.justsoftware.onx.searchnew.shared.model.SearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.SearchResultBadgeVisitor;
import de.justsoftware.onx.searchnew.shared.model.SortType;
import de.justsoftware.onx.searchnew.shared.model.StaticSearchFacetParameters;
import de.justsoftware.onx.searchnew.shared.model.WikiSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.WorkstreamSearchResultBadgeModel;
import de.justsoftware.onx.tenant.business.TenantService;
import de.justsoftware.onx.tenant.integration.persistence.PersonTenantDAO;
import de.justsoftware.onx.tenant.integration.persistence.model.Tenant;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import de.justsoftware.onx.validation.JucoValidator;
import de.justsoftware.onx.validation.shared.model.JucoConstraintViolation;
import de.justsoftware.onx.validation.shared.model.JucoConstraintViolationException;
import de.justsoftware.onx.videolink.business.events.VideolinkCreatedEvent;
import de.justsoftware.onx.wikieditor.business.events.NewWikiVersionEvent;
import de.justsoftware.onx.workstream.business.event.MicroblogPostingPublishedEvent;
import de.justsoftware.toolbox.clock.Clock;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.validation.groups.Default;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@Service(value="entityService")
public class EntityServiceImpl
implements ServerEventHandler,
TestEntityService,
EntityPrivacyMigrationService {
    public static final int MINIMUM_URL_LENGTH = 3;
    private static final String URL_PATTERN = "[A-Za-z0-9]+([.-]?[A-Za-z0-9])*";
    private static final String DOT = ".";
    private static final String WWW = "www.";
    private static final Logger LOG = LoggerFactory.getLogger(EntityServiceImpl.class);
    private static final Function<DBEntityLink, EntityId> ENTITY_LINK_TO_ENTITY_ID = new NullPermeableFunction<DBEntityLink, EntityId>(){

        @Override
        protected EntityId applySafe(DBEntityLink input) {
            return input.getLinkedEntityId();
        }
    };
    @Autowired
    private EntityDAO _entityDAO;
    @Autowired
    private EntityModuleService _moduleService;
    @Autowired
    private Settings _settings;
    @Autowired
    private AntiSamyService _antiSamyService;
    @Autowired
    private StorageServerHelper _storageServerHelper;
    @Autowired
    private I18nService _i18nService;
    @Autowired
    private PersonService _personService;
    @Autowired
    private EntityMemberService _entityMemberService;
    @Autowired
    private EntityMemberCacheService _entityMemberCacheService;
    @Autowired
    private EntityMemberNotificationService _entityNotificationService;
    @Autowired
    private EntityAdministrationWorkflowService _entityAdministrationService;
    @Autowired
    private TransactionHelper _transactionHelper;
    @Autowired
    private ConfigFileService _configFileService;
    @Autowired
    private JCEventBus _eventBus;
    @Autowired
    private EntityConfigService _entityConfig;
    @Autowired
    private LikeService _likeService;
    @Autowired
    private UpdateEventHandler _updateHandler;
    @Autowired
    private EntityReadWriteDataService _entityDataService;
    @Autowired
    private EntityVersionService _entityVersionService;
    @Autowired
    private EntityDynamicAttributeDAO _entityDynamicAttributeDao;
    @Autowired
    private JucoValidator _validator;
    @Autowired
    private DeletionService _deletionService;
    @Autowired
    private ItemService _itemService;
    @Autowired
    private SearchService _searchService;
    @Autowired
    private ConfigService _configService;
    @Autowired
    private AnalyticsService _analyticsService;
    @Autowired
    private Clock _clock;
    @Autowired
    private TenantService _tenantService;
    @Autowired
    private EntityTypeAppMappingService _entityTypeAppMappingService;
    @Autowired
    private PersonTenantDAO _personTenantDao;
    @Autowired
    private LikeDAO _likeDao;

    @Override
    public Map<EntityId, DBEntity> getByIds(Set<EntityId> entityIds) {
        Function<Collection<DBEntity>, Map<EntityId, DBEntity>> applyConfig = new Function<Collection<DBEntity>, Map<EntityId, DBEntity>>(){

            public Map<EntityId, DBEntity> apply(Collection<DBEntity> input) {
                HashMap map = Maps.newHashMap();
                if (input != null) {
                    for (DBEntity e : input) {
                        map.put(e.getId(), e);
                    }
                }
                if (!map.isEmpty()) {
                    ImmutableListMultimap entitiesByType = Multimaps.index(map.values(), DBEntity.TO_ENTITY_TYPE);
                    EntityServiceImpl.this.applyDynamicAttributes((ImmutableListMultimap<EntityType, DBEntity>)entitiesByType);
                    EntityServiceImpl.this.applyEntityStatus((ImmutableListMultimap<EntityType, DBEntity>)entitiesByType);
                }
                return map;
            }
        };
        Map<EntityId, DBEntity> result = this._entityDataService.getByIds(entityIds, applyConfig);
        return result;
    }

    @Override
    public DBEntity getById(EntityId id) {
        if (id == null) {
            return null;
        }
        return this.getByIds((Set<EntityId>)ImmutableSet.of((Object)id)).get(id);
    }

    private void applyDynamicAttributes(@Nonnull ImmutableListMultimap<EntityType, DBEntity> entitiesByType) {
        ImmutableListMultimap<EntityType, DynamicAttributeConfig> dynamicAttributesConfigs = this._entityConfig.getDynamicAttributeConfigs((Set<EntityType>)entitiesByType.keySet());
        ImmutableList dynamicAttributesEntites = ImmutableList.copyOf((Collection)Multimaps.filterKeys(entitiesByType, (Predicate)Predicates.in((Collection)dynamicAttributesConfigs.keySet())).values());
        if (dynamicAttributesEntites.isEmpty()) {
            return;
        }
        ImmutableListMultimap<EntityId, EntityDynamicAttribute> dynamicAttributes = this._entityDynamicAttributeDao.getDynamicAttributesForEntities((Set<EntityId>)ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)dynamicAttributesEntites, DBEntity.TO_ENTITY_ID)));
        for (DBEntity entity : dynamicAttributesEntites) {
            ImmutableList dynamicAttributesFromDB = dynamicAttributes.get((Object)entity.getId());
            EntityDynamicAttributeCalculator calculator = new EntityDynamicAttributeCalculator(Iterables.transform((Iterable)dynamicAttributesFromDB, DynamicAttributeEditModel.FROM_ENTITY_DYNAMIC_ATTRIBUTE));
            ImmutableList<DynamicAttributeEditModel> calculatedAttributes = calculator.calculateDynamicAttributes((ImmutableList<DynamicAttributeConfig>)dynamicAttributesConfigs.get((Object)entity.getType()));
            entity.setDynamicAttributes(this.transform(entity.getId(), calculatedAttributes));
        }
    }

    private void applyEntityStatus(@Nonnull ImmutableListMultimap<EntityType, DBEntity> entitiesByType) {
        ImmutableCollection dbEntities = entitiesByType.values();
        ImmutableSet entityIds = FluentIterable.from((Iterable)dbEntities).transform(DBEntity.TO_ENTITY_ID).toSet();
        ImmutableMultimap<EntityId, EntityVersion> newestVersionByStatus = this._entityVersionService.getNewestVersionByStatus((Set<EntityId>)entityIds);
        for (DBEntity entity : dbEntities) {
            ImmutableCollection statusCollection = newestVersionByStatus.get((Object)entity.getId());
            if (statusCollection == null || statusCollection.isEmpty()) continue;
            ImmutableSet status = FluentIterable.from((Iterable)statusCollection).transform(Functions.compose(EntityStatusClientModel.TO_CLIENT_MODEL, EntityVersion.TO_ENTITY_STATUS)).toSet();
            entity.setEntityStatus((ImmutableSet<EntityStatusClientModel>)status);
            entity.setInitialDraft(!FluentIterable.from((Iterable)status).anyMatch(EntityStatus.IS_PUBLISHED));
        }
    }

    @Override
    public DBEntity getByIdNotNull(EntityId id) {
        return InvalidIdServiceException.check(this.getById(id));
    }

    @Override
    public void checkParentEntityAssignmentAllowed(EntityId childEntityId, EntityType childEntityType, ImmutableSet<EntityId> parentEntityIds, AuthorizationCheckContextWithUserId authorizationContext) throws LinkedEntityNoPermission {
        TenantId tenantId;
        HashSet ignoreErrorsFor = Sets.newHashSet();
        if (childEntityId != null) {
            DBEntity entity = this.getByIdNotNull(childEntityId);
            for (DBEntityLink link : entity.getLinkedEntities()) {
                ignoreErrorsFor.add(link.getLinkedEntityId());
            }
            tenantId = entity.getTenantId();
        } else {
            tenantId = authorizationContext.getTenantId();
        }
        this.checkParentEntityAssignmentAllowed(childEntityType, (Set<EntityId>)parentEntityIds, tenantId, ignoreErrorsFor, authorizationContext);
    }

    private void checkParentEntityAssignmentAllowed(EntityType childEntityType, Set<EntityId> parentEntityIds, TenantId childTenantId, final Set<EntityId> ignoreErrorsFor, AuthorizationCheckContextWithLocale authorizationContext) {
        String locale = authorizationContext.getLocale();
        final ImmutableMap.Builder errorMapBuilder = ImmutableMap.builder();
        BasicConstants basicConstants = this._i18nService.createProxy(BasicConstants.class, locale);
        ImmutableMap<EntityType, EntityConstants> entityConstants = this._i18nService.getEntityConstants(locale);
        this.mayParentEntityAssignmentAllowed(childTenantId, Set.of(childEntityType), parentEntityIds, authorizationContext, new AssignmentErrorCollector((Map)entityConstants, basicConstants){
            final /* synthetic */ Map val$entityConstants;
            final /* synthetic */ BasicConstants val$basicConstants;
            {
                this.val$entityConstants = map;
                this.val$basicConstants = basicConstants;
            }

            @Override
            public void addInvalidEntitySelectionOccur(DBEntity parentEntity, EntityType childType) {
                EntityId id = parentEntity.getId();
                if (!ignoreErrorsFor.contains(id)) {
                    errorMapBuilder.put((Object)id, (Object)((EntityConstants)this.val$entityConstants.get(parentEntity.getType())).invalidEntitySelectionOccur());
                }
            }

            @Override
            public void addElementDoesNotExist(EntityId parentEntityId) {
                errorMapBuilder.put((Object)parentEntityId, (Object)this.val$basicConstants.elementDoesNotExists());
            }

            @Override
            public void addAssignedTypeNotAllowed(DBEntity parentEntity, EntityType childType) {
                EntityId id = parentEntity.getId();
                if (!ignoreErrorsFor.contains(id)) {
                    errorMapBuilder.put((Object)parentEntity.getId(), (Object)((EntityConstants)this.val$entityConstants.get(parentEntity.getType())).assignedTypeNotAllowed());
                }
            }
        });
        ImmutableMap errorMap = errorMapBuilder.build();
        if (!errorMap.isEmpty()) {
            throw new LinkedEntityNoPermission((ImmutableMap<EntityId, String>)errorMap);
        }
    }

    @Nonnull
    private ImmutableSetMultimap<EntityId, EntityType> mayParentEntityAssignmentAllowed(@Nonnull TenantId childTenantId, @Nonnull Set<EntityType> childTypes, @Nonnull Set<EntityId> parentEntityIds, @Nonnull AuthorizationCheckContext authorizationContext, @Nonnull AssignmentErrorCollector assignmentErrorCollector) {
        if (parentEntityIds.isEmpty() || childTypes.isEmpty()) {
            return ImmutableSetMultimap.of();
        }
        ImmutableSetMultimap.Builder resultBuilder = ImmutableSetMultimap.builder();
        Map<EntityId, DBEntity> entityByIds = this.getByIds(parentEntityIds);
        StaticEntityAction readParentAction = StaticEntityAction.ENTITY_READ_DETAILS;
        ImmutableSet actions = ImmutableSet.builder().add((Object)readParentAction).addAll(Iterables.transform(childTypes, Actions::entitySelectParent)).build();
        ImmutableSetMultimap allMay = authorizationContext.mayByIds(entityByIds.keySet(), actions);
        for (EntityId parentEntityId : parentEntityIds) {
            DBEntity parentEntity = entityByIds.get(parentEntityId);
            if (parentEntity == null) {
                assignmentErrorCollector.addElementDoesNotExist(parentEntityId);
                continue;
            }
            for (EntityType childType : childTypes) {
                boolean sameTenant;
                boolean mayRead;
                boolean mayConnect;
                ImmutableSet may = allMay.get((Object)Optional.of((Object)parentEntityId));
                boolean bl = mayConnect = may.contains(Actions.entitySelectParent(childType)) && this._entityConfig.maxParentCount(parentEntity.getType(), childType) > 0;
                if (!mayConnect) {
                    assignmentErrorCollector.addAssignedTypeNotAllowed(parentEntity, childType);
                }
                if (!(mayRead = may.contains(readParentAction))) {
                    assignmentErrorCollector.addInvalidEntitySelectionOccur(parentEntity, childType);
                }
                if (!(sameTenant = parentEntity.getTenantId().equals(childTenantId))) {
                    assignmentErrorCollector.addInvalidEntitySelectionOccur(parentEntity, childType);
                }
                if (!mayRead || !mayConnect || !sameTenant) continue;
                resultBuilder.put((Object)parentEntityId, (Object)childType);
            }
        }
        return resultBuilder.build();
    }

    @Override
    public ImmutableSetMultimap<EntityId, EntityType> filterAllowedChildEntityTypes(Set<EntityType> childTypes, Set<EntityId> parentEntityIds, AuthorizationCheckContextWithUserId authorizationContext) {
        return this.mayParentEntityAssignmentAllowed(authorizationContext.getTenantId(), childTypes, parentEntityIds, authorizationContext, AssignmentErrorCollector.NOTHING);
    }

    private boolean canInherit(@Nonnull EntityType childType, @Nullable EntityId parentEntityId, @Nonnull AuthorizationCheckContextWithUserId authCtx) {
        if (parentEntityId == null) {
            return false;
        }
        return this.filterAllowedChildEntityTypes((Set<EntityType>)ImmutableSet.of((Object)childType), (Set<EntityId>)ImmutableSet.of((Object)parentEntityId), authCtx).containsEntry((Object)parentEntityId, (Object)childType);
    }

    @Nonnull
    private UpdateEntityResponse checkEntityBaseData(final @Nonnull DBEntity updatedEntity) {
        String errMsg;
        UpdateEntityResponse result;
        EntityType entityType = updatedEntity.getType();
        StringBuilder messages = new StringBuilder();
        if (StringUtils.isBlank((String)updatedEntity.getName())) {
            messages.append("Entity name must not be blank.\n");
        }
        if (entityType == null) {
            messages.append("Entity Type must not be null.\n");
        }
        if (!CollectionUtil.isEmpty(updatedEntity.getLinkedEntities())) {
            HashSet<EntityId> linkedEntityIdSet = new HashSet<EntityId>();
            HashSet<EntityId> recursionIds = new HashSet<EntityId>();
            for (DBEntityLink link : updatedEntity.getLinkedEntities()) {
                Iterator<DBEntity> recursionCheckIterator;
                if (linkedEntityIdSet.contains(link.getLinkedEntityId())) {
                    messages.append("Duplicate assingment of linked entity with id = " + link.getLinkedEntityId().getId() + "\n");
                    continue;
                }
                linkedEntityIdSet.add(link.getLinkedEntityId());
                if (updatedEntity.getId() == null || !(recursionCheckIterator = this.searchParents(link.getLinkedEntityId(), new EntityService.SearchPredicates(){

                    @Override
                    public boolean isResult(DBEntity e, int depth, EntityId childBefore) {
                        return e.getId().equals(updatedEntity.getId());
                    }

                    @Override
                    public boolean expand(DBEntity e, int depth, EntityId childBefore) {
                        return !e.getId().equals(updatedEntity.getId());
                    }
                })).hasNext()) continue;
                recursionIds.add(link.getLinkedEntityId());
            }
            if (!CollectionUtil.isEmpty(recursionIds)) {
                throw new LinkedEntityRecursionException(recursionIds);
            }
            HashMap groupByType = Maps.newHashMap();
            Map<EntityId, DBEntity> parentEntities = this.getByIds(linkedEntityIdSet);
            for (DBEntityLink link : updatedEntity.getLinkedEntities()) {
                DBEntity dbEntity = parentEntities.get(link.getLinkedEntityId());
                if (dbEntity == null) {
                    messages.append("Parent with entity id = " + link.getLinkedEntityId().getId() + " does not exist\n");
                    continue;
                }
                ArrayList<DBEntity> list = (ArrayList<DBEntity>)groupByType.get(dbEntity.getType());
                if (list == null) {
                    list = new ArrayList<DBEntity>();
                    groupByType.put(dbEntity.getType(), list);
                }
                list.add(dbEntity);
            }
            for (EntityType type : this._entityConfig.getOrderedEntityTypes()) {
                List list = (List)groupByType.get(type);
                int size = list == null ? 0 : list.size();
                int maxParentCount = this._entityConfig.maxParentCount(type, entityType);
                int minParentCount = this._entityConfig.minParentCount(type, entityType);
                if (maxParentCount <= 0 && size > 0) {
                    messages.append("Linked entity type " + type.getName() + " not allowed\n");
                }
                if (size < minParentCount) {
                    messages.append("Minimum linked entity of type " + type.getName() + " not reach\n");
                }
                if (size <= maxParentCount) continue;
                messages.append("Too many linked entities of type " + type.getName() + "\n");
            }
        } else if (this._entityConfig.linkedEntityRequired(entityType)) {
            messages.append("Linked entity must not be null or empty\n");
        }
        if (!StringUtils.isBlank((String)updatedEntity.getDescription())) {
            CleanResults cleanResults;
            try {
                cleanResults = this._antiSamyService.scan(updatedEntity.getDescription());
            }
            catch (ScanException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new ServiceException(e);
            }
            catch (PolicyException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new ServiceException(e);
            }
            updatedEntity.setDescription(cleanResults.getCleanHTML().trim());
            result = new UpdateEntityResponse(new SaveCKResult(cleanResults.getNumberOfErrors() > 0));
        } else {
            result = new UpdateEntityResponse(new SaveCKResult(false));
        }
        if (this._entityConfig.getDurationTimeOption(entityType) != EntityDurationTimeOption.OFF) {
            DateWithoutTimezone startAt = updatedEntity.getStartAt();
            DateWithoutTimezone endAt = updatedEntity.getEndAt();
            if (startAt == null || endAt == null) {
                messages.append("Start and end date required for entity of type " + entityType + "\n");
            } else if (startAt.after(endAt)) {
                messages.append("Start date after end date is not allowed\n");
            }
        }
        if (this._entityConfig.getEntityMemberWorkflow(entityType) != EntityMemberWorkflow.EVENT && updatedEntity.getParticipantLimit() > 0) {
            messages.append("Participant limit is only allowed for events");
        }
        ImmutableList<EntityTab> availableTabs = this._entityConfig.getEntityTabOrderForEntityType(entityType);
        EntityTab selectedTab = updatedEntity.getDefaultTab();
        if (selectedTab != null && !availableTabs.contains((Object)selectedTab)) {
            messages.append("Selected default entity tab " + selectedTab.getName() + " is unavailable for entity of type " + entityType + "\n");
        }
        if (!StringUtils.isBlank((String)(errMsg = messages.toString()))) {
            throw new ServiceException(errMsg);
        }
        return result;
    }

    private void transformDataBeforeSave(DBEntity entity) {
        entity.setName(entity.getName().trim());
    }

    private List<DBEntityLinkedEntityPrivacy> fillPrivacyWithAvailableAuthorityNames(@Nonnull DBEntity entity, @Nonnull List<DBEntityLinkedEntityPrivacy> privaciesFromDao) {
        HashSet missingTypes = Sets.newHashSet(this._entityConfig.getAllowedChildrenType(entity.getType()));
        ArrayList privacies = Lists.newArrayList(privaciesFromDao);
        for (DBEntityLinkedEntityPrivacy privacy : privacies) {
            missingTypes.remove(privacy.getEntityType());
        }
        for (EntityType type : missingTypes) {
            privacies.add(new DBEntityLinkedEntityPrivacy(entity.getId(), type, (ImmutableSet<String>)ImmutableSet.of()));
        }
        for (DBEntityLinkedEntityPrivacy privacy : privacies) {
            privacy.setAvailableAuthorities((List<AuthorityModel>)FluentIterable.from((Iterable)this._entityConfig.getEntityPrivacyOptions(entity.getType(), Rights.entityChangeParent(privacy.getEntityType())).getOptions().values()).transform(ConfOption.GET_AUTHORITY_MODEL).toList());
        }
        return privacies;
    }

    private void fillDefaultDescription(DBEntity entity, EntityConstants i18nConstants) {
        if (StringUtils.isEmpty((String)entity.getDescription())) {
            entity.setDescription(i18nConstants.defaultDescriptionText());
        }
    }

    @Override
    public List<DBPrivacySelection> createPrivacySelection(ImmutableSet<String> authorityNames, DBPrivacyType type) {
        ArrayList<DBPrivacySelection> retval = new ArrayList<DBPrivacySelection>(authorityNames.size());
        for (String authName : authorityNames) {
            retval.add(new DBPrivacySelection(type, authName));
        }
        return retval;
    }

    @Nonnull
    private ImmutableList<DBEntityLinkedEntityPrivacy> defaultLinkedEntityPrivacySettings(@Nonnull EntityType type) {
        ImmutableList.Builder linkedPrivacy = ImmutableList.builder();
        for (EntityType childType : this._entityConfig.getAllowedChildrenType(type)) {
            DBEntityLinkedEntityPrivacy defaultLinkedEntityPrivacy = new DBEntityLinkedEntityPrivacy();
            defaultLinkedEntityPrivacy.setEntityType(childType);
            defaultLinkedEntityPrivacy.setEntityId(null);
            ConfOptionsFor privacyOptionsForRight = this._entityConfig.getEntityPrivacyOptions(type, Rights.entityChangeParent(childType));
            defaultLinkedEntityPrivacy.setSelectedAuthorityNames(privacyOptionsForRight.getOptionNamesFiltered(ConfOption.IS_PRE_SELECTED));
            linkedPrivacy.add((Object)defaultLinkedEntityPrivacy);
        }
        return linkedPrivacy.build();
    }

    @Nonnull
    private ImmutableList<DBPrivacySelection> defaultEntityPrivacySettings(@Nonnull EntityType type) {
        ImmutableList.Builder privacy = ImmutableList.builder();
        privacy.addAll(this.createPrivacySelection(this._entityConfig.getDefaultVisibilityRuleAuthNames(type), DBPrivacyType.VISIBILITY));
        privacy.addAll(this.createPrivacySelection(this._entityConfig.getDefaultJoiningRuleAuthNames(type), DBPrivacyType.JOINING));
        privacy.addAll(this.createPrivacySelection(this._entityConfig.getDefaultInvitingRuleAuthNames(type), DBPrivacyType.INVITING));
        privacy.addAll(this.createPrivacySelection(this._entityConfig.getDefaultNewsletterRuleAuthNames(type), DBPrivacyType.NEWSLETTER));
        privacy.addAll(this.createPrivacySelection(this._entityConfig.getDefaultEditEntityRuleAuthNames(type), DBPrivacyType.ENTITY_EDIT));
        return privacy.build();
    }

    @Override
    public EntityId createInheritingEntity(EntityBaseData entityBaseData, EntityId parentId, AuthorizationCheckContextWithUserId auth) {
        ImmutableList linkedPrivacy;
        ImmutableSet<EntityInheritValue> inheritSettings;
        DBEntity entity = entityBaseData.getEntity();
        EntityType entityType = entity.getType();
        DBEntity parent = this.getById(parentId);
        if (this.canInherit(entityType, parentId, auth)) {
            inheritSettings = this._entityConfig.entityInhertitSettings(parent.getType(), entity.getType());
            linkedPrivacy = inheritSettings.contains((Object)EntityInheritValue.CHILD_ENTITY_SETTINGS) ? this.getEntityLinkedEntityPrivacies((Map<EntityId, DBEntity>)ImmutableMap.of((Object)parentId, (Object)parent)).get((Object)parentId) : null;
        } else {
            inheritSettings = ImmutableSet.of();
            linkedPrivacy = null;
        }
        ImmutableList.Builder privacy = ImmutableList.builder();
        privacy.addAll(this.createPrivacySelection(entityBaseData.getVisibility(), DBPrivacyType.VISIBILITY));
        privacy.addAll(this.createPrivacySelection(entityBaseData.getJoinOption(), DBPrivacyType.JOINING));
        privacy.addAll(this.createPrivacySelection(entityBaseData.getJoinRequestOption(), DBPrivacyType.JOIN_REQUEST));
        privacy.addAll(this.createPrivacySelection(entityBaseData.getModifyTitleRoles(), DBPrivacyType.MODIFY_TITLE));
        privacy.addAll(this.createPrivacySelection(entityBaseData.getEntityEditRoles(), DBPrivacyType.ENTITY_EDIT));
        ImmutableSet<String> inviteSetting = this.inheritPrivacySettings(EntityItem.of(parent), DBPrivacyType.INVITING, this._entityConfig.getDefaultInvitingRuleAuthNames(entityType), inheritSettings.contains((Object)EntityInheritValue.INVITE_SETTING));
        ImmutableSet<String> newsletterSettig = this.inheritPrivacySettings(EntityItem.of(parent), DBPrivacyType.NEWSLETTER, this._entityConfig.getDefaultNewsletterRuleAuthNames(entityType), inheritSettings.contains((Object)EntityInheritValue.NEWSLETTER_SETTING));
        privacy.addAll(this.createPrivacySelection(inviteSetting, DBPrivacyType.INVITING));
        privacy.addAll(this.createPrivacySelection(newsletterSettig, DBPrivacyType.NEWSLETTER));
        return this.createEntity(entity, (ImmutableList<DBPrivacySelection>)privacy.build(), (ImmutableList<DBEntityLinkedEntityPrivacy>)linkedPrivacy, entityBaseData.getDynamicAttributes(), auth, true);
    }

    @Override
    public EntityId createEntity(DBEntity entity, ImmutableList<DBPrivacySelection> privacySettings, ImmutableList<DBEntityLinkedEntityPrivacy> linkedPrivacySettigns, ImmutableList<DynamicAttributeEditModel> dynamicAttributeValues, AuthorizationCheckContextWithUserId auth, boolean sendNotifications) {
        EntityType entityType = entity.getType();
        this.checkEntityTypeAllowed(auth, entityType);
        if (entity.getDefaultTab() != null && !auth.may((Item<?>)new PseudoEntityItem(entityType), (Action)StaticEntityAction.ENTITY_MODIFY_TAB_SETTINGS)) {
            throw new PermissionDeniedException("You are not allowed to set a default entity tab for this entity");
        }
        this.checkEntityBaseData(entity);
        this.fillDefaultDescription(entity, this._i18nService.getEntityConstantsByEntityType(entityType, auth.getLocale()));
        this.transformDataBeforeSave(entity);
        CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
        return (EntityId)((AfterCommitCallback)this._transactionHelper.doInTransaction(transactionStatus -> {
            TenantId tenantId = auth.getTenantId();
            entity.setTenantId(tenantId);
            this.checkParentEntityAssignmentAllowed(entity.getType(), entity.getLinkedEntityIds(), tenantId, Set.of(), auth);
            PersonId admin = auth.getUserId();
            Date nowDate = this._clock.nowDate();
            entity.setModifyDate(nowDate);
            entity.setCreateDate(nowDate);
            this._entityDAO.insertEntity(entity);
            EntityId savedId = entity.getId();
            EntityStatus entityStatus = this._entityConfig.getDefaultStatusForEntityType(entityType);
            this._entityVersionService.createInitialEntityVersion(savedId, admin, entityStatus, eventCollector);
            this.addUserAsAdmin(eventCollector, admin, savedId);
            this.savePrivacySelectedAuthorities(savedId, (List<DBPrivacySelection>)(privacySettings == null ? this.defaultEntityPrivacySettings(entityType) : privacySettings), (ServerEventCollector)DummyServerEventCollector.INSTANCE);
            this._entityDAO.saveEntityLinkedEntityPrivacy(savedId, (List<DBEntityLinkedEntityPrivacy>)(linkedPrivacySettigns == null ? this.defaultLinkedEntityPrivacySettings(entityType) : linkedPrivacySettigns));
            if (!this._settings.isImportPersonsEnabled()) {
                this.handleEntitySubscription(entity, null);
            }
            entity.setDynamicAttributes(this.transform(savedId, dynamicAttributeValues));
            this.checkDynamicAttributes(auth, entity);
            this.updateDynamicAttributes(savedId, entityType, entity.getDynamicAttributes());
            this.buildMissingComponents(new EntityCompontenConfigCache(), (Map<EntityId, DBEntity>)ImmutableMap.of((Object)savedId, (Object)entity), eventCollector);
            eventCollector.add(new EntityCreatedEvent(savedId, admin, entity.getName(), entityType, sendNotifications));
            return () -> {
                this._updateHandler.onChange(new EntityUpdateEvent(savedId));
                eventCollector.fireEvents(this._eventBus);
                return savedId;
            };
        })).afterCommit();
    }

    private void checkEntityTypeAllowed(AuthorizationCheckContextWithUserId auth, EntityType type) {
        if (!this._entityConfig.getOrderedEntityTypes().contains((Object)type)) {
            throw new PermissionDeniedException("Entity of type " + type + " are not defined");
        }
        if (!this._entityConfig.entityTypeActivated(type)) {
            throw new PermissionDeniedException("Entity of type " + type + " are not activated");
        }
        if (!auth.may(Actions.entityCreate(type))) {
            throw new PermissionDeniedException("You are not allowed to create an entity of type " + type.getName());
        }
    }

    private void addUserAsAdmin(@Nonnull CollectingServerEventCollector eventCollector, @Nonnull PersonId admin, @Nonnull EntityId entityId) {
        this._entityAdministrationService.grantMemberToAdmin(entityId, admin, MemberChangeOptions.builder().setEntityNewMembershipWorkstreamMessage(false).disableEmailNotification().setEntityCreation(true).build(), eventCollector);
    }

    @Override
    public EntityId createEntityForDifferentUser(DBEntity entity, PersonId personId, ImmutableList<DBPrivacySelection> privacySettings, ImmutableList<DBEntityLinkedEntityPrivacy> linkedPrivacySettings, ImmutableList<DynamicAttributeEditModel> dynamicAttributeValues, AuthorizationCheckContextWithUserId auth, boolean sendNotifications) {
        if (this._personService.getPersonById(personId) == null) {
            throw new PermissionDeniedException("The specified person " + personId + " to create an entity for does not exist");
        }
        return (EntityId)this._transactionHelper.doInTransaction(status -> {
            EntityId entityId = this.createEntity(entity, privacySettings, linkedPrivacySettings, dynamicAttributeValues, auth, sendNotifications);
            if (!com.google.common.base.Objects.equal((Object)auth.getUserId(), (Object)personId)) {
                LOG.info("Creator {} and admin {} differ. Switch the entity admin.", (Object)auth.getUserId(), (Object)personId);
                auth.check((ItemId)entityId, (Action)StaticEntityAction.ENTITY_MAKE_ADMIN);
                auth.check((ItemId)entityId, (Action)StaticEntityAction.ENTITY_MANAGE_MEMBER);
                auth.check((ItemId)entityId, (Action)StaticEntityAction.ENTITY_DELETE_COADMIN);
                MemberChangeOptions changeOptions = MemberChangeOptions.builder().setEntityNewMembershipWorkstreamMessage(false).setEntityCreation(true).disableEmailNotification().build();
                this._entityAdministrationService.grantMemberToAdmin(entityId, personId, changeOptions);
                this._entityAdministrationService.deleteCoAdmins(entityId, (ImmutableSet<PersonId>)ImmutableSet.of((Object)auth.getUserId()));
            } else if (!sendNotifications) {
                this._likeService.subscribeToItems((Set<? extends ItemId>)ImmutableSet.of((Object)entityId), auth);
            }
            return entityId;
        });
    }

    @Override
    public UpdateEntityResponse updateEntity(AuthorizationCheckContextWithUserId authCtx, DBEntity entity) {
        return this.updateEntityInternal(authCtx, entity, false, false, new ImmediatelyFiringServerEventCollector(this._eventBus));
    }

    @Nonnull
    private UpdateEntityResponse updateEntityInternal(@Nonnull AuthorizationCheckContextWithUserId authCtx, @Nonnull DBEntity entity, boolean notifyMemberDataChange, boolean sendNotifications, @Nonnull ServerEventCollector eventCollector) {
        PersonId userId = authCtx.getUserId();
        DBEntity fromDB = this.getByIdNotNull(entity.getId());
        ParentInheritanceChanges changes = this.createInheritanceInformation(fromDB.getLinkedEntities(), entity.getLinkedEntities());
        ImmutableSet<EntityId> newParents = this.getDifferingParents(fromDB.getLinkedEntities(), entity.getLinkedEntities());
        this.transformDataBeforeSave(entity);
        EntityType type = fromDB.getType();
        if (!type.equals(entity.getType())) {
            throw new ServiceException("Changing the entity type during a update is not allowed!");
        }
        this.checkModificationPermissions(fromDB, entity, authCtx);
        UpdateEntityResponse result = this.checkEntityBaseData(entity);
        this.checkDynamicAttributes(authCtx, entity);
        this.updateDynamicAttributes(entity.getId(), type, entity.getDynamicAttributes());
        entity.setModifyDate(this._clock.nowDate());
        this._entityDataService.updateEntity(entity);
        if (!this._settings.isImportPersonsEnabled()) {
            this.handleEntitySubscription(entity, fromDB.getTenantSubscriptionType());
        }
        this.notifyEntityUpdate(fromDB, entity);
        if (notifyMemberDataChange) {
            this.notifyMembersAboutEntityDataChangedIfNessary(fromDB, entity, this._personService.getPersonById(userId));
        }
        if (changes._parentsChanged || changes._adminInheritanceChanged || changes._memberInheritanceChanged) {
            eventCollector.add(new EntityParentsChangedByUserEvent(userId, entity, changes._parentsChanged, changes._adminInheritanceChanged, changes._memberInheritanceChanged, newParents, sendNotifications));
        }
        if (!com.google.common.base.Objects.equal((Object)entity.getName(), (Object)fromDB.getName())) {
            eventCollector.add(new EntityNameUpdatedEvent(entity.getId(), entity.getName(), entity.getType()));
        }
        return result;
    }

    private void handleEntitySubscription(@Nonnull DBEntity entity, @Nullable SubscriptionType oldSubscriptionType) {
        if (!this.canBeSubscribed(entity)) {
            return;
        }
        ImmutableSet existingSubscribers = (ImmutableSet)this._likeDao.getSubscribers(Set.of(entity.getId())).stream().map(SubscriptionModel::getSubscriberId).collect(ImmutableSet.toImmutableSet());
        if (!this.visibleForAllPersons(entity)) {
            this.resetSubscriptionType(entity, (ImmutableSet<PersonId>)existingSubscribers);
            return;
        }
        SubscriptionType newSubscriptionType = entity.getTenantSubscriptionType();
        if (newSubscriptionType == oldSubscriptionType) {
            return;
        }
        if (newSubscriptionType != null) {
            ImmutableSet<PersonId> tenantMembers = this._personTenantDao.getPersonIdsForTenant(entity.getTenantId());
            ImmutableSet newSubscribers = Sets.difference(tenantMembers, (Set)existingSubscribers).immutableCopy();
            this.createSubscriptions(entity, (ImmutableSet<PersonId>)newSubscribers);
            this.updateSubscriptions(entity, (ImmutableSet<PersonId>)existingSubscribers, newSubscriptionType);
        } else {
            this.updateSubscriptions(entity, (ImmutableSet<PersonId>)existingSubscribers, SubscriptionType.RECOMMENDED);
        }
    }

    private void resetSubscriptionType(@Nonnull DBEntity entity, ImmutableSet<PersonId> existingSubscribers) {
        ImmutableSet members = (ImmutableSet)this._entityMemberService.getEntityMembersByEntityId(entity.getId()).stream().map(EntityMemberWithPerson::getPersonId).collect(ImmutableSet.toImmutableSet());
        ImmutableSet nonMembers = Sets.difference(existingSubscribers, (Set)members).immutableCopy();
        this.updateSubscriptions(entity, (ImmutableSet<PersonId>)members, SubscriptionType.DEFAULT);
        this.updateSubscriptions(entity, (ImmutableSet<PersonId>)nonMembers, SubscriptionType.RECOMMENDED);
    }

    @Override
    public boolean visibleForAllPersons(@Nonnull DBEntity entity) {
        return this.getPrivacySelectedAuthorityNames(EntityItem.of(entity), DBPrivacyType.VISIBILITY).contains((Object)"LOGGED_IN");
    }

    private void updateSubscriptions(@Nonnull DBEntity entity, ImmutableSet<PersonId> personIdsForTenant, SubscriptionType subscriptionType) {
        ImmutableSetMultimap.Builder subscriptions = ImmutableSetMultimap.builder();
        personIdsForTenant.forEach(personId -> subscriptions.put((Object)entity.getId(), personId));
        this._likeDao.updateSubscriptions((SetMultimap<? extends ItemId, PersonId>)subscriptions.build(), SubscriptionState.SUBSCRIBED, subscriptionType);
    }

    private void createSubscriptions(@Nonnull DBEntity entity, ImmutableSet<PersonId> personIdsForTenant) {
        ImmutableSetMultimap.Builder subscriptions = ImmutableSetMultimap.builder();
        personIdsForTenant.forEach(personId -> subscriptions.put((Object)entity.getId(), personId));
        this._likeDao.insertSubscriptions((SetMultimap<? extends ItemId, PersonId>)subscriptions.build(), SubscriptionState.SUBSCRIBED, entity.getTenantSubscriptionType());
    }

    private boolean canBeSubscribed(@Nonnull DBEntity entity) {
        return this._entityTypeAppMappingService.getEntityTypesForApp(CoreApp.NEWS).contains((Object)entity.getType());
    }

    private void checkModificationPermissions(@Nonnull DBEntity fromDB, @Nonnull DBEntity toSave, @Nonnull AuthorizationCheckContextWithUserId authCtx) {
        EntityTab newDefaultTab;
        EntityItem entityItem = new EntityItem(fromDB);
        if (!fromDB.getName().equals(toSave.getName())) {
            authCtx.check(entityItem, (Action)StaticEntityAction.ENTITY_MODIFY_TITLE);
        }
        if ((newDefaultTab = toSave.getDefaultTab()) != null && !newDefaultTab.equals(fromDB.getDefaultTab())) {
            authCtx.check(entityItem, (Action)StaticEntityAction.ENTITY_MODIFY_TAB_SETTINGS);
        }
        ImmutableSet parentEntityIdsToCheck = EntityServiceImpl.diffLinkedEntities(fromDB, toSave).toSet();
        Map<EntityId, DBEntity> changedParents = this.getByIds((Set<EntityId>)parentEntityIdsToCheck);
        ImmutableSet.Builder actions = ImmutableSet.builder();
        for (EntityId id : parentEntityIdsToCheck) {
            EntityType parentType = InvalidIdServiceException.check(changedParents.get(id)).getType();
            actions.add((Object)Actions.entityModifyParent(parentType));
        }
        authCtx.check(entityItem, (ImmutableSet<? extends Action>)actions.build());
    }

    @Override
    public void updateTitle(EntityId entityId, String newTitle, AuthorizationCheckContextWithUserId authCtx) {
        DBEntity entity = this.getByIdNotNull(entityId);
        entity.setName(newTitle);
        this.updateEntity(authCtx, entity);
    }

    @Nonnull
    private static FluentIterable<EntityId> diffLinkedEntities(@Nullable DBEntity entity1, @Nullable DBEntity entity2) {
        final List<DBEntityLink> linkedEntities1 = entity1 != null ? entity1.getLinkedEntities() : null;
        final List<DBEntityLink> linkedEntities2 = entity2 != null ? entity2.getLinkedEntities() : null;
        return FluentIterable.from((Iterable)ImmutableList.of((Object)Predicates.alwaysTrue(), DBEntityLink.INHERITS_ADMIN, DBEntityLink.INHERITS_MEMBERS)).transformAndConcat((Function)new NullPermeableFunction<Predicate<DBEntityLink>, Set<EntityId>>(){

            @Override
            protected Set<EntityId> applySafe(Predicate<DBEntityLink> predicate) {
                return Sets.symmetricDifference(EntityServiceImpl.linkedEntitiesToSet(linkedEntities1, predicate), EntityServiceImpl.linkedEntitiesToSet(linkedEntities2, predicate));
            }
        });
    }

    @Nonnull
    private static ImmutableSet<EntityId> linkedEntitiesToSet(@Nullable List<DBEntityLink> linkedEntities, @Nonnull Predicate<DBEntityLink> predicate) {
        if (CollectionUtil.isEmpty(linkedEntities)) {
            return ImmutableSet.of();
        }
        return FluentIterable.from(linkedEntities).filter(predicate).transform(DBEntityLink::getLinkedEntityId).toSet();
    }

    @Override
    public ImmutableSet<JucoConstraintViolation> validateEntityBaseData(EntityBaseData baseData, AuthorizationCheckContextWithUserId authCtx) {
        DBEntity baseDataEntity = baseData.getEntity();
        EntityId id = baseDataEntity.getId();
        DBEntity originalEntity = id != null ? this.getByIdNotNull(id) : baseDataEntity;
        DBEntity toValidate = this.enrichEntityWithNewBaseData(originalEntity, baseData);
        return this.validateDynamicAttributes(authCtx, toValidate);
    }

    private void checkDynamicAttributes(@Nonnull AuthorizationCheckContextWithUserId authCtx, @Nonnull DBEntity entity) throws JucoConstraintViolationException {
        JucoConstraintViolationException.check(this.validateDynamicAttributes(authCtx, entity));
    }

    @Nonnull
    private ImmutableSet<JucoConstraintViolation> validateDynamicAttributes(@Nonnull AuthorizationCheckContextWithUserId authCtx, @Nonnull DBEntity entity) {
        return this._validator.validate(authCtx, new EntityWithDynamicAttributes(entity), Default.class, ServerGroup.class);
    }

    private void notifyMembersAboutEntityDataChangedIfNessary(final DBEntity oldEntity, final DBEntity newEntity, DBPerson triggeringUser) {
        if (!this.isEntityInThePast(newEntity) || !this.isEntityInThePast(oldEntity)) {
            boolean isDurationChanged;
            final String oldLocation = oldEntity.getLocation() == null ? "---" : oldEntity.getLocation().trim().toLowerCase();
            final String newLocation = newEntity.getLocation() == null ? "---" : newEntity.getLocation().trim().toLowerCase();
            final boolean isLocationChanged = !com.google.common.base.Objects.equal((Object)oldLocation, (Object)newLocation);
            boolean bl = isDurationChanged = !com.google.common.base.Objects.equal((Object)oldEntity.getStartAt(), (Object)newEntity.getStartAt()) || !com.google.common.base.Objects.equal((Object)oldEntity.getEndAt(), (Object)newEntity.getEndAt()) || !com.google.common.base.Objects.equal((Object)((Object)oldEntity.getTimeZone()), (Object)((Object)newEntity.getTimeZone()));
            if (this._entityConfig.notifyMemberOnLocationChangeActivated(newEntity.getType()) && isLocationChanged || this._entityConfig.notifyMemberOnDurationTimeChangeActivated(newEntity.getType()) && isDurationChanged) {
                ImmutableSet.Builder receivers = ImmutableSet.builder();
                ImmutableList<EntityMemberWithPerson> allEntityMembers = this._entityMemberService.getEntityMembersByEntityId(newEntity.getId());
                for (EntityMember member : allEntityMembers) {
                    if (!EntityMemberUtil.hasMemberRights(member)) continue;
                    receivers.add((Object)member.getPersonId());
                }
                MailTemplateContext context = new MailTemplateContext();
                this._entityNotificationService.sendMembersNotifyMail(context, triggeringUser, newEntity, (Set<PersonId>)receivers.build(), MailType.ENTITY_DATA_CHANGED, new EntityMemberNotificationService.MailI18nResolver(){

                    @Override
                    public String getSubject(String locale) {
                        return EntityServiceImpl.this._i18nService.getEntityMailsByEntityType(oldEntity.getType(), locale).mailSubjectEntityDataChanged(oldEntity.getName());
                    }

                    @Override
                    public void addI18nDependedContextAttribute(String locale, MailTemplateContext ctx) {
                        EntityConstants entityConstants = EntityServiceImpl.this._i18nService.getEntityConstantsByEntityType(newEntity.getType(), locale);
                        StringBuffer oldData = new StringBuffer();
                        StringBuffer newData = new StringBuffer();
                        if (isLocationChanged) {
                            oldData.append(entityConstants.location()).append(": ").append(oldLocation).append("\n");
                            newData.append(entityConstants.location()).append(": ").append(newLocation).append("\n");
                        }
                        if (isDurationChanged) {
                            oldData.append(entityConstants.duration()).append(": ").append(EntityServiceImpl.this.getLocalizedDurationString(oldEntity, locale)).append("\n");
                            newData.append(entityConstants.duration()).append(": ").append(EntityServiceImpl.this.getLocalizedDurationString(newEntity, locale)).append("\n");
                        }
                        ctx.put(GlobalMailTemplateKeys.ENTITY_OLD_DATA, (Object)oldData.toString());
                        ctx.put(GlobalMailTemplateKeys.ENTITY_NEW_DATA, (Object)newData.toString());
                    }
                });
            }
        }
    }

    @Override
    public String getLocalizedDurationString(DBEntity entity, String locale) {
        DateWithoutTimezone startDate = entity.getStartAt();
        DateWithoutTimezone endDate = entity.getEndAt();
        if (startDate == null || endDate == null) {
            return null;
        }
        boolean hasTimeZone = this._entityConfig.getDurationTimeOption(entity.getType()) == EntityDurationTimeOption.WITH_TIME_ZONE;
        TimeZone timeZone = hasTimeZone ? entity.getTimeZone() : null;
        return Dates.formatDuration(this._i18nService.dateFormatter(locale), startDate, endDate, timeZone);
    }

    @Override
    public EntityInfo getInfoById(EntityId id, AuthorizationCheckContextWithLocale authorizationContext) {
        return (EntityInfo)this.getInfoMapByIds((Set<EntityId>)ImmutableSet.of((Object)id), authorizationContext).get((Object)id);
    }

    @Override
    public ImmutableMap<EntityId, EntityInfo> getInfoMapByIds(Set<EntityId> ids, AuthorizationCheckContextWithLocale authorizationContext) {
        if (CollectionUtil.isEmpty(ids)) {
            return ImmutableMap.of();
        }
        return this.createInfos(this.getByIds(ids).values(), authorizationContext);
    }

    @Override
    public ImmutableList<EntityInfo> getInfosByIdsOrdered(Iterable<EntityId> ids, AuthorizationCheckContextWithLocale authorizationContext) {
        ImmutableSet idSet = ImmutableSet.copyOf(ids);
        Iterable<EntityInfo> result = this.getInfosByIdSet((Set<EntityId>)idSet, authorizationContext);
        return Ordering.explicit((List)idSet.asList()).onResultOf(Identifiables.toId()).immutableSortedCopy(result);
    }

    @Nonnull
    private Iterable<EntityInfo> getInfosByIdSet(@Nullable Set<EntityId> ids, @Nonnull AuthorizationCheckContextWithLocale authorizationContext) {
        if (CollectionUtil.isEmpty(ids)) {
            return ImmutableList.of();
        }
        return this.createInfos(this.getByIds(ids).values(), authorizationContext).values();
    }

    @Override
    public EntityBadge getBadgeById(EntityId id, AuthorizationCheckContextWithUserId authorizationContext) {
        return (EntityBadge)this.getBadgesByIds((Set<EntityId>)ImmutableSet.of((Object)id), authorizationContext).get((Object)id);
    }

    @Override
    public ImmutableMap<EntityId, EntityBadge> getBadgesByIds(Set<EntityId> ids, AuthorizationCheckContextWithUserId authorizationContext) {
        Map<EntityId, DBEntity> entities = this.getByIds(ids);
        HashSet parentIds = Sets.newHashSet();
        entities.values().forEach(e -> parentIds.addAll(e.getLinkedEntityIds()));
        ImmutableMap<EntityId, EntityInfo> parentTeasers = this.getInfoMapByIds(parentIds, authorizationContext);
        return this.createBadges((Iterable<DBEntity>)entities.values(), (Map<EntityId, EntityInfo>)parentTeasers, authorizationContext);
    }

    @Override
    public EntityStatistics getStatisticsById(EntityId id, AuthorizationCheckContextWithUserId authorizationContext) {
        authorizationContext.check((ItemId)id, (Action)StaticEntityAction.ENTITY_READ_DETAILS);
        int entityViews = this._analyticsService.getItemViews(id);
        int directSubscribers = this._likeService.getDirectSubscribersCount(id);
        return new EntityStatistics(entityViews, directSubscribers);
    }

    @Override
    public boolean isEntityComponentVisible(EntityId entityId, ComponentType componentType) {
        DBEntityComponent entityComponent = this.getComponentsByEntity(this.getByIdNotNull(entityId)).get(componentType);
        return entityComponent != null && entityComponent.isVisible();
    }

    @Override
    public Map<ComponentType, DBEntityComponent> getComponentsByEntity(DBEntity entity) {
        return this.getComponentsByEntities((Map<EntityId, DBEntity>)ImmutableMap.of((Object)entity.getId(), (Object)entity)).row((Object)entity.getId());
    }

    @Override
    public ImmutableTable<EntityId, ComponentType, DBEntityComponent> getComponentsByEntities(Map<EntityId, DBEntity> entities) {
        EntityCompontenConfigCache entityComponentConfig = new EntityCompontenConfigCache();
        CollectingServerEventCollector collector = new CollectingServerEventCollector();
        ImmutableTable<EntityId, ComponentType, DBEntityComponent> finalComponents = this.buildMissingComponents(entityComponentConfig, entities, collector);
        collector.fireEvents(this._eventBus);
        return this.buildComponentsByEntities(entities.values(), entityComponentConfig, finalComponents);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    private ImmutableTable<EntityId, ComponentType, DBEntityComponent> buildMissingComponents(EntityCompontenConfigCache entityComponentConfig, final Map<EntityId, DBEntity> entities, final CollectingServerEventCollector collector) {
        ImmutableTable<EntityId, ComponentType, DBEntityComponent> components = this._entityDAO.getComponentsByEntityIds(entities.keySet());
        ImmutableSet.Builder missingComponentBuilder = ImmutableSet.builder();
        for (DBEntity entity : entities.values()) {
            ImmutableSet existingComponents = components.row((Object)entity.getId()).keySet();
            ImmutableMap componentConfig = (ImmutableMap)entityComponentConfig.get(entity.getType());
            for (Map.Entry configuredComponent : componentConfig.entrySet()) {
                if (existingComponents.contains(configuredComponent.getKey())) continue;
                missingComponentBuilder.add((Object)this.createDefaultEntityComponent(entity, (EntityTypeAllowedComponent)configuredComponent.getValue(), (ComponentType)configuredComponent.getKey()));
            }
        }
        final ImmutableSet missingComponents = missingComponentBuilder.build();
        if (missingComponents.isEmpty()) {
            return components;
        }
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                EntityServiceImpl.this._entityDAO.addComponentToEntities((Iterable<DBEntityComponent>)missingComponents);
                ImmutableListMultimap.Builder entitiesPerType = ImmutableListMultimap.builder();
                for (DBEntityComponent component : missingComponents) {
                    entitiesPerType.put((Object)component.getComponentType(), (Object)((DBEntity)entities.get(component.getParentId())));
                }
                EntityServiceImpl.this._moduleService.create((ListMultimap<ComponentType, DBEntity>)entitiesPerType.build(), collector);
            }
        });
        return this._entityDAO.getComponentsByEntityIds(entities.keySet());
    }

    @Nonnull
    private ImmutableTable<EntityId, ComponentType, DBEntityComponent> buildComponentsByEntities(@Nonnull Iterable<DBEntity> entities, @Nonnull EntityCompontenConfigCache entityComponentConfig, @Nonnull ImmutableTable<EntityId, ComponentType, DBEntityComponent> daoResult) {
        ImmutableTable.Builder resultBuilder = ImmutableTable.builder();
        for (DBEntity entity : entities) {
            EntityId entityId = entity.getId();
            ImmutableMap result = daoResult.row((Object)entityId);
            EntityType entityType = entity.getType();
            ImmutableSet componentTypeSet = ((ImmutableMap)entityComponentConfig.get(entityType)).keySet();
            if (!result.keySet().containsAll((Collection)componentTypeSet)) {
                LOG.error("Not all modules can be loaded! Id:{}, Type:{}, Missing Modules: {}", new Object[]{entityId, entityType, Sets.filter((Set)componentTypeSet, (Predicate)Predicates.not((Predicate)Predicates.in((Collection)result.keySet())))});
            }
            for (DBEntityComponent component : result.values()) {
                ComponentType componentType = component.getComponentType();
                if (!componentTypeSet.contains((Object)componentType)) continue;
                resultBuilder.put((Object)component.getParentId(), (Object)componentType, (Object)component);
            }
        }
        return resultBuilder.build();
    }

    @Nonnull
    private DBEntityComponent createDefaultEntityComponent(@Nonnull DBEntity entity, @Nonnull EntityTypeAllowedComponent configuredComponent, @Nonnull ComponentType componentType) {
        ImmutableSet<String> defaultRoles = configuredComponent.getOptions().getOptionNamesFiltered(ConfOption.IS_PRE_SELECTED);
        return new DBEntityComponent(entity.getId(), componentType, configuredComponent.getPosition(), configuredComponent.getDefaultOrder(), configuredComponent.isDefaultVisible(), (Iterable<String>)defaultRoles, (List<AuthorityModel>)configuredComponent.getOptionsAsAuthorityModels().asList(), null);
    }

    @Nonnull
    private ImmutableMap<ComponentType, EntityTypeAllowedComponent> getEntityComponentConfig(EntityType entityType) {
        try {
            ConfFile configFile = this._configFileService.getConfigFile();
            ListMultimap<ComponentPosition, ConfComponentType> positions = configFile.getComponentPosition(Path.builder().add(entityType).build());
            ImmutableMap.Builder result = ImmutableMap.builder();
            int order = 0;
            for (Map.Entry entry : positions.entries()) {
                ConfComponentType t = (ConfComponentType)entry.getValue();
                ComponentType componentType = t.getComponentType();
                ConfOptionsFor options = configFile.getConfOption(Path.builder().add(entityType).add(componentType).add(StaticRight.ENTITY_WRITE).build());
                if (options == null) continue;
                EntityTypeAllowedComponent dbEntityTypeAllowedComponent = new EntityTypeAllowedComponent(componentType, (ComponentPosition)entry.getKey(), order, options, t.isDefaultVisible());
                result.put((Object)componentType, (Object)dbEntityTypeAllowedComponent);
                ++order;
            }
            return result.build();
        }
        catch (EvalException e) {
            LOG.error("Could not load default component configuration", (Throwable)e);
            throw new ServiceException(e);
        }
    }

    @Override
    public ImmutableMap<ComponentType, ComponentModel> getVisibleComponentsByEntity(EntityItem entity, SearchAuthorizationCheckContext authorizationContext) {
        Collection<ComponentPositionConfig> allowedComponents = this.getAllowedComponentsByEntity(entity, authorizationContext).values();
        Iterable visibleComponents = Iterables.filter(allowedComponents, ComponentPositionConfig.IS_VISIBLE);
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (ComponentPositionConfig c : visibleComponents) {
            try {
                ModuleData correspondingModuleData = this._moduleService.getModule(authorizationContext, entity, c.getType());
                if (correspondingModuleData != null && !correspondingModuleData.hasData()) continue;
                result.put((Object)c.getType(), (Object)new ComponentModel(entity.getId(), c, correspondingModuleData));
            }
            catch (InvalidIDException e) {
                LOG.warn(e.getMessage());
            }
        }
        return result.build();
    }

    @Override
    public Map<ComponentType, ComponentPositionConfig> getAllowedComponentsByEntity(EntityItem item, AuthorizationCheckContext authorizationContext) {
        authorizationContext.check(item, (Action)StaticEntityAction.ENTITY_READ_DETAILS);
        DBEntity entity = item.getEntity();
        final ImmutableMap<ComponentType, EntityTypeAllowedComponent> entityComponentConfig = this.getEntityComponentConfig(entity.getType());
        Map<ComponentType, DBEntityComponent> componentsByEntity = this.getComponentsByEntity(entity);
        return Maps.transformValues(componentsByEntity, (Function)new Function<DBEntityComponent, ComponentPositionConfig>(){

            public ComponentPositionConfig apply(DBEntityComponent c) {
                EntityTypeAllowedComponent entityTypeConfig = (EntityTypeAllowedComponent)entityComponentConfig.get(c.getComponentType());
                ImmutableSet<AuthorityModel> availableRolesToOpenFor = entityTypeConfig.getOptionsAsAuthorityModels();
                return new ComponentPositionConfig(c.getComponentType(), c.getPosition(), c.getOrder(), c.isVisible(), c.getOpenForAuthNames(), availableRolesToOpenFor, c.getCustomizedTitle());
            }
        });
    }

    @Override
    public Iterator<ObjectWithDepth<DBEntity>> getAllParents(EntityId id, boolean includeStartPointInResult, boolean skipDuplicates, EntityService.SearchDepth searchDepth) {
        return this.searchParentsWithDepth(id, (EntityService.SearchPredicates)new ParentSearchPredicates(id, searchDepth, includeStartPointInResult), skipDuplicates);
    }

    @Override
    public Iterator<DBEntity> searchParents(EntityId start, EntityService.SearchPredicates searchPredicates) {
        return this.searchParents(Collections.singletonList(start), searchPredicates);
    }

    @Override
    public Iterator<DBEntity> searchParents(Collection<EntityId> starts, EntityService.SearchPredicates searchPredicates, boolean skipDuplicates) {
        return Iterators.transform((Iterator)new SearchIterator(starts, searchPredicates, this, skipDuplicates), (Function)new Function<ObjectWithDepth<DBEntity>, DBEntity>(){

            public DBEntity apply(ObjectWithDepth<DBEntity> input) {
                return input != null ? input.getObject() : null;
            }
        });
    }

    @Override
    public Iterator<DBEntity> searchParents(Collection<EntityId> starts, EntityService.SearchPredicates searchPredicates) {
        return this.searchParents(starts, searchPredicates, true);
    }

    @Override
    public Iterator<ObjectWithDepth<DBEntity>> searchParentsWithDepth(EntityId start, EntityService.SearchPredicates searchPredicates) {
        return this.searchParentsWithDepth(Collections.singletonList(start), searchPredicates);
    }

    @Override
    public Iterator<ObjectWithDepth<DBEntity>> searchParentsWithDepth(EntityId start, EntityService.SearchPredicates searchPredicates, boolean skipDuplicates) {
        return this.searchParentsWithDepth(Collections.singletonList(start), searchPredicates, skipDuplicates);
    }

    @Override
    public Iterator<ObjectWithDepth<DBEntity>> searchParentsWithDepth(Collection<EntityId> starts, EntityService.SearchPredicates searchPredicates) {
        return this.searchParentsWithDepth(starts, searchPredicates, true);
    }

    @Override
    public Iterator<ObjectWithDepth<DBEntity>> searchParentsWithDepth(Collection<EntityId> starts, EntityService.SearchPredicates searchPredicates, boolean skipDuplicates) {
        return new SearchIterator(starts, searchPredicates, this, skipDuplicates);
    }

    @Override
    public void setEntityComponentPositions(EntityId entityId, Iterable<ComponentPositionConfig> positions, final AuthorizationCheckContext authorizationContext) {
        DBEntity entity = this.getByIdNotNull(entityId);
        final EntityItem entityItem = new EntityItem(entity);
        authorizationContext.check(entityItem, (Action)Actions.entityModifyTab(TabNameForConfiguration.SETTINGS));
        ImmutableMap<ComponentType, EntityTypeAllowedComponent> entityComponentConfig = this.getEntityComponentConfig(entity.getType());
        LazyLoader<ImmutableMap<ComponentType, ComponentPositionConfig>> components = new LazyLoader<ImmutableMap<ComponentType, ComponentPositionConfig>>(){

            @Override
            protected ImmutableMap<ComponentType, ComponentPositionConfig> load() {
                return ImmutableMap.copyOf(EntityServiceImpl.this.getAllowedComponentsByEntity(entityItem, authorizationContext));
            }
        };
        boolean mayMove = authorizationContext.may((Item<?>)entityItem, (Action)StaticEntityAction.ENTITY_MOVE_COMPONENTS);
        boolean mayEnable = authorizationContext.may((Item<?>)entityItem, (Action)StaticEntityAction.ENTITY_ENABLE_COMPONENTS);
        boolean didUpdate = false;
        for (ComponentPositionConfig p : positions) {
            ImmutableSet<String> openFor = p.getOpenFor();
            ImmutableSet<String> forcedByConfig = ((EntityTypeAllowedComponent)entityComponentConfig.get(p.getType())).getOptions().getOptionNamesFiltered(ConfOption.IS_FORCED);
            Sets.SetView missing = Sets.difference(forcedByConfig, openFor);
            if (!missing.isEmpty()) {
                LOG.warn("MISSING FORCED-ROLE\nSomeone tried to save Component-Privacy for {} of type {} without the required roles {}", new Object[]{entity.getId(), p.getType(), missing});
            }
            ComponentPositionConfig visibilitySource = EntityServiceImpl.existingOrNew(mayEnable, components, p);
            ComponentPositionConfig moveSource = EntityServiceImpl.existingOrNew(mayMove, components, p);
            DBEntityComponent dbc = new DBEntityComponent(entity.getId(), p.getType(), moveSource.getPosition(), moveSource.getOrder(), visibilitySource.isVisible(), (Iterable<String>)Sets.union(openFor, forcedByConfig), Lists.newArrayList(), p.getCustomizedTitle());
            this._entityDataService.updateComponentPosition(dbc);
            didUpdate = true;
        }
        if (didUpdate) {
            this._eventBus.post(new EntityComponentPositionsChangedEvent(entityId));
        }
    }

    @Nonnull
    private static ComponentPositionConfig existingOrNew(boolean may, @Nonnull LazyLoader<ImmutableMap<ComponentType, ComponentPositionConfig>> components, @Nonnull ComponentPositionConfig p) {
        if (may) {
            return p;
        }
        ComponentPositionConfig result = (ComponentPositionConfig)components.get().get((Object)p.getType());
        return result != null ? result : p;
    }

    private boolean beforeNow(@Nonnull DateWithoutTimezone date, @Nullable TimeZone timeZone) {
        Date withTimeZone = DateUtil.getServerDate((Date)date, timeZone != null ? timeZone : this._settings.getDefaultTimeZone());
        return withTimeZone.before(new Date());
    }

    @Override
    public boolean isEntityInThePast(DBEntity entity) {
        DateWithoutTimezone endAt = entity.getEndAt();
        return endAt != null && this._entityConfig.getDurationTimeOption(entity.getType()) != EntityDurationTimeOption.OFF && this.beforeNow(endAt, entity.getTimeZone());
    }

    @Override
    public boolean isEntityClosed(DBEntity entity) {
        DateWithoutTimezone closingDate = entity.getClosingDate();
        return closingDate != null && this._entityConfig.closingDateActivated(entity.getType()) && this.beforeNow(closingDate, entity.getTimeZone());
    }

    @Override
    public ImmutableListMultimap<EntityId, DBEntityLinkedEntityPrivacy> getEntityLinkedEntityPrivacies(Map<EntityId, DBEntity> entities) {
        ImmutableListMultimap<EntityId, DBEntityLinkedEntityPrivacy> result = this._entityDataService.getEntityLinkedEntityPrivacyByIds(entities.keySet());
        ImmutableListMultimap.Builder b = ImmutableListMultimap.builder();
        for (Map.Entry<EntityId, DBEntity> entry : entities.entrySet()) {
            b.putAll((Object)entry.getKey(), this.fillPrivacyWithAvailableAuthorityNames(entry.getValue(), (List<DBEntityLinkedEntityPrivacy>)result.get((Object)entry.getKey())));
        }
        return b.build();
    }

    @Override
    public ImmutableSet<EntityId> getEntityIdsByType(EntityType type) {
        return this._entityDAO.getEntityIdsByType(type);
    }

    @Override
    public ImmutableSet<EntityId> getDirectChildEntityIds(EntityId id) {
        return this._entityDAO.getChildEntityIds(id);
    }

    @Override
    public ImmutableListMultimap<EntityId, DBEntityLink> getDirectChildEntities(Set<EntityId> parentIds) {
        return this._entityDAO.getDirectChildEntities(parentIds);
    }

    @Override
    public ListAndCount<EntityInfo> getEntityInfoForTypes(ImmutableSet<EntityType> types, int offset, int count, SearchAuthorizationCheckContext authorizationContext) {
        ImmutableSet filterTypes = FluentIterable.from(types).transform(FilterTypes.GET_BY_TYPE).toSet();
        SearchResult<FederatedSearchResultEntry> searchResult = this._searchService.search(null, (Set<? extends FilterType>)filterTypes, SortType.ALPHABETICAL, SearchContextModel.create(SearchContext.ENTIRE_PLATFORM, null), null, StaticSearchFacetParameters.NO_FACETS, offset, count, authorizationContext);
        ImmutableList<FederatedSearchResultEntry> results = searchResult.getResults();
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (FederatedSearchResultEntry result : results) {
            EntityInfo info = result.invite(new JucoOnlySearchResultVisitor<EntityInfo>(){

                @Override
                public EntityInfo visitSearchResultBadgeModel(SearchResultBadgeModel<?, ?> badge) {
                    return badge.visit(new BadgeModelToEntityInfoVisitor());
                }
            });
            if (info == null) continue;
            resultBuilder.add((Object)info);
        }
        return new ListAndCount<EntityInfo>(searchResult.getNumberOfResults(), (Collection<EntityInfo>)resultBuilder.build());
    }

    private void notifyEntityUpdate(@Nonnull DBEntity oldEntity, @Nonnull DBEntity newEntity) {
        int oldLimit;
        int newLimit;
        this._updateHandler.onChange(new EntityUpdateEvent(newEntity.getId()));
        if (!EntityServiceImpl.diffLinkedEntities(oldEntity, newEntity).isEmpty()) {
            this._updateHandler.onChange(new EntityParentUpdateEvent(newEntity.getId()));
        }
        if ((newLimit = newEntity.getParticipantLimit()) > (oldLimit = oldEntity.getParticipantLimit()) || newLimit == -1 && oldLimit >= 0) {
            this._eventBus.post(new EntityParticipantLimitIncreasedEvent(newEntity.getId()));
        }
    }

    private void updateEntityModifyDate(@Nullable EntityId id, boolean skipForReleaseProcess) {
        this.updateEntityModifyDate(id, this._clock.now(), skipForReleaseProcess);
    }

    private void updateEntityModifyDate(@Nullable EntityId id, @Nonnull DateTime newModifyDate, boolean skipForReleaseProcess) {
        if (id == null) {
            return;
        }
        DBEntity entity = this.getById(id);
        if (entity == null) {
            return;
        }
        if (!(skipForReleaseProcess && this._entityConfig.releaseProcessMandatory(entity.getType()) || !newModifyDate.isAfter((ReadableInstant)new DateTime((Object)entity.getModifyDate())))) {
            this._entityDataService.updateEntityModifyDate(id, newModifyDate);
            this._updateHandler.onChange(new EntityUpdateModifyDateEvent(id));
        }
    }

    private void updateEntityModifyDateByChildId(@Nonnull ItemId childId, boolean skipForReleaseProcess) {
        try {
            this.updateEntityModifyDate(this._itemService.getParentEntityId(this._itemService.getByIdNonNull(childId)), skipForReleaseProcess);
        }
        catch (InvalidIDException ex) {
            LOG.warn("Got unexpected InvalidIdException during updating entity modify date. We will skip updating modify date!", (Throwable)ex);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onMicroblogPostingSaved(@Nonnull MicroblogPostingPublishedEvent e) {
        this.updateEntityModifyDateByChildId(e.getWorkstreamMessageId(), false);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onImageCreated(@Nonnull ImageCreatedEvent e) {
        DBAlbum album = e.getAlbum();
        if (album.isModule() && ItemType.ENTITY.equals(album.getParentId().getType())) {
            this.updateEntityModifyDate(new EntityId(album.getParentId().getId()), false);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onDocumentsDeleted(@Nonnull DriveDocumentsDeletedEvent e) {
        DateTime now = this._clock.now();
        e.getDocumentIds().stream().map(this::getParentEntityIdOrNull).filter(Objects::nonNull).distinct().forEach(entityId -> this.updateEntityModifyDate((EntityId)entityId, now, true));
    }

    @CheckForNull
    private EntityId getParentEntityIdOrNull(@Nonnull DriveDocumentId documentId) {
        try {
            return this._itemService.getParentEntityId(documentId);
        }
        catch (InvalidIDException e) {
            return null;
        }
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void onDocumentUpdated(DriveDocumentUpdatedEvent e) {
        try {
            EntityId parentEntityId = this._itemService.getParentEntityId(e.getDocumentId());
            this.updateEntityModifyDate(parentEntityId, e.getDocumentChangeDate(), true);
        }
        catch (InvalidIDException invalidIDException) {
            // empty catch block
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onVideolinkCreated(@Nonnull VideolinkCreatedEvent e) {
        this.updateEntityModifyDateByChildId(e.getVideolink().getParentId(), false);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityVersionPublished(@Nonnull EntityVersionPublishedEvent e) {
        if (EntityVersionType.MAJOR.equals((Object)e.getVersion().getVersionType())) {
            this.updateEntityModifyDate(e.getVersion().getEntityId(), false);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityVersionStatusUpdated(@Nonnull EntityVersionStatusUpdateEvent event) {
        EntityId entityId = event.getVersion().getEntityId();
        if (event.getVersion().getStatus().isPublished()) {
            this.updateEntityModifyDate(entityId, true);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onRawEditorVersionCreated(@Nonnull RawEditorVersionCreatedEvent e) {
        GlobalId parentId = e.getParentId();
        if (e.isUpdate() && parentId instanceof EntityId) {
            this.updateEntityModifyDate((EntityId)parentId, false);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onCommentCreated(@Nonnull CommentCreatedEvent e) {
        this.updateEntityModifyDateByChildId(e.getComment().getParentId(), false);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onNewWikiVersion(@Nonnull NewWikiVersionEvent e) {
        this.updateEntityModifyDate(e.getParentEntityId(), false);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onNewMultiWikiVersion(@Nonnull MultiWikiVersionCreatedEvent e) {
        this.updateEntityModifyDate(e.getEntityId(), true);
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void onProfileChanged(@Nonnull ProfileChangedEvent e) {
        ImmutableSetMultimap<EntityType, DynamicAttributeConfig> attributes = this._entityConfig.getSearchableDynamicAttributes();
        Set<DynamicAttributeId> profileDependentAttributes = attributes.values().stream().filter(attribute -> attribute != null && attribute.getInput().accept(new Input.InputVisitor<Boolean>(){

            @Override
            public Boolean visit(SelectionInput selectionInput) {
                return Boolean.FALSE;
            }

            @Override
            public Boolean visit(TextInput textInput) {
                return Boolean.FALSE;
            }

            @Override
            public Boolean visit(TextAreaInput textAreaInput) {
                return Boolean.FALSE;
            }

            @Override
            public Boolean visit(PersonSuggestInput suggestInput) {
                return Boolean.TRUE;
            }

            @Override
            public Boolean visit(NumberInput numberInput) {
                return Boolean.FALSE;
            }

            @Override
            public Boolean visit(ArithmeticOperationInput arithmeticOperationInput) {
                return Boolean.FALSE;
            }
        }) != false).map(DynamicAttributeConfig::getId).collect(Collectors.toSet());
        if (profileDependentAttributes.isEmpty()) {
            return;
        }
        ImmutableSet<EntityId> entitiesToReindex = this._entityDynamicAttributeDao.getEntityIdsWithDynamicAttributes(profileDependentAttributes, Set.of(e.getPersonId().idAsLongValue().toString()));
        if (!entitiesToReindex.isEmpty()) {
            this._updateHandler.onChanges(entitiesToReindex.stream().map(EntityUpdateEvent::new).collect(Collectors.toSet()));
        }
    }

    @Override
    public EntityId getIdByNameAndType(String entityName, EntityType entityType) {
        return this._entityDAO.getEntityIdByNameAndType(entityName, entityType);
    }

    @Override
    public void deleteEntitiesAndDependants(Set<EntityId> entityIds, DeletionContext deletionContext) {
        Map<EntityId, DBEntity> entityMap = this.getByIds(entityIds);
        this._entityDataService.deleteEntities(entityIds);
        deletionContext.attach(() -> {
            entityMap.values().forEach(entity -> {
                String icon;
                String logo = entity.getLogo();
                if (!StringUtils.isBlank((String)logo)) {
                    this._storageServerHelper.deleteFileOnStorageServer(ImageType.ENTITY_IMAGE.getPath(), logo);
                }
                if (!StringUtils.isBlank((String)(icon = entity.getIcon()))) {
                    this._storageServerHelper.deleteFileOnStorageServer(ImageType.ENTITY_IMAGE.getPath(), icon);
                }
            });
            this._entityDataService.deleteEntityCache(entityIds);
            this._entityMemberCacheService.invalidateCacheForDeletedEntities(entityIds);
            entityIds.forEach(entityId -> this._eventBus.post(new ItemDeletedEvent((GlobalId)entityId)));
            Set entityUpdates = entityIds.stream().map(EntityUpdateEvent::new).collect(Collectors.toSet());
            this._updateHandler.onChanges(entityUpdates);
        });
    }

    @Override
    public void deleteEntity(final EntityId id, AuthorizationCheckContextWithUserId authorizationContext) {
        String icon;
        DBEntity entity = this.getById(id);
        if (entity == null) {
            return;
        }
        DBPerson personThatDeletes = this._personService.getPersonByIdNotNull(authorizationContext.getUserId());
        authorizationContext.check(new EntityItem(entity), (Action)StaticEntityAction.ENTITY_DELETE);
        ImmutableSet<EntityId> childEntityIds = this._entityDAO.getChildEntityIds(id);
        if (!childEntityIds.isEmpty()) {
            throw new DeleteEntityReferenceException(this.getInfosByIdsOrdered((Iterable<EntityId>)childEntityIds, authorizationContext));
        }
        Stream.Builder afterCommitBuilder = Stream.builder();
        this._deletionService.deleteInTransactionWithDeleteAction(id, personThatDeletes.getId(), new TransactionCallbackWithDeleteAction<Object>(){

            @Override
            public Object doInTransactionWithDeleteAction(TransactionStatus status, DeleteAction deleteAction) {
                EntityServiceImpl.this._entityDataService.deleteEntity(id);
                return this;
            }
        });
        afterCommitBuilder.build().forEach(r -> r.run());
        String logo = entity.getLogo();
        if (!StringUtils.isBlank((String)logo)) {
            this._storageServerHelper.deleteFileOnStorageServer(ImageType.ENTITY_IMAGE.getPath(), logo);
        }
        if (!StringUtils.isBlank((String)(icon = entity.getIcon()))) {
            this._storageServerHelper.deleteFileOnStorageServer(ImageType.ENTITY_IMAGE.getPath(), icon);
        }
        this._entityDataService.deleteEntityCache((Set<EntityId>)ImmutableSet.of((Object)id));
        this._entityMemberCacheService.invalidateCache((Set<PersonId>)FluentIterable.from(this._entityMemberService.getEntityMembersByEntityId(id)).transform(EntityMember.GET_PERSON_ID).toSet(), (Set<EntityId>)ImmutableSet.of((Object)id));
        this._eventBus.post(new ItemDeletedEvent(id));
        this._updateHandler.onChange(new EntityUpdateEvent(id));
    }

    @Nonnull
    private ImmutableSet<String> joinWithForcedAuthorityNamesForRight(@Nonnull Collection<String> selectedNames, @Nonnull EntityType type, @Nonnull Right right) {
        ConfOptionsFor privacyOptionsForRight = this._entityConfig.getEntityPrivacyOptions(type, right);
        ImmutableSet<String> forcedAuthorities = privacyOptionsForRight.getOptionNamesFiltered(ConfOption.IS_FORCED);
        ImmutableSet result = ImmutableSet.builder().addAll(selectedNames).addAll(forcedAuthorities).build();
        HashSet missing = Sets.newHashSet((Iterable)result);
        missing.removeAll(selectedNames);
        if (!missing.isEmpty()) {
            LOG.warn("MISSING FORCED-ROLE: Tried to save Entity-Privacy for type {} without the required role {}", (Object)type, (Object)missing);
        }
        return result;
    }

    @Override
    public ListAndCount<EntityBadgeWithRole> getBadgesWithRoleByEntityTypeAndPerson(EntityType type, PersonId personId, int offset, int limit, AuthorizationCheckContextWithUserId authorizationContext) {
        ImmutableSet nonArchivedEntities;
        ImmutableSetMultimap<EntityId, EntityMemberRole> allRoles = this._entityMemberService.getMemberRolesByPersonIdAndEntityTypes(personId, (ImmutableSet<EntityType>)ImmutableSet.of((Object)type), authorizationContext);
        if (this._entityConfig.releaseProcessMandatory(type)) {
            ImmutableMap<EntityId, EntityVersion> currentEntityVersions = this._entityVersionService.getCurrentEntityVersions((Set<EntityId>)allRoles.keySet(), authorizationContext);
            Map activeVersions = Maps.filterValues(currentEntityVersions, (Predicate)Predicates.not((Predicate)Predicates.compose(EntityStatus.IS_ARCHIVED, EntityVersion.TO_ENTITY_STATUS)));
            SetMultimap filteredRoles = Multimaps.filterKeys(allRoles, (Predicate)Predicates.in(activeVersions.keySet()));
            nonArchivedEntities = ImmutableSet.copyOf((Collection)filteredRoles.keySet());
        } else {
            nonArchivedEntities = ImmutableSet.copyOf((Collection)allRoles.keySet());
        }
        ImmutableMap<EntityId, EntityBadge> allBadges = this.getBadgesByIds((Set<EntityId>)nonArchivedEntities, authorizationContext);
        List<EntityBadge> badges = CollectionUtil.subList(ImmutableList.copyOf(allBadges.values()), offset, offset + limit);
        ListAndCount<EntityBadgeWithRole> result = new ListAndCount<EntityBadgeWithRole>(badges.size());
        result.setMaxCount(nonArchivedEntities.size());
        for (EntityBadge badge : badges) {
            ImmutableSortedSet sorted = ImmutableSortedSet.copyOf((Collection)allRoles.get((Object)((EntityId)badge.getId())));
            result.add(new EntityBadgeWithRole(badge, (ImmutableSortedSet<EntityMemberRole>)(badge.isVisible() ? sorted : ImmutableSortedSet.of())));
        }
        return result;
    }

    @Override
    public List<EntityId> searchPathFromEntityToEntity(EntityId childEntityId, final EntityId ancestorEntityId) {
        final ArrayList<EntityId> path = new ArrayList<EntityId>(100);
        Iterator<DBEntity> search = this.searchParents(childEntityId, new EntityService.SearchPredicates(){

            @Override
            public boolean isResult(DBEntity e, int depth, EntityId childBefore) {
                if (childBefore != null && depth > 0) {
                    if (path.size() > depth - 1) {
                        path.set(depth - 1, childBefore);
                    } else {
                        path.add(depth - 1, childBefore);
                    }
                }
                if (path.size() > depth) {
                    path.set(depth, e.getId());
                } else {
                    path.add(depth, e.getId());
                }
                return e.getId().equals(ancestorEntityId);
            }

            @Override
            public boolean expand(DBEntity e, int depth, EntityId childBefore) {
                return true;
            }
        });
        if (search.hasNext()) {
            return path;
        }
        return null;
    }

    @Override
    public List<EntityId> searchShortesPathToRootEntity(EntityId entityId) {
        final ArrayList<EntityId> path = new ArrayList<EntityId>(100);
        Iterator<DBEntity> search = this.searchParents(entityId, new EntityService.SearchPredicates(){

            @Override
            public boolean isResult(DBEntity e, int depth, EntityId childBefore) {
                if (childBefore != null && depth > 0) {
                    if (path.size() > depth - 1) {
                        path.set(depth - 1, childBefore);
                    } else {
                        path.add(depth - 1, childBefore);
                    }
                }
                if (path.size() > depth) {
                    path.set(depth, e.getId());
                } else {
                    path.add(depth, e.getId());
                }
                return CollectionUtil.isEmpty(e.getLinkedEntities());
            }

            @Override
            public boolean expand(DBEntity e, int depth, EntityId childBefore) {
                return true;
            }
        });
        if (search.hasNext()) {
            return path;
        }
        return path;
    }

    @Override
    public UpdateEntityResponse updateEntityDescription(AuthorizationCheckContextWithUserId authCtx, EntityId entityId, String description, boolean notifySubscriber) throws InvalidIDException {
        PersonId personId = authCtx.getUserId();
        DBEntity entity = this.getByIdNotNull(entityId);
        authCtx.check(new EntityItem(entity), (Action)StaticEntityAction.ENTITY_MODIFY);
        entity.setDescription(description);
        UpdateEntityResponse result = this.checkEntityBaseData(entity);
        this._entityDataService.updateEntityDescription(entityId, Strings.nullToEmpty((String)entity.getDescription()), this._clock.now());
        this._eventBus.post(new EntityDescriptionUpdatedEvent(entity, personId, notifySubscriber));
        return result;
    }

    @Override
    public ImmutableSetMultimap<DBPrivacyType, String> getPrivacySelectedAuthorityNames(EntityItem entityItem, Set<DBPrivacyType> privacyTypes) {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        EntityId id = entityItem.getId();
        ImmutableList privacyFromDB = this._entityDataService.getPrivacySelectedAuthorities((Set<EntityId>)ImmutableSet.of((Object)id)).get((Object)id);
        ImmutableSetMultimap namesFromDB = ImmutableSetMultimap.copyOf((Multimap)Multimaps.transformValues((ListMultimap)FluentIterable.from((Iterable)privacyFromDB).index(DBPrivacySelection.TO_TYPE), DBPrivacySelection.TO_NAME));
        for (DBPrivacyType privacyType : privacyTypes) {
            Path path = Path.builder().add(entityItem).add(privacyType.getRight()).build();
            ImmutableCollection options = this._configFileService.getConfigFile().getConfOption(path).getOptions().values();
            ImmutableSet fromDB = namesFromDB.get((Object)privacyType);
            for (ConfOption option : options) {
                if (!option.isForced() && !fromDB.contains((Object)option.getName())) continue;
                result.put((Object)privacyType, (Object)option.getName());
            }
        }
        return result.build();
    }

    @Override
    public ImmutableSet<String> getPrivacySelectedAuthorityNames(EntityItem entityItem, DBPrivacyType privacyType) {
        return this.getPrivacySelectedAuthorityNames(entityItem, (Set<DBPrivacyType>)ImmutableSet.of((Object)((Object)privacyType))).get((Object)privacyType);
    }

    @Override
    public void modifyPrivacyForImport(final DBEntity entity, final DBPrivacyType privacyType, ImmutableSet<String> visibility) {
        ConfOptionsFor privacyOptionsForRight = this._entityConfig.getEntityPrivacyOptions(entity.getType(), privacyType.getRight());
        ImmutableSet<String> allowedAuthorities = privacyOptionsForRight.getOptionNames();
        final ImmutableSet<String> newVisibility = Roles.intersectRoles(visibility, allowedAuthorities);
        final CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                EntityServiceImpl.this.savePrivacySelectedAuthorities(entity.getId(), new PrivacyModifyCommand(){

                    @Override
                    public ImmutableList<DBPrivacySelection> execute(ImmutableList<DBPrivacySelection> object) {
                        return this.setPrivacySettingsForType(object, privacyType, (Collection<String>)newVisibility, entity.getType());
                    }
                }, (ServerEventCollector)eventCollector);
            }
        });
        eventCollector.fireEvents(this._eventBus);
    }

    @Override
    public UpdateEntityResponse updateEntityBaseData(final AuthorizationCheckContextWithUserId authCtx, final EntityBaseData entityBaseData, final boolean notifyMemberDataChange) {
        DBEntity cleanEntity = this.getByIdNotNull(entityBaseData.getEntity().getId());
        final DBEntity entityToUpdate = this.enrichEntityWithNewBaseData(cleanEntity, entityBaseData);
        final CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
        UpdateEntityResponse response = this._transactionHelper.doInTransaction(new TransactionCallback<UpdateEntityResponse>(){

            public UpdateEntityResponse doInTransaction(TransactionStatus status) {
                EntityServiceImpl.this.savePrivacySelectedAuthorities(entityToUpdate.getId(), new PrivacyModifyCommand(){

                    @Override
                    public ImmutableList<DBPrivacySelection> execute(ImmutableList<DBPrivacySelection> object) {
                        ImmutableList<DBPrivacySelection> visibility = this.setPrivacySettingsForType(object, DBPrivacyType.VISIBILITY, (Collection<String>)entityBaseData.getVisibility(), entityToUpdate.getType());
                        ImmutableList<DBPrivacySelection> joining = this.setPrivacySettingsForType(visibility, DBPrivacyType.JOINING, (Collection<String>)entityBaseData.getJoinOption(), entityToUpdate.getType());
                        ImmutableList<DBPrivacySelection> withJoinRequests = this.setPrivacySettingsForType(joining, DBPrivacyType.JOIN_REQUEST, (Collection<String>)entityBaseData.getJoinRequestOption(), entityToUpdate.getType());
                        ImmutableList<DBPrivacySelection> withModifyTitle = this.setPrivacySettingsForType(withJoinRequests, DBPrivacyType.MODIFY_TITLE, (Collection<String>)entityBaseData.getModifyTitleRoles(), entityToUpdate.getType());
                        return this.setPrivacySettingsForType(withModifyTitle, DBPrivacyType.ENTITY_EDIT, (Collection<String>)entityBaseData.getEntityEditRoles(), entityToUpdate.getType());
                    }
                }, (ServerEventCollector)eventCollector);
                return EntityServiceImpl.this.updateEntityInternal(authCtx, entityToUpdate, notifyMemberDataChange, true, eventCollector);
            }
        });
        eventCollector.fireEvents(this._eventBus);
        return response;
    }

    @Nonnull
    private ParentInheritanceChanges createInheritanceInformation(@Nullable List<DBEntityLink> parentsBeforeUpdate, @Nullable List<DBEntityLink> parentsAfterUpdate) {
        ImmutableMap newParentsMap = parentsAfterUpdate == null ? ImmutableMap.of() : Maps.uniqueIndex(parentsAfterUpdate, DBEntityLink::getLinkedEntityId);
        ImmutableSet oldParentsSet = parentsBeforeUpdate == null ? ImmutableSet.of() : FluentIterable.from(parentsBeforeUpdate).transform(DBEntityLink::getLinkedEntityId).toSet();
        boolean parentsChanged = !newParentsMap.keySet().equals((Object)oldParentsSet);
        boolean adminsChanged = false;
        boolean membersChanged = false;
        if (parentsBeforeUpdate != null) {
            for (DBEntityLink oldParent : parentsBeforeUpdate) {
                DBEntityLink newParent = (DBEntityLink)newParentsMap.get((Object)oldParent.getLinkedEntityId());
                if (newParent != null) {
                    adminsChanged = adminsChanged || oldParent.isInheritsAdmins() != newParent.isInheritsAdmins();
                    membersChanged = membersChanged || oldParent.isInheritsMembers() != newParent.isInheritsMembers();
                } else {
                    adminsChanged = adminsChanged || oldParent.isInheritsAdmins();
                    boolean bl = membersChanged = membersChanged || oldParent.isInheritsMembers();
                }
                if (!adminsChanged || !membersChanged) continue;
                break;
            }
        }
        if (!(parentsAfterUpdate == null || adminsChanged && membersChanged)) {
            for (DBEntityLink newParent : parentsAfterUpdate) {
                if (!oldParentsSet.contains((Object)newParent.getLinkedEntityId())) {
                    adminsChanged = adminsChanged || newParent.isInheritsAdmins();
                    boolean bl = membersChanged = membersChanged || newParent.isInheritsMembers();
                }
                if (!adminsChanged || !membersChanged) continue;
                break;
            }
        }
        return new ParentInheritanceChanges(parentsChanged, adminsChanged, membersChanged);
    }

    @Nonnull
    private DBEntity enrichEntityWithNewBaseData(@Nonnull DBEntity entityToEnrich, @Nonnull EntityBaseData entityBaseData) {
        DBEntity entity = entityBaseData.getEntity();
        entityToEnrich.setName(entity.getName());
        entityToEnrich.setTenantSubscriptionType(entity.getTenantSubscriptionType());
        entityToEnrich.setTags(entity.getTags());
        entityToEnrich.setTimeZone(entity.getTimeZone());
        entityToEnrich.setClosingDate(entity.getClosingDate());
        entityToEnrich.setStartAt(entity.getStartAt());
        entityToEnrich.setEndAt(entity.getEndAt());
        entityToEnrich.setLinkedEntities(entity.getLinkedEntities());
        entityToEnrich.setLocation(entity.getLocation());
        entityToEnrich.setDynamicAttributes(this.transform(entity.getId(), entityBaseData.getDynamicAttributes()));
        entityToEnrich.setParticipantLimit(entity.getParticipantLimit());
        entityToEnrich.setDefaultTab(entity.getDefaultTab());
        return entityToEnrich;
    }

    @Nonnull
    private ImmutableList<EntityDynamicAttributeClientModel> transform(@Nonnull EntityId entityId, @Nonnull ImmutableList<DynamicAttributeEditModel> formData) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DynamicAttributeEditModel model : formData) {
            builder.add((Object)new EntityDynamicAttributeClientModel(entityId, model.getId(), model.getValues()));
        }
        return builder.build();
    }

    private void updateDynamicAttributes(final @Nonnull EntityId entityId, @Nonnull EntityType entityType, final @Nonnull ImmutableList<? extends IEntityDynamicAttribute> attributes) {
        final ImmutableSet configuredIds = FluentIterable.from(this._entityConfig.getDynamicAttributesForType(entityType)).transform(Identifiables.toId()).toSet();
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                if (!status.isRollbackOnly()) {
                    EntityServiceImpl.this._entityDynamicAttributeDao.deleteAttributesForEntity(entityId, (ImmutableSet<DynamicAttributeId>)configuredIds);
                    EntityServiceImpl.this._entityDynamicAttributeDao.insertAttributes(Lists.transform((List)attributes, EntityDynamicAttribute.FROM_INTERFACE));
                }
            }
        });
        this._entityDataService.deleteEntityCache((Set<EntityId>)ImmutableSet.of((Object)entityId));
    }

    @Nonnull
    private ImmutableSet<EntityId> getDifferingParents(@Nullable List<DBEntityLink> oldParentList, @Nullable List<DBEntityLink> newParentList) {
        ImmutableSet oldParentIds = oldParentList != null ? FluentIterable.from(oldParentList).transform(ENTITY_LINK_TO_ENTITY_ID).toSet() : ImmutableSet.of();
        ImmutableSet newParentIds = newParentList != null ? FluentIterable.from(newParentList).transform(ENTITY_LINK_TO_ENTITY_ID).toSet() : ImmutableSet.of();
        return Sets.difference((Set)newParentIds, (Set)oldParentIds).immutableCopy();
    }

    private void savePrivacySelectedAuthorities(@Nonnull EntityId id, @Nonnull PrivacyModifyCommand command, @Nonnull ServerEventCollector eventCollector) {
        List privacySelectedAuthorities = (List)command.execute(this._entityDataService.getPrivacySelectedAuthorities((Set<EntityId>)ImmutableSet.of((Object)id)).get((Object)id));
        this.savePrivacySelectedAuthorities(id, privacySelectedAuthorities, eventCollector);
    }

    @Override
    @VisibleForTesting
    public void savePrivacySelectedAuthorities(EntityId id, List<DBPrivacySelection> authorities, ServerEventCollector eventCollector) {
        EntityItem entityItem = new EntityItem(this.getByIdNotNull(id));
        ImmutableSetMultimap<DBPrivacyType, String> oldVisibilities = this.getPrivacySelectedAuthorityNames(entityItem, (Set<DBPrivacyType>)ImmutableSet.copyOf((Object[])DBPrivacyType.values()));
        this._entityDataService.saveEntityPrivacies(id, authorities);
        ImmutableSetMultimap<DBPrivacyType, String> newVisibilities = this.getPrivacySelectedAuthorityNames(entityItem, (Set<DBPrivacyType>)ImmutableSet.copyOf((Object[])DBPrivacyType.values()));
        ImmutableSet changedPrivacies = FluentIterable.from((Object[])DBPrivacyType.values()).filter(p -> !com.google.common.base.Objects.equal((Object)oldVisibilities.get((Object)p), (Object)newVisibilities.get((Object)p))).toSet();
        if (!changedPrivacies.isEmpty()) {
            if (changedPrivacies.contains((Object)DBPrivacyType.VISIBILITY)) {
                this._updateHandler.onChange(new EntityVisibilitiesUpdateEvent(id));
            }
            eventCollector.add(new EntityPrivacyChangedEvent(id, (ImmutableSet<DBPrivacyType>)changedPrivacies));
        }
    }

    @Override
    public void saveEntityExtendedData(final EntityExtendedData entityExtendedData) {
        final DBEntity entity = this.getByIdNotNull(entityExtendedData.getEntityId());
        final EntityType entityType = entity.getType();
        for (DBEntityLinkedEntityPrivacy linkPrivacy : entityExtendedData.getPrivacyData()) {
            ImmutableSet<String> storeChangeParents = this.joinWithForcedAuthorityNamesForRight((Collection<String>)linkPrivacy.getSelectedAuthorityNames(), entityType, Rights.entityChangeParent(entityType));
            linkPrivacy.setSelectedAuthorityNames(storeChangeParents);
        }
        final CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus transactionstatus) {
                EntityServiceImpl.this._entityDAO.saveEntityLinkedEntityPrivacy(entity.getId(), entityExtendedData.getPrivacyData());
                EntityServiceImpl.this.savePrivacySelectedAuthorities(entity.getId(), new PrivacyModifyCommand(){

                    @Override
                    public ImmutableList<DBPrivacySelection> execute(ImmutableList<DBPrivacySelection> object) {
                        HashMap<DBPrivacyType, Collection<String>> newSettings = new HashMap<DBPrivacyType, Collection<String>>(3);
                        newSettings.put(DBPrivacyType.INVITING, entityExtendedData.getInvitingRule());
                        newSettings.put(DBPrivacyType.NEWSLETTER, entityExtendedData.getNewsletterRule());
                        return this.setPrivacySettingsForType(object, newSettings, entityType);
                    }
                }, (ServerEventCollector)eventCollector);
                EntityServiceImpl.this._entityDataService.updateEntity(entity);
            }
        });
        this._updateHandler.onChange(new EntityUpdateEvent(entity.getId()));
        eventCollector.fireEvents(this._eventBus);
    }

    @Nonnull
    private static DateWithoutTimezone getFullHourDateFromNow(int houroffset) {
        Calendar result = Calendar.getInstance();
        result.set(10, result.get(10) + houroffset);
        result.set(12, 0);
        result.set(13, 0);
        return new DateWithoutTimezone(result.getTime());
    }

    @Nonnull
    private static Date addHour(@Nonnull Date date, int hourToAdd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(11, hourToAdd);
        return cal.getTime();
    }

    @Override
    public DefaultEntityBaseData defaultNewEntity(EntityId parentId, EntityType entityType, String defaultName, Date defaultDate, AuthorizationCheckContextWithUserId auth) {
        boolean canInherit = this.canInherit(entityType, parentId, auth);
        DBEntity entity = new DBEntity();
        entity.setName(defaultName);
        entity.setTenantSubscriptionType(SubscriptionType.RECOMMENDED);
        entity.setType(entityType);
        EntityInfo parentTeaser = canInherit ? this.getInfoById(parentId, auth) : null;
        entity.setLinkedEntities((List<DBEntityLink>)(parentTeaser != null ? ImmutableList.of((Object)new DBEntityLink(parentId, false, false)) : ImmutableList.of()));
        if (this._entityConfig.getDurationTimeOption(entityType) != EntityDurationTimeOption.OFF) {
            if (defaultDate != null) {
                entity.setStartAt(new DateWithoutTimezone(defaultDate));
                entity.setEndAt(new DateWithoutTimezone(EntityServiceImpl.addHour(defaultDate, 1)));
            } else {
                entity.setStartAt(EntityServiceImpl.getFullHourDateFromNow(1));
                entity.setEndAt(EntityServiceImpl.getFullHourDateFromNow(2));
            }
            if (this._entityConfig.getDurationTimeOption(entityType) == EntityDurationTimeOption.WITH_TIME_ZONE) {
                entity.setTimeZone(this._personService.getTimeZoneOfUserOrDefault(auth.getUserId()));
            }
        }
        ImmutableSet<String> visibility = this._entityConfig.getDefaultVisibilityRuleAuthNames(entityType);
        ImmutableSet<String> joining = this._entityConfig.getDefaultJoiningRuleAuthNames(entityType);
        ImmutableSet<String> joinRequest = this._entityConfig.getDefaultSendJoinRequestAllowedRuleAuthNames(entityType);
        ImmutableSet<String> modifyTitleRoles = this._entityConfig.getDefaultModifyTitleRuleAuthNames(entityType);
        ImmutableSet<String> editEntityRoles = this._entityConfig.getDefaultEditEntityRuleAuthNames(entityType);
        if (canInherit) {
            DBEntity parent = this.getByIdNotNull(parentId);
            EntityItem parentItem = new EntityItem(parent);
            ImmutableSet<EntityInheritValue> inheritSettings = this._entityConfig.entityInhertitSettings(parent.getType(), entity.getType());
            visibility = this.inheritPrivacySettings(parentItem, DBPrivacyType.VISIBILITY, visibility, inheritSettings.contains((Object)EntityInheritValue.VISIBILITY_SETTING));
            joining = this.inheritPrivacySettings(parentItem, DBPrivacyType.JOINING, joining, inheritSettings.contains((Object)EntityInheritValue.JOIN_SETTING));
            joinRequest = this.inheritPrivacySettings(parentItem, DBPrivacyType.JOIN_REQUEST, joinRequest, inheritSettings.contains((Object)EntityInheritValue.JOIN_REQUEST_SETTING));
        }
        ImmutableSet actions = FluentIterable.from(Actions.ENTITY_EDIT_TAB_ACTIONS).append((Object[])new Action[]{StaticEntityAction.ENTITY_MODIFY_TAB_SETTINGS}).toSet();
        ImmutableSet<Action> checkedActions = auth.may(new PseudoEntityItem(entityType), (ImmutableSet<? extends Action>)actions);
        ImmutableMap linkedPrivacyByType = Maps.uniqueIndex(this.defaultLinkedEntityPrivacySettings(entityType), DBEntityLinkedEntityPrivacy::getEntityType);
        ImmutableSet<EditEntityHistoryTokenTabName> visibleTabs = this.getVisibleEntityEditTabs(entityType, checkedActions, (ImmutableMap<EntityType, DBEntityLinkedEntityPrivacy>)linkedPrivacyByType);
        TenantId tenantId = auth.getTenantId();
        return new DefaultEntityBaseData(entity, visibility, joining, joinRequest, modifyTitleRoles, editEntityRoles, checkedActions, parentTeaser, visibleTabs, this.getTenantName(tenantId));
    }

    @Nonnull
    private ImmutableSet<String> inheritPrivacySettings(@Nullable EntityItem parent, @Nonnull DBPrivacyType privacyType, @Nonnull ImmutableSet<String> defaults, boolean doInherit) {
        return doInherit && parent != null ? this.getPrivacySelectedAuthorityNames(parent, privacyType) : defaults;
    }

    @Override
    public EntityBadge createPlaceholder(DBEntity entity, AuthorizationContextWithLocale authorizationContext) {
        BasicConstants basicConstants = this._i18nService.createProxy(BasicConstants.class, authorizationContext.getLocale());
        return new EntityPlaceholderBadgeBean(entity.getId(), entity.getType(), basicConstants.secretItem(), this._entityConfig.getEntityMemberWorkflow(entity.getType()));
    }

    private void copyDBToBadge(DBEntity db, EntityBadgeSetters m, @Nullable EntityVersionClientModel currentVersion, @Nullable EntityVersionClientModel lastPublicVersion, boolean fast, @Nonnull AuthorizationCheckContextWithUserId authorizationContext) {
        this.copyDBToInfo(db, m);
        m.setDescription(db.getDescription());
        if (!fast) {
            m.setLinkedEntities(this.getInfosByIdsOrdered(db.getLinkedEntityIds(), authorizationContext));
            m.setVersion(currentVersion);
            m.setLastPublicVersion(lastPublicVersion);
        }
    }

    @Override
    public void copyDBToInfo(DBEntity db, EntityInfoSetters m) {
        m.setId(db.getId());
        m.setLogo(db.getLogo());
        m.setIcon(db.getIcon());
        m.setSlideshowImage(db.getSlideshowImage());
        m.setName(db.getName());
        m.setType(db.getType());
        m.setStartAt(db.getStartAt());
        m.setEndAt(db.getEndAt());
        m.setTimeZone(db.getTimeZone());
        m.setLocation(db.getLocation());
        m.setMemberWorkflow(this._entityConfig.getEntityMemberWorkflow(db.getType()));
        m.setApp(this.getAppForEntityType(db.getType()));
        m.setTenantId(db.getTenantId());
    }

    @Nonnull
    private ImmutableSet<Action> getCommonEntityAndActions() {
        return ImmutableSet.builder().add((Object[])new Action[]{StaticEntityAction.ENTITY_JOIN, StaticEntityAction.ENTITY_JOIN_REQUEST, StaticEntityAction.ENTITY_REMOVE_JOIN_REQUEST, StaticEntityAction.ENTITY_LEAVE, StaticEntityAction.ENTITY_INVITE, StaticEntityAction.ENTITY_ACCEPT_INVITE, StaticEntityAction.ENTITY_RECOMMEND, StaticEntityAction.ENTITY_RECOMMEND_AS_TASK, StaticEntityAction.EVENT_ATTEND, StaticEntityAction.EVENT_DONT_ATTEND, StaticEntityAction.EVENT_MAYBE_ATTEND, StaticEntityAction.EVENT_INVITE}).build();
    }

    @Nonnull
    private ImmutableSet<Action> getClientCheckEntityActions() {
        return ImmutableSet.builder().add((Object[])new Action[]{StaticEntityAction.ENTITY_READ_DETAILS, StaticEntityAction.ENTITY_MODIFY, StaticEntityAction.ENTITY_MODIFY_TITLE, StaticEntityAction.ENTITY_DELETE, StaticEntityAction.ENTITY_SEND_NEWSLETTER, StaticEntityAction.ENTITY_SEND_FEEDBACK, StaticAction.COMMENT_CREATE, StaticEntityAction.ENTITY_ENABLE_COMPONENTS, StaticEntityAction.ENTITY_MOVE_COMPONENTS, StaticEntityAction.ENTITY_VERSION_EDIT_DRAFT, StaticEntityAction.ENTITY_VERSION_REVIEW, StaticEntityAction.ENTITY_SELECT_HTML_CONTENT, StaticEntityAction.ENTITY_MODIFY_TAB_SETTINGS}).addAll(this.getCommonEntityAndActions()).addAll(Actions.createEntityTypeBasedAction(DynamicActionCreator.ENTITY_SELECT_PARENT, this._entityConfig.getOrderedEntityTypes())).addAll(Actions.createEntityTypeBasedAction(DynamicActionCreator.ENTITY_MODIFY_PARENT, this._entityConfig.getOrderedEntityTypes())).addAll(Actions.createTabNameBasedAction(DynamicActionCreator.ENTITY_MODIFY_TAB)).build();
    }

    @Nonnull
    private ImmutableSet<Action> getEntityBadgeActions() {
        return ImmutableSet.builder().add((Object[])new Action[]{StaticEntityAction.ENTITY_MAKE_ADMIN, StaticEntityAction.ENTITY_MAKE_COADMIN}).addAll(this.getCommonEntityAndActions()).build();
    }

    @Override
    public ImmutableMap<EntityId, EntityInfo> createInfos(Iterable<DBEntity> entities, AuthorizationCheckContextWithLocale authorizationContext) {
        if (CollectionUtil.isEmpty(entities)) {
            return ImmutableMap.of();
        }
        ImmutableSetMultimap may = authorizationContext.mayByIds(Iterables.transform(entities, Identifiables.toId()), ImmutableSet.of((Object)StaticEntityAction.ENTITY_READ_DETAILS));
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (DBEntity entity : entities) {
            EntityInfo entityInfo;
            EntityId entityId = entity.getId();
            if (may.get((Object)Optional.of((Object)entityId)).contains((Object)StaticEntityAction.ENTITY_READ_DETAILS)) {
                EntityInfoBean eib = new EntityInfoBean();
                this.copyDBToInfo(entity, eib);
                entityInfo = eib;
            } else {
                entityInfo = this.createPlaceholder(entity, authorizationContext);
            }
            result.put((Object)entityId, (Object)entityInfo);
        }
        return result.build();
    }

    public ImmutableMap<EntityId, EntityBadge> createBadges(Iterable<DBEntity> entities, Map<EntityId, EntityInfo> parentsAsTeaser, AuthorizationCheckContextWithUserId authorizationContext) {
        ImmutableSet versionedEntities = FluentIterable.from(entities).filter((Predicate)new Predicate<DBEntity>(){

            public boolean apply(DBEntity input) {
                return input != null && EntityServiceImpl.this._entityConfig.releaseProcessMandatory(input.getType());
            }
        }).toSet();
        ImmutableMap versionedEntitiesMap = Maps.uniqueIndex((Iterable)versionedEntities, DBEntity.TO_ENTITY_ID);
        ImmutableMap versions = ImmutableMap.copyOf((Map)Maps.transformValues(this._entityVersionService.getCurrentEntityVersions((Set<EntityId>)versionedEntitiesMap.keySet(), authorizationContext), (Function)new Function<EntityVersion, EntityVersionClientModel>(){

            public EntityVersionClientModel apply(EntityVersion input) {
                return new EntityVersionClientModel(input);
            }
        }));
        ImmutableMap publicVersions = ImmutableMap.copyOf((Map)Maps.transformValues(this._entityVersionService.getPublicVersions((ImmutableSet<EntityId>)versionedEntitiesMap.keySet(), authorizationContext), (Function)new Function<EntityVersion, EntityVersionClientModel>(){

            public EntityVersionClientModel apply(EntityVersion input) {
                return new EntityVersionClientModel(input);
            }
        }));
        ImmutableMap.Builder result = ImmutableMap.builder();
        ImmutableSetMultimap allowedActions = authorizationContext.may(Iterables.transform(entities, EntityItem.FROM_DBENTITY), ImmutableSet.of((Object)StaticEntityAction.ENTITY_READ_DETAILS));
        for (DBEntity entity : entities) {
            EntityBadge badge;
            EntityId entityId = entity.getId();
            if (allowedActions.get((Object)Optional.of((Object)entityId)).contains((Object)StaticEntityAction.ENTITY_READ_DETAILS)) {
                EntityBadgeBean ebb = new EntityBadgeBean();
                this.initialiseBadge(entity, ebb, parentsAsTeaser, (EntityVersionClientModel)versions.get((Object)entityId), (EntityVersionClientModel)publicVersions.get((Object)entityId), authorizationContext);
                badge = ebb;
            } else {
                badge = this.createPlaceholder(entity, authorizationContext);
            }
            result.put((Object)entity.getId(), (Object)badge);
        }
        return result.build();
    }

    private void initialiseBadge(@Nonnull DBEntity dbBean, @Nonnull EntityBadgeSetters badge, @Nullable Map<EntityId, EntityInfo> parentsAsTeaser, @Nullable EntityVersionClientModel currentVersion, @Nullable EntityVersionClientModel lastPublicVersion, @Nonnull AuthorizationCheckContextWithUserId authorizationContext) {
        this.copyDBToBadge(dbBean, badge, currentVersion, lastPublicVersion, true, authorizationContext);
        if (dbBean.getLinkedEntities() != null && parentsAsTeaser != null) {
            badge.setLinkedEntities((ImmutableList<EntityInfo>)FluentIterable.from(dbBean.getLinkedEntityIds()).transform(Functions.forMap(parentsAsTeaser, null)).toList());
        }
    }

    @Override
    public ImmutableMap<EntityId, MyMemberStatus> getMyMemberStatus(AuthorizationContextWithUserId authContext, Map<EntityId, DBEntity> entities) {
        PersonId userId = authContext.getUserId();
        final Map<EntityId, EntityMemberWithEntityType> memberships = this._entityMemberService.getMemberByPersonIdAndEntityIds(userId, entities.keySet());
        return ImmutableMap.copyOf((Map)Maps.transformValues(entities, (Function)new NullPermeableFunction<DBEntity, MyMemberStatus>(){

            @Override
            protected MyMemberStatus applySafe(DBEntity input) {
                EntityMemberWithEntityType member = (EntityMemberWithEntityType)memberships.get(input.getId());
                return new MyMemberStatus(member != null ? member.getRoles() : ImmutableSet.of(), EntityServiceImpl.this.isEntityClosed(input));
            }
        }));
    }

    @Override
    public ImmutableListMultimap<EntityId, DBPrivacySelection> getPrivacySelectedAuthoritiesFromDB(Set<EntityId> entityIds) {
        return this._entityDataService.getPrivacySelectedAuthorities(entityIds);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void handleEntityVersionEvent(@Nonnull EntityVersionUpdateEvent updateEvent) {
        EntityId entityId = updateEvent.getVersion().getEntityId();
        this._updateHandler.onChange(new EntityUpdateEvent(entityId));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void handleEntityVersionEvent(@Nonnull EntityVersionReleaseEvent releaseEvent) {
        this.updateEntityModifyDate(releaseEvent.getVersion().getEntityId(), false);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void handleEntityVersionDeleteEvent(@Nonnull EntityVersionDeletedEvent deleteEvent) {
        EntityId entityId = deleteEvent.getEntityId();
        this._updateHandler.onChange(new EntityUpdateEvent(entityId));
    }

    @Override
    public ImmutableList<EntityInfo> getParentsEntityInfosSortedByName(EntityId id, boolean includeStartPointInResult, boolean noDuplicates, EntityService.SearchDepth searchDepth, AuthorizationCheckContextWithLocale authorizationContext) {
        Iterator<ObjectWithDepth<DBEntity>> parents = this.getAllParents(id, includeStartPointInResult, noDuplicates, searchDepth);
        ImmutableList entities = ImmutableList.copyOf((Iterator)Iterators.filter((Iterator)Iterators.transform(parents, ObjectWithDepth.getObjectFunction()), (Predicate)Predicates.notNull()));
        ImmutableMap<EntityId, EntityInfo> entityInfos = this.createInfos((Iterable<DBEntity>)entities, authorizationContext);
        return Ordering.from(EntityInfo.NAME_COMPARATOR).immutableSortedCopy((Iterable)entityInfos.values());
    }

    @Nonnull
    private ImmutableSet<Action> getActionsFor(@Nonnull VisibleActionSet actionEnv) {
        switch (actionEnv) {
            case OPTIONS_MODULE: {
                return this.getClientCheckEntityActions();
            }
            case SEARCH_BADGES: {
                return this.getEntityBadgeActions();
            }
        }
        return ImmutableSet.of();
    }

    @Override
    public ImmutableSetMultimap<EntityId, Action> getAllowedEntityActions(Set<EntityId> entities, VisibleActionSet actionEnv, Map<? extends ItemId, SubscriptionStatus> subscriptions, AuthorizationCheckContextWithUserId auth) {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        ImmutableSetMultimap<Optional<EntityId>, Action> may = auth.mayByIds(entities, this.getActionsFor(actionEnv));
        ImmutableSet<EntityId> mayArchive = this._entityVersionService.mayArchiveEntities(entities, auth);
        for (EntityId id : entities) {
            result.putAll((Object)id, (Iterable)may.get((Object)Optional.of((Object)id)));
            SubscriptionStatus subscriptionStatus = subscriptions.get(id);
            if (subscriptionStatus.maySubscribe()) {
                result.put((Object)id, (Object)StaticItemAction.LIKE_SUBSCRIBE);
            }
            if (subscriptionStatus.mayUnsubscribe()) {
                result.put((Object)id, (Object)StaticItemAction.UNLIKE_UNSUBSCRIBE);
            }
            if (!mayArchive.contains((Object)id)) continue;
            result.put((Object)id, (Object)StaticEntityAction.ENTITY_ARCHIVE);
        }
        return result.build();
    }

    @Override
    public ImmutableSetMultimap<EntityId, Action> getAllowedEntityActions(Set<EntityId> entities, VisibleActionSet actionEnv, AuthorizationCheckContextWithUserId auth) {
        ImmutableMap<ItemId, SubscriptionStatus> subscriptions = this._likeService.getExplicitSubscriptionStatus(entities, auth);
        return this.getAllowedEntityActions(entities, actionEnv, (Map<? extends ItemId, SubscriptionStatus>)subscriptions, auth);
    }

    @Override
    public MenuCreateEntityInfo getPageMenuCreateEntityInfo(AuthorizationCheckContext authorizationContext) {
        return this.getMenuCreateEntityInfo(CoreApp.SOCIAL, authorizationContext);
    }

    @Override
    public MenuCreateEntityInfo getNewsMenuCreateEntityInfo(AuthorizationCheckContext authorizationContext) {
        return this.getMenuCreateEntityInfo(CoreApp.NEWS, authorizationContext);
    }

    @Nonnull
    private MenuCreateEntityInfo getMenuCreateEntityInfo(@Nonnull CoreApp app, @Nonnull AuthorizationCheckContext authorizationContext) {
        ImmutableSet<Action> createOnStartpageAllowedActions;
        ImmutableMap startpageCreateActions = Maps.uniqueIndex(this._entityTypeAppMappingService.getEntityTypesForApp(app), Actions::startpageCreateEntity);
        Collection allowedEntityTypesOnStartPage = Maps.filterKeys((Map)startpageCreateActions, (Predicate)Predicates.in(createOnStartpageAllowedActions = authorizationContext.may((ImmutableSet<? extends Action>)startpageCreateActions.keySet()))).values();
        if (allowedEntityTypesOnStartPage.isEmpty()) {
            return new MenuCreateEntityInfo((ImmutableSet<EntityType>)ImmutableSet.of(), null);
        }
        ImmutableMap createActions = Maps.uniqueIndex(allowedEntityTypesOnStartPage, Actions::entityCreate);
        ImmutableSet<Action> createAllowedAction = authorizationContext.may((ImmutableSet<? extends Action>)createActions.keySet());
        ImmutableSet allowedEntityTypes = ImmutableSet.copyOf(Maps.filterKeys((Map)createActions, (Predicate)Predicates.in(createAllowedAction)).values());
        return new MenuCreateEntityInfo((ImmutableSet<EntityType>)allowedEntityTypes, this._settings.getDefaultEntityId());
    }

    @Override
    public EntityInfoTabPrivacySettings getEntityInfoTabPrivacySettings(EntityId entityId, AuthorizationCheckContext authorizationContext) {
        DBEntity entity = this.getByIdNotNull(entityId);
        EntityItem item = new EntityItem(entity);
        authorizationContext.check(item, (Action)StaticEntityAction.ENTITY_READ_DETAILS);
        ImmutableSet workstreamPublicRoles = FluentIterable.from(this._configService.getWorkstreamPublicRoles()).transform(Role.TO_NAME).toSet();
        ImmutableSetMultimap<DBPrivacyType, String> privacySettings = this.getPrivacySelectedAuthorityNames(item, (Set<DBPrivacyType>)ImmutableSet.of((Object)((Object)DBPrivacyType.VISIBILITY), (Object)((Object)DBPrivacyType.JOINING), (Object)((Object)DBPrivacyType.JOIN_REQUEST), (Object)((Object)DBPrivacyType.INVITING)));
        boolean workstreamPublicVisible = !Collections.disjoint(workstreamPublicRoles, privacySettings.get((Object)DBPrivacyType.VISIBILITY));
        ImmutableListMultimap<DBPrivacyType, AuthorityModel> allAvailableRuleAuthNames = this._entityConfig.getAllAvailableRuleAuthNames(entity.getType());
        return new EntityInfoTabPrivacySettings(this.getVisibleRoles((Multimap<DBPrivacyType, AuthorityModel>)allAvailableRuleAuthNames, (SetMultimap<DBPrivacyType, String>)privacySettings, DBPrivacyType.VISIBILITY), this.getVisibleRoles((Multimap<DBPrivacyType, AuthorityModel>)allAvailableRuleAuthNames, (SetMultimap<DBPrivacyType, String>)privacySettings, DBPrivacyType.JOINING), this.getVisibleRoles((Multimap<DBPrivacyType, AuthorityModel>)allAvailableRuleAuthNames, (SetMultimap<DBPrivacyType, String>)privacySettings, DBPrivacyType.JOIN_REQUEST), this.getVisibleRoles((Multimap<DBPrivacyType, AuthorityModel>)allAvailableRuleAuthNames, (SetMultimap<DBPrivacyType, String>)privacySettings, DBPrivacyType.INVITING), workstreamPublicVisible, !workstreamPublicRoles.isEmpty());
    }

    @Nonnull
    private ImmutableSet<String> getVisibleRoles(@Nonnull Multimap<DBPrivacyType, AuthorityModel> allAvailableRuleAuthNames, @Nonnull SetMultimap<DBPrivacyType, String> privacySettings, @Nonnull DBPrivacyType type) {
        return this.getVisibleRoles(privacySettings.get((Object)type), allAvailableRuleAuthNames.get((Object)type));
    }

    @Nonnull
    private ImmutableSet<String> getVisibleRoles(@Nonnull Set<String> privacySetting, @Nonnull Iterable<? extends AuthorityModel> availableRuleAuthNames) {
        return FluentIterable.from(availableRuleAuthNames).filter(Predicates.compose((Predicate)Predicates.in(privacySetting), AuthorityModel.TO_NAME)).filter(AuthorityModel.IS_VISIBLE).transform(AuthorityModel.TO_NAME).toSet();
    }

    @Override
    public ImmutableSet<String> getPrivacySettings(EntityId entityId, DBPrivacyType type, AuthorizationCheckContext authCtx) {
        DBEntity entity = InvalidIdServiceException.check(this.getById(entityId));
        EntityItem entityItem = new EntityItem(entity);
        authCtx.check(entityItem, (Action)StaticEntityAction.ENTITY_READ_DETAILS);
        ImmutableSet<String> rawRoleNames = this.getPrivacySelectedAuthorityNames(entityItem, type);
        ImmutableList<AuthorityModel> availableRuleAuthNames = this._entityConfig.getAvailableRuleAuthNames(entity.getType(), type);
        return this.getVisibleRoles((Set<String>)rawRoleNames, (Iterable<? extends AuthorityModel>)availableRuleAuthNames);
    }

    @Override
    public void updateLastDriveChangeVersion(EntityId entityId, int newLastDriveChangeVersion) {
        this._entityDataService.updateLastDriveChangeVersion(entityId, newLastDriveChangeVersion);
    }

    @Override
    public boolean areLinkedEntitiesEqual(DBEntity e0, DBEntity e1) {
        return com.google.common.base.Objects.equal((Object)FluentIterable.from(e0.getLinkedEntities()).transform(DBEntityLink.CLONE_PARENT_SIDE).filter(Predicates.notNull()).toSet(), (Object)FluentIterable.from(e1.getLinkedEntities()).transform(DBEntityLink.CLONE_PARENT_SIDE).filter(Predicates.notNull()).toSet());
    }

    @Override
    public ImmutableSet<EditEntityHistoryTokenTabName> getVisibleEntityEditTabs(EntityType type, ImmutableSet<Action> tabPermissions, ImmutableMap<EntityType, DBEntityLinkedEntityPrivacy> entityLinkedPrivacy) {
        return new VisibleEntityEditTabPredicate(type, (Set<? extends Action>)tabPermissions, entityLinkedPrivacy).allVisible();
    }

    @Override
    public CoreApp getAppForGlobalId(GlobalId globalId) {
        DBEntity entity = this.getParentEntity(globalId);
        return entity != null ? this.getAppForEntityType(entity.getType()) : CoreApp.ENTITY_DEFAULT;
    }

    @CheckForNull
    private DBEntity getParentEntity(@Nonnull GlobalId globalId) {
        if (globalId instanceof EntityId) {
            return this.getById((EntityId)globalId);
        }
        try {
            return this._itemService.getParentEntity(globalId);
        }
        catch (InvalidIDException e) {
            return null;
        }
    }

    @Override
    public CoreApp getAppForEntityType(EntityType entityType) {
        return this._entityTypeAppMappingService.getAppForEntityType(entityType);
    }

    @Override
    public Set<EntityId> getAllForTenant(TenantId tenantId) {
        return this._entityDAO.getAllForTenant(tenantId);
    }

    @Override
    @CheckForNull
    public String getTenantName(@Nullable TenantId tenantId) {
        if (tenantId == null) {
            return null;
        }
        java.util.Optional<Tenant> tenant = this._tenantService.getTenantById(tenantId);
        return tenant.map(Tenant::getName).orElse(null);
    }

    @Override
    public void allowEntityReadForTenantReaders(Set<EntityId> entityIds, String allowForRole) {
        Map<EntityId, DBEntity> entityMap = this.getByIds(entityIds);
        entityMap.values().forEach(entity -> this.addAuthorityToPrivacyTypeForEntity((DBEntity)entity, DBPrivacyType.VISIBILITY, currentRoles -> !currentRoles.contains(allowForRole), allowForRole));
    }

    @Override
    public void allowEntityEditForRoleIfMemberMayEdit(Set<EntityId> entityIds, String allowForRole) {
        Map<EntityId, DBEntity> entityMap = this.getByIds(entityIds);
        entityMap.values().forEach(entity -> this.addAuthorityToPrivacyTypeForEntity((DBEntity)entity, DBPrivacyType.ENTITY_EDIT, currentRoles -> currentRoles.contains(StaticPredefinedRole.ENTITY_MEMBER.getName()), allowForRole));
    }

    private void addAuthorityToPrivacyTypeForEntity(final DBEntity entity, final DBPrivacyType privacyType, final java.util.function.Predicate<Set<String>> shouldAuthorityAddedToPrivacySettings, final String authorityToAdd) {
        final CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                EntityServiceImpl.this.savePrivacySelectedAuthorities(entity.getId(), new PrivacyModifyCommand(){

                    @Override
                    public ImmutableList<DBPrivacySelection> execute(ImmutableList<DBPrivacySelection> currentSelection) {
                        Set currenAllowedAuthoritiesForType = currentSelection.stream().filter(s -> s.getPrivacyType().equals((Object)privacyType)).map(DBPrivacySelection::getAuthorityName).collect(Collectors.toUnmodifiableSet());
                        if (!shouldAuthorityAddedToPrivacySettings.test(currenAllowedAuthoritiesForType)) {
                            return currentSelection;
                        }
                        ImmutableSet newAuthoritiesForType = ImmutableSet.builder().addAll(currenAllowedAuthoritiesForType).add((Object)authorityToAdd).build();
                        return this.setPrivacySettingsForType(currentSelection, privacyType, (Collection<String>)newAuthoritiesForType, entity.getType());
                    }
                }, (ServerEventCollector)eventCollector);
            }
        });
        eventCollector.fireEvents(this._eventBus);
    }

    @ParametersAreNonnullByDefault
    private class VisibleEntityEditTabPredicate
    implements Predicate<EditEntityHistoryTokenTabName>,
    EditEntityHistoryTokenTabName.Visitor<Boolean> {
        private final Set<? extends Action> _permissions;
        private final ImmutableMap<EntityType, DBEntityLinkedEntityPrivacy> _entityLinkedPrivacy;
        private final EntityType _entityType;

        public VisibleEntityEditTabPredicate(EntityType entityType, Set<? extends Action> permissions, ImmutableMap<EntityType, DBEntityLinkedEntityPrivacy> entityLinkedPrivacy) {
            this._entityType = entityType;
            this._permissions = permissions;
            this._entityLinkedPrivacy = entityLinkedPrivacy;
        }

        public boolean apply(@Nullable EditEntityHistoryTokenTabName input) {
            return input != null && input.accept(this) != false;
        }

        @Override
        public Boolean visitBase() {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visitSettings() {
            return this._permissions.contains(Actions.entityModifyTab(TabNameForConfiguration.SETTINGS));
        }

        @Override
        public Boolean visitMembers() {
            return this._permissions.contains(Actions.entityModifyTab(TabNameForConfiguration.MEMBERS));
        }

        @Override
        public Boolean visitImage() {
            return this._permissions.contains(Actions.entityModifyTab(TabNameForConfiguration.IMAGE)) && (EntityServiceImpl.this._entityConfig.logoActivated(this._entityType) || EntityServiceImpl.this._entityConfig.iconActivated(this._entityType));
        }

        @Override
        public Boolean visitPrivacy() {
            return this._permissions.contains(Actions.entityModifyTab(TabNameForConfiguration.PRIVACY)) && (FluentIterable.from(EntityServiceImpl.this._entityConfig.getAvailableInvitingRuleAuthNames(this._entityType)).append(EntityServiceImpl.this._entityConfig.getAvailableNewsletterRuleAuthNames(this._entityType)).anyMatch(AuthorityModel.IS_VISIBLE) || !this._entityLinkedPrivacy.isEmpty());
        }

        @Nonnull
        public ImmutableSet<EditEntityHistoryTokenTabName> allVisible() {
            return ImmutableSet.copyOf((Iterator)Iterators.filter((Iterator)Iterators.forArray((Object[])EditEntityHistoryTokenTabName.values()), (Predicate)this));
        }
    }

    private abstract class PrivacyModifyCommand
    implements Command<ImmutableList<DBPrivacySelection>> {
        private PrivacyModifyCommand() {
        }

        @Nonnull
        protected ImmutableList<DBPrivacySelection> setPrivacySettingsForType(@Nonnull ImmutableList<DBPrivacySelection> destination, @Nonnull DBPrivacyType type, @Nullable Collection<String> newSetting, @Nonnull EntityType entityType) {
            if (newSetting == null) {
                return destination;
            }
            ImmutableSet<String> privacySettings = EntityServiceImpl.this.joinWithForcedAuthorityNamesForRight(newSetting, entityType, type.getRight());
            ImmutableList.Builder result = ImmutableList.builder();
            for (DBPrivacySelection privacySelection : destination) {
                if (type.equals((Object)privacySelection.getPrivacyType())) continue;
                result.add((Object)privacySelection);
            }
            result.addAll(EntityServiceImpl.this.createPrivacySelection(privacySettings, type));
            return result.build();
        }

        @Nonnull
        protected ImmutableList<DBPrivacySelection> setPrivacySettingsForType(@Nonnull ImmutableList<DBPrivacySelection> origin, @Nonnull Map<DBPrivacyType, Collection<String>> newSettings, @Nonnull EntityType entityType) {
            if (newSettings.isEmpty()) {
                return origin;
            }
            ImmutableList<DBPrivacySelection> result = origin;
            for (Map.Entry<DBPrivacyType, Collection<String>> entry : newSettings.entrySet()) {
                result = this.setPrivacySettingsForType(result, entry.getKey(), entry.getValue(), entityType);
            }
            return result;
        }
    }

    @ParametersAreNonnullByDefault
    private class BadgeModelToEntityInfoVisitor
    implements SearchResultBadgeVisitor<EntityInfo> {
        private BadgeModelToEntityInfoVisitor() {
        }

        @Override
        public EntityInfo visitPerson(PersonSearchResultBadgeModel person) {
            return null;
        }

        @Override
        public EntityInfo visitEntity(EntitySearchResultBadgeModel entity) {
            return entity;
        }

        @Override
        public EntityInfo visitWorkstream(WorkstreamSearchResultBadgeModel workstream) {
            return null;
        }

        @Override
        public EntityInfo visitNewsPost(NewsPostSearchResultBadgeModel workstream) {
            return null;
        }

        @Override
        public EntityInfo visitNewsChannel(NewsChannelSearchResultBadgeModel model) {
            return null;
        }

        @Override
        public EntityInfo visitConversation(ConversationSearchResultBadgeModel conversation) {
            return null;
        }

        @Override
        public EntityInfo visitChat(ChatSearchResultBadgeModel chat) {
            return null;
        }

        @Override
        public EntityInfo visitDriveDocument(DriveDocumentSearchResultBadgeModel driveDocument) {
            return null;
        }

        @Override
        public EntityInfo visitWiki(WikiSearchResultBadgeModel wiki) {
            return null;
        }

        @Override
        public EntityInfo visitChapter(ChapterSearchResultBadgeModel chapter) {
            return null;
        }

        @Override
        public EntityInfo visitArticle(ArticleSearchResultBadgeModel article) {
            return null;
        }
    }

    private static class SearchIterator
    implements Iterator<ObjectWithDepth<DBEntity>> {
        private ObjectWithDepth<DBEntity> _nextResult = null;
        private final Queue<ObjectWithDepth<DBEntity>> _queue = Lists.newLinkedList();
        private final List<ObjectWithDepth<EntityId>> _idList = Lists.newLinkedList();
        private final Set<EntityId> _visitedIds = Sets.newHashSet();
        private final EntityService.SearchPredicates _pred;
        private final EntityService _entityService;
        private final boolean _skipDuplicates;

        SearchIterator(Collection<EntityId> starts, EntityService.SearchPredicates pred, EntityService entityService, boolean skipDuplicates) {
            this._pred = pred;
            for (EntityId s : starts) {
                this._idList.add(new ObjectWithDepth<EntityId>(s, 0, null));
            }
            this._visitedIds.addAll(starts);
            this._entityService = entityService;
            this._skipDuplicates = skipDuplicates;
        }

        private void fillQueue() {
            ImmutableSet.Builder ids = ImmutableSet.builder();
            for (ObjectWithDepth<EntityId> dId : this._idList) {
                ids.add((Object)dId.getObject());
            }
            Map<EntityId, DBEntity> entities = this._entityService.getByIds((Set<EntityId>)ids.build());
            for (ObjectWithDepth<EntityId> dId : this._idList) {
                DBEntity entity = entities.get(dId.getObject());
                if (entity == null) continue;
                this._queue.add(new ObjectWithDepth<DBEntity>(entity, dId.getDepth(), dId.getChildEntityId()));
            }
            this._idList.clear();
        }

        private ObjectWithDepth<DBEntity> nextFromQueue() {
            ObjectWithDepth<DBEntity> e = this._queue.poll();
            if (e == null) {
                this.fillQueue();
                return this._queue.poll();
            }
            return e;
        }

        private void fillNextResult() {
            ObjectWithDepth<DBEntity> e = null;
            do {
                if ((e = this.nextFromQueue()) == null || !this._pred.expand(e.getObject(), e.getDepth(), e.getChildEntityId())) continue;
                for (DBEntityLink l : e.getObject().getLinkedEntities()) {
                    if (this._skipDuplicates && this._visitedIds.contains(l.getLinkedEntityId())) continue;
                    this._idList.add(new ObjectWithDepth<EntityId>(l.getLinkedEntityId(), e.getDepth() + 1, e.getObject().getId()));
                    this._visitedIds.add(l.getLinkedEntityId());
                }
            } while (e != null && !this._pred.isResult(e.getObject(), e.getDepth(), e.getChildEntityId()));
            this._nextResult = e;
        }

        private ObjectWithDepth<DBEntity> peekNext() {
            if (this._nextResult == null) {
                this.fillNextResult();
            }
            return this._nextResult;
        }

        @Override
        public boolean hasNext() {
            return this.peekNext() != null;
        }

        @Override
        public ObjectWithDepth<DBEntity> next() {
            ObjectWithDepth<DBEntity> e = this.peekNext();
            this._nextResult = null;
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not implemented");
        }
    }

    private static interface CheckInheritsHandler {
        public boolean check(@Nonnull DBEntityLink var1, @Nonnull DBEntity var2, @Nonnull DBEntity var3);
    }

    private class ParentSearchPredicates
    implements EntityService.SearchPredicates {
        private final Map<EntityId, DBEntity> _entities = new HashMap<EntityId, DBEntity>();
        private final boolean _includeStartPointInResult;
        private final EntityService.SearchDepth _searchDepth;
        private final EntityId _id;

        public ParentSearchPredicates(@Nonnull EntityId id, EntityService.SearchDepth searchDepth, boolean includeStartPointInResult) {
            this._includeStartPointInResult = includeStartPointInResult;
            this._searchDepth = searchDepth;
            this._id = id;
        }

        @Override
        public boolean expand(DBEntity e, int depth, EntityId childBefore) {
            switch (this._searchDepth) {
                case DIRECT_AND_INDIRECT_ADMIN_PARENTS: {
                    return this.checkInheritsAdminMemberExpand(e, childBefore, new CheckInheritsHandler(){

                        @Override
                        public boolean check(DBEntityLink entityLink, DBEntity parentEnttiy, DBEntity childEntity) {
                            return entityLink.isInheritsAdmins() && EntityServiceImpl.this._entityConfig.inheritsAdminEnabled(parentEnttiy.getType(), childEntity.getType());
                        }
                    });
                }
                case DIRECT_AND_INDIRECT_MEMBER_PARENTS: {
                    return this.checkInheritsAdminMemberExpand(e, childBefore, new CheckInheritsHandler(){

                        @Override
                        public boolean check(DBEntityLink entityLink, DBEntity parentEnttiy, DBEntity childEntity) {
                            return entityLink.isInheritsMembers() && EntityServiceImpl.this._entityConfig.inheritsMemberEnabled(parentEnttiy.getType(), childEntity.getType());
                        }
                    });
                }
            }
            return true;
        }

        private boolean checkInheritsAdminMemberExpand(@Nonnull DBEntity parentEntity, @Nullable EntityId childEntityId, @Nonnull CheckInheritsHandler handler) {
            this._entities.put(parentEntity.getId(), parentEntity);
            DBEntity childEntity = this._entities.get(childEntityId);
            if (childEntity == null) {
                return true;
            }
            for (DBEntityLink l : childEntity.getLinkedEntities()) {
                if (!l.getLinkedEntityId().equals(parentEntity.getId())) continue;
                return handler.check(l, parentEntity, childEntity);
            }
            return false;
        }

        @Override
        public boolean isResult(DBEntity e, int depth, EntityId childBefore) {
            if (!this._includeStartPointInResult && this._id.equals(e.getId())) {
                return false;
            }
            return this.expand(e, depth, childBefore);
        }
    }

    private class EntityCompontenConfigCache
    extends ValueOfMap<EntityType, ImmutableMap<ComponentType, EntityTypeAllowedComponent>> {
        private EntityCompontenConfigCache() {
        }

        @Override
        protected ImmutableMap<ComponentType, EntityTypeAllowedComponent> create(EntityType key) {
            return EntityServiceImpl.this.getEntityComponentConfig(key);
        }
    }

    static interface AssignmentErrorCollector {
        public static final AssignmentErrorCollector NOTHING = new AssignmentErrorCollector(){

            @Override
            public void addElementDoesNotExist(EntityId parentEntityId) {
            }

            @Override
            public void addAssignedTypeNotAllowed(DBEntity parentEntity, EntityType childType) {
            }

            @Override
            public void addInvalidEntitySelectionOccur(DBEntity parentEntity, EntityType childType) {
            }
        };

        public void addElementDoesNotExist(@Nonnull EntityId var1);

        public void addAssignedTypeNotAllowed(@Nonnull DBEntity var1, @Nonnull EntityType var2);

        public void addInvalidEntitySelectionOccur(@Nonnull DBEntity var1, @Nonnull EntityType var2);
    }

    private static final class ParentInheritanceChanges {
        private final boolean _parentsChanged;
        private final boolean _adminInheritanceChanged;
        private final boolean _memberInheritanceChanged;

        private ParentInheritanceChanges(boolean parentsChanged, boolean adminInheritanceChanged, boolean memberInheritanceChanged) {
            this._parentsChanged = parentsChanged;
            this._adminInheritanceChanged = adminInheritanceChanged;
            this._memberInheritanceChanged = memberInheritanceChanged;
        }
    }
}

