/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContextWithUserId;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.business.EntityRecommendationReadWriteDataService;
import de.justsoftware.onx.container.business.EntityRecommendationService;
import de.justsoftware.onx.container.business.events.EntityRecommendationUpdateEvent;
import de.justsoftware.onx.container.business.events.NewEntityRecommendationEvent;
import de.justsoftware.onx.container.server.shared.model.EntityRecommendation;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.InvitationResultKey;
import de.justsoftware.onx.container.shared.model.ItemId;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@Service
public class EntityRecommendationServiceImpl
implements EntityRecommendationService {
    static final Logger LOG = LoggerFactory.getLogger(EntityRecommendationServiceImpl.class);
    private final TransactionHelper _transactionHelper;
    private final EntityRecommendationReadWriteDataService _entityRecommendationReadWriteDataService;
    private final EntityConfigService _entityConfigService;
    private final JCEventBus _eventBus;

    @Autowired
    @ParametersAreNonnullByDefault
    public EntityRecommendationServiceImpl(EntityRecommendationReadWriteDataService entityRecommendationReadWriteDataService, TransactionHelper transactionHelper, EntityConfigService entityConfigService, JCEventBus eventBus) {
        this._entityRecommendationReadWriteDataService = entityRecommendationReadWriteDataService;
        this._transactionHelper = transactionHelper;
        this._entityConfigService = entityConfigService;
        this._eventBus = eventBus;
    }

    @Override
    public ImmutableMultiset<InvitationResultKey> recommendEntityToPersons(final EntityId entityId, Set<PersonId> personIds, AuthorizationCheckContextWithUserId recommenderAuthCtx, final String recommendationMessage, Set<ComponentType> selectedComponentTypes) {
        if (Iterables.isEmpty(personIds)) {
            return ImmutableMultiset.of();
        }
        final PersonId recommender = recommenderAuthCtx.getUserId();
        boolean may = recommenderAuthCtx.may((ItemId)entityId, (Action)StaticEntityAction.ENTITY_SELECT_HTML_CONTENT);
        if (!CollectionUtil.isEmpty(selectedComponentTypes) && !may) {
            throw new ServiceException("Invalid recommendation: user " + recommender + " is not allowed to select HTML content from entity " + entityId);
        }
        ImmutableSet<PersonId> personsWithExistingRecommendation = this._entityRecommendationReadWriteDataService.getPersonsWithRecommendationForEntity(entityId);
        Sets.SetView personsToSkip = Sets.intersection(personsWithExistingRecommendation, personIds);
        final Sets.SetView referees = Sets.difference(personIds, personsWithExistingRecommendation);
        ImmutableMultiset.Builder result = ImmutableMultiset.builder();
        result.setCount((Object)InvitationResultKey.ALREADY_RECOMMENDED, personsToSkip.size());
        result.setCount((Object)InvitationResultKey.RECOMMENDED, referees.size());
        this._transactionHelper.doInTransaction(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus ts) {
                for (PersonId personId : referees) {
                    EntityRecommendationServiceImpl.this._entityRecommendationReadWriteDataService.persistRecommendation(entityId, personId, recommender, recommendationMessage);
                }
            }
        });
        for (PersonId personId : referees) {
            this._eventBus.post(new NewEntityRecommendationEvent(recommender, personId, entityId, recommendationMessage));
        }
        return result.build();
    }

    @Override
    public void removeRecommendation(EntityId entityId, AuthorizationContextWithUserId authorizationContext) {
        PersonId currentUser = authorizationContext.getUserId();
        this._entityRecommendationReadWriteDataService.removeRecommendation(entityId, currentUser);
        this._eventBus.post(new EntityRecommendationUpdateEvent(currentUser, entityId));
    }

    @Override
    public ImmutableMap<EntityId, EntityRecommendation> getRecommendationsForUser(AuthorizationCheckContextWithUserId authorizationContext) {
        PersonId currentUserId = authorizationContext.getUserId();
        ImmutableList<EntityRecommendation> recommendatons = this._entityRecommendationReadWriteDataService.getEntityRecommendationsForUser(currentUserId, this._entityConfigService.getOrderedEntityTypes());
        return Maps.uniqueIndex(recommendatons, (Function)new Function<EntityRecommendation, EntityId>(){

            public EntityId apply(EntityRecommendation from) {
                return from.getEntityId();
            }
        });
    }
}

