/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.business.EntityRecommendationReadWriteDataService;
import de.justsoftware.onx.container.integration.persistence.EntityRecommendationDAO;
import de.justsoftware.onx.container.server.shared.model.EntityRecommendation;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EntityRecommendationReadWriteDataServiceImpl
implements EntityRecommendationReadWriteDataService {
    private final EntityRecommendationDAO _recommendationDao;

    @Autowired
    public EntityRecommendationReadWriteDataServiceImpl(@Nonnull EntityRecommendationDAO recommendationDao) {
        this._recommendationDao = recommendationDao;
    }

    @CheckForNull
    private EntityRecommendation getRecommendationById(@Nonnull EntityId entityId, @Nonnull PersonId personId) {
        return this._recommendationDao.getRecommendationById(entityId, personId);
    }

    @Override
    public void persistRecommendation(EntityId entityId, PersonId personId, PersonId recommenderId, String recommendationMessage) {
        if (this.getRecommendationById(entityId, personId) != null) {
            this._recommendationDao.updateRecommendation(entityId, personId, recommenderId, recommendationMessage);
        } else {
            this._recommendationDao.insertRecommendation(entityId, personId, recommenderId, recommendationMessage);
        }
    }

    @Override
    public void removeRecommendation(EntityId entityId, PersonId personId) {
        this._recommendationDao.deleteRecommendation(entityId, personId);
    }

    @Override
    public ImmutableSet<PersonId> getPersonsWithRecommendationForEntity(EntityId entityId) {
        return this._recommendationDao.getPersonsWithRecommendationForEntity(entityId);
    }

    @Override
    public void removeRecommendationsByPersonIds(Set<PersonId> personIds) {
        this._recommendationDao.deleteRecommendationsByPersonIds(personIds);
    }

    @Override
    public void removeRecommendationsByEntityIds(Set<EntityId> entityIds) {
        this._recommendationDao.deleteRecommendationsByEntityIds(entityIds);
    }

    @Override
    public ImmutableList<EntityRecommendation> getEntityRecommendationsForUser(PersonId personId, ImmutableSet<EntityType> entityTypes) {
        return this._recommendationDao.getRecommendationsForUser(personId, entityTypes);
    }
}

