/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.freiheit.toro.cache.CacheClient;
import com.freiheit.toro.cache.CacheKey;
import com.freiheit.toro.cache.CacheName;
import com.freiheit.toro.cache.memcached.MemcachedClientCache;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import de.justsoftware.onx.common.business.CacheHelper;
import de.justsoftware.onx.common.cache.AbstractListMultiMapCacheAccessor;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.business.EntityReadWriteDataService;
import de.justsoftware.onx.container.integration.persistence.EntityDAO;
import de.justsoftware.onx.container.server.model.DBPrivacySelection;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.db.DBEntityComponent;
import de.justsoftware.onx.container.shared.model.db.DBEntityLinkedEntityPrivacy;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EntityReadWriteDataServiceImpl
implements EntityReadWriteDataService {
    private static final Function<EntityId, CacheKey> TO_ENTITY_ID_CACHE_KEY = new NullPermeableFunction<EntityId, CacheKey>(){

        @Override
        protected CacheKey applySafe(EntityId id) {
            return new CacheKey((CacheName)EntityServiceCacheName.ENTITY_PREFIX, id);
        }
    };
    private final EntityDAO _entityDAO;
    @Autowired
    private CacheHelper _cacheHelper;
    private final EntitySelectedPrivacyCacheAccessor _entitySelectedPrivacyCacheAccessor;
    private final EntityLinkedEntityPrivacyCacheAccessor _entityLinkedEntityPrivacyCacheAccessor;

    @Autowired
    @ParametersAreNonnullByDefault
    public EntityReadWriteDataServiceImpl(MemcachedClientCache memcachedClientCache, EntityDAO entityDAO) {
        this._entityDAO = entityDAO;
        this._entitySelectedPrivacyCacheAccessor = new EntitySelectedPrivacyCacheAccessor(memcachedClientCache, entityDAO);
        this._entityLinkedEntityPrivacyCacheAccessor = new EntityLinkedEntityPrivacyCacheAccessor(memcachedClientCache, entityDAO);
    }

    @Nonnull
    private static CacheKey createEntityByIdCacheKey(@Nonnull EntityId id) {
        return new CacheKey((CacheName)EntityServiceCacheName.ENTITY_PREFIX, id);
    }

    @Override
    public void deleteEntityCache(Set<EntityId> entityIds) {
        this._cacheHelper.delete((ImmutableSet<CacheKey>)FluentIterable.from(entityIds).transform(TO_ENTITY_ID_CACHE_KEY).toSet());
        this._entitySelectedPrivacyCacheAccessor.invalidateKeysAndWait(entityIds);
        this._entityLinkedEntityPrivacyCacheAccessor.invalidateKeysAndWait(entityIds);
    }

    @Override
    public void deleteEntity(EntityId id) {
        this.deleteEntities(Set.of(id));
    }

    @Override
    public void deleteEntities(Set<EntityId> ids) {
        this._entityDAO.deleteEntities(ids);
        this.deleteEntityCache(ids);
    }

    @Override
    public void saveEntityPrivacies(EntityId id, List<DBPrivacySelection> authorities) {
        this._entityDAO.saveEntityPrivacies(id, authorities);
        this._entitySelectedPrivacyCacheAccessor.invalidateKeyAndWait(id);
    }

    @Override
    public ImmutableListMultimap<EntityId, DBPrivacySelection> getPrivacySelectedAuthorities(Set<EntityId> entityIds) {
        return (ImmutableListMultimap)this._entitySelectedPrivacyCacheAccessor.getMultiMap(entityIds);
    }

    @Override
    public ImmutableListMultimap<EntityId, DBEntityLinkedEntityPrivacy> getEntityLinkedEntityPrivacyByIds(Set<EntityId> entityIds) {
        return (ImmutableListMultimap)this._entityLinkedEntityPrivacyCacheAccessor.getMultiMap(entityIds);
    }

    @Override
    public void updateEntity(DBEntity toSave) {
        this._entityDAO.updateEntity(toSave);
        this.deleteEntityCache((Set<EntityId>)ImmutableSet.of((Object)toSave.getId()));
    }

    @Override
    public Map<EntityId, DBEntity> getByIds(Set<EntityId> entityIds, final Function<Collection<DBEntity>, Map<EntityId, DBEntity>> applyConfig) {
        return this._cacheHelper.getByIdsMap(entityIds, new CacheHelper.GetByIdsInterface<EntityId, DBEntity>(){

            @Override
            public CacheKey cacheKey(EntityId id) {
                return EntityReadWriteDataServiceImpl.createEntityByIdCacheKey(id);
            }

            @Override
            public Map<EntityId, DBEntity> ibatisGetByIds(Set<EntityId> ids) {
                ImmutableCollection fromDAO = EntityReadWriteDataServiceImpl.this._entityDAO.getEntitiesByIds((Set<EntityId>)ImmutableSet.copyOf(ids)).values();
                return (Map)applyConfig.apply((Object)fromDAO);
            }
        });
    }

    @Override
    public void saveEntityLinkedEntityPrivacy(EntityId entityId, List<DBEntityLinkedEntityPrivacy> privacyData) {
        this._entityDAO.saveEntityLinkedEntityPrivacy(entityId, privacyData);
        this.deleteEntityCache((Set<EntityId>)ImmutableSet.of((Object)entityId));
    }

    @Override
    public ImmutableSetMultimap<EntityType, EntityId> getIdsByTypes(Iterable<EntityType> types) {
        return this._entityDAO.getIdsByTypes(types);
    }

    @Override
    public void updateEntityModifyDate(EntityId entityId, DateTime newModifyDate) {
        this._entityDAO.updateEntityModifyDate(entityId, newModifyDate);
        this.deleteEntityCache((Set<EntityId>)ImmutableSet.of((Object)entityId));
    }

    @Override
    public void updateEntityDescription(EntityId entityId, String description, DateTime modifyDate) {
        this._entityDAO.updateEntityDescription(entityId, description, modifyDate);
        this.deleteEntityCache((Set<EntityId>)ImmutableSet.of((Object)entityId));
    }

    @Override
    public void updateComponentPosition(DBEntityComponent dbc) {
        this._entityDAO.updateComponentPosition(dbc);
    }

    @Override
    public void assignEntities(Set<EntityId> entityIds, PersonId assignee, DateTime modifyDate) {
        if (assignee != null) {
            this._entityDAO.assignEntities(entityIds, assignee, modifyDate);
        } else {
            this._entityDAO.unassignEntities(entityIds, modifyDate);
        }
        this.deleteEntityCache(entityIds);
    }

    @Override
    public void assignEntity(EntityId entityId, PersonId assignee, DateTime modifyDate) {
        this.assignEntities((Set<EntityId>)ImmutableSet.of((Object)entityId), assignee, modifyDate);
    }

    @Override
    public void setDefaultNavigation(EntityId entityId, boolean defaultNavigation, DateTime modifyDate) {
        this._entityDAO.setDefaultNavigation(entityId, defaultNavigation, modifyDate);
        this.deleteEntityCache((Set<EntityId>)ImmutableSet.of((Object)entityId));
    }

    @Override
    public void updateLastDriveChangeVersion(EntityId entityId, int newLastDriveChangeVersion) {
        this._entityDAO.updateLastDriveChangeVersion(entityId, newLastDriveChangeVersion);
        this.deleteEntityCache((Set<EntityId>)ImmutableSet.of((Object)entityId));
    }

    @Override
    public ImmutableMap<EntityId, Optional<Integer>> getLastDriveChangeVersions(Set<EntityId> entityIds) {
        return ImmutableMap.copyOf((Map)Maps.transformValues(this._entityDAO.getEntitiesByIds(entityIds), dbEntity -> Optional.fromNullable((Object)dbEntity.getLastDriveChange())));
    }

    private static enum EntityServiceCacheName implements CacheName
    {
        ENTITY_PREFIX("Entity"),
        ENTITY_LINKED_ENTITY_PRIVACY("LinkedEntityPrivacy"),
        ENTITY_SELECTED_PRIVACY("EntitySelectedPrivacy");

        private final String _cacheName;

        private EntityServiceCacheName(String cacheName) {
            this._cacheName = cacheName;
        }

        @Override
        public String getCacheName() {
            return this._cacheName;
        }
    }

    private static final class EntityLinkedEntityPrivacyCacheAccessor
    extends AbstractListMultiMapCacheAccessor<EntityServiceCacheName, EntityId, DBEntityLinkedEntityPrivacy> {
        private final EntityDAO _entityDAO;

        private EntityLinkedEntityPrivacyCacheAccessor(@Nonnull CacheClient<? super EntityServiceCacheName> cache, @Nonnull EntityDAO entityDAO) {
            super(cache, EntityServiceCacheName.ENTITY_LINKED_ENTITY_PRIVACY);
            this._entityDAO = entityDAO;
        }

        @Override
        protected EntityId objectToKey(DBEntityLinkedEntityPrivacy dbResult) {
            return dbResult.getEntityId();
        }

        @Override
        protected Iterable<DBEntityLinkedEntityPrivacy> getListFromDatabase(Set<? extends EntityId> inputs) {
            return this._entityDAO.getEntityLinkedEntityPrivacyByEntityIds(inputs).values();
        }

        @Override
        protected String keyToString(EntityId key) {
            return key.asString();
        }
    }

    private static final class EntitySelectedPrivacyCacheAccessor
    extends AbstractListMultiMapCacheAccessor<EntityServiceCacheName, EntityId, DBPrivacySelection> {
        private final EntityDAO _entityDAO;

        private EntitySelectedPrivacyCacheAccessor(@Nonnull CacheClient<? super EntityServiceCacheName> cache, @Nonnull EntityDAO entityDAO) {
            super(cache, EntityServiceCacheName.ENTITY_SELECTED_PRIVACY);
            this._entityDAO = entityDAO;
        }

        @Override
        protected EntityId objectToKey(DBPrivacySelection dbResult) {
            return dbResult.getEntityId();
        }

        @Override
        protected Iterable<DBPrivacySelection> getListFromDatabase(Set<? extends EntityId> inputs) {
            return this._entityDAO.getEntityPrivacies(inputs);
        }

        @Override
        protected String keyToString(EntityId key) {
            return key.asString();
        }
    }
}

