/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.business.EntityParentsChangedStreamHandler;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.workstream.business.AbstractSingleWorkstreamMessageHandler;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.messages.EntityParentsChanged;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EntityParentsChangedStreamHandlerImpl
extends AbstractSingleWorkstreamMessageHandler<EntityParentsChanged>
implements EntityParentsChangedStreamHandler {
    @Autowired
    private EntityService _entityService;

    @Override
    public ImmutableSetMultimap<String, String> attributesToDelete(Set<? extends ItemId> itemIds) {
        return ImmutableSetMultimap.of();
    }

    @Override
    public EntityParentsChanged convert(DBWorkstreamMessage m, PersonTeaserModel author, ImmutableSet<Action> may, AuthorizationCheckContextWithLocale authorizationContext) {
        ItemId originItemId = m.getOriginItemId();
        if (!(originItemId instanceof EntityId)) {
            return null;
        }
        DBEntity entity = this._entityService.getById((EntityId)originItemId);
        if (entity == null) {
            return null;
        }
        String newParentIdStrings = m.getAttribute("new_parent_ids");
        if (newParentIdStrings == null) {
            return null;
        }
        ImmutableSet.Builder newParentIds = ImmutableSet.builder();
        for (String id : Splitter.on((String)",").split((CharSequence)newParentIdStrings)) {
            Long entityId = GlobalId.parseId(id);
            if (entityId == null) continue;
            newParentIds.add((Object)new EntityId(entityId));
        }
        return new EntityParentsChanged(m, author, may, entity.getName(), entity.getType(), (ImmutableSet<EntityId>)newParentIds.build());
    }
}

