/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.business.EntityNewMembershipHandler;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.workstream.business.AbstractSingleWorkstreamMessageHandler;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.messages.EntityNewMembership;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="entityNewMembershipHandler")
public class EntityNewMembershipHandlerImpl
extends AbstractSingleWorkstreamMessageHandler<EntityNewMembership>
implements EntityNewMembershipHandler {
    @Autowired
    private EntityService _entityService;

    @Override
    public ImmutableSetMultimap<String, String> attributesToDelete(Set<? extends ItemId> itemIds) {
        return ImmutableSetMultimap.of();
    }

    @Override
    public EntityNewMembership convert(DBWorkstreamMessage m, PersonTeaserModel author, ImmutableSet<Action> may, AuthorizationCheckContextWithLocale authorizationContext) {
        ItemId origin = m.getOriginItemId();
        if (!(origin instanceof EntityId)) {
            return null;
        }
        DBEntity entity = this._entityService.getById((EntityId)origin);
        if (entity == null) {
            return null;
        }
        return new EntityNewMembership(m, author, may, entity.getName(), entity.getType());
    }
}

