/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.business.events.ServerEvent;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.business.EntityEventWorkflowService;
import de.justsoftware.onx.container.business.EntityMemberChangedCallback;
import de.justsoftware.onx.container.business.EntityMemberReadDataService;
import de.justsoftware.onx.container.business.EntityMemberService;
import de.justsoftware.onx.container.business.EntityMemberWorkflowMigrationService;
import de.justsoftware.onx.container.business.events.EntityMembershipChangedEvent;
import de.justsoftware.onx.container.shared.model.AbstractImmutableEqualsObject;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberRoles;
import de.justsoftware.onx.container.shared.model.EntityMemberWithPerson;
import de.justsoftware.onx.container.shared.model.EntityMemberWorkflow;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.MemberChangeOptions;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class EntityMemberWorkflowMigrationServiceImpl
implements EntityMemberWorkflowMigrationService {
    private static final Logger LOG = LoggerFactory.getLogger(EntityMemberWorkflowMigrationServiceImpl.class);
    private static final MemberChangeOptions MIGRATION_NOTIFICATION_OPTIONS = MemberChangeOptions.builder().disableEmailNotification().setEntityNewMembershipWorkstreamMessage(false).build();
    private final EntityMemberService _memberService;
    private final EntityMemberReadDataService _memberReadDataService;
    private final EntityEventWorkflowService _eventWorkflowService;
    private final TransactionHelper _transactionHelper;
    private final JCEventBus _eventBus;
    private final TaskExecutor _taskExecutor;
    private final EntityConfigService _entityConfig;

    @Autowired
    public EntityMemberWorkflowMigrationServiceImpl(EntityConfigService entityConfig, EntityMemberService memberService, EntityMemberReadDataService memberReadDataService, EntityEventWorkflowService eventWorkflowService, JCEventBus eventBus, TransactionHelper transactionHelper, @Qualifier(value="entityMemberWorkflowMigrationTaskExecutor") TaskExecutor taskExecutor) {
        this._entityConfig = entityConfig;
        this._memberService = memberService;
        this._memberReadDataService = memberReadDataService;
        this._eventWorkflowService = eventWorkflowService;
        this._eventBus = eventBus;
        this._transactionHelper = transactionHelper;
        this._taskExecutor = taskExecutor;
    }

    @Override
    public void migrateEntityTypes(Set<EntityType> entityTypes, EntityMemberRole roleFormembersOnEvents) {
        LOG.info("migration requested for entity types: {}", entityTypes);
        for (EntityType entityType : entityTypes) {
            this.migrateEntityType(entityType, roleFormembersOnEvents);
        }
    }

    private void migrateEntityType(EntityType entityType, EntityMemberRole roleFormembersOnEvents) {
        EntityMemberWorkflow workflow = this._entityConfig.getEntityMemberWorkflow(entityType);
        ImmutableMap<EntityMemberRole, EntityMemberRole> rolesToSwap = workflow.accept(new RolesToSwapVisitor(roleFormembersOnEvents));
        ImmutableSet<EntityMemberRole> targetRoles = workflow.accept(new TargetRolesVisitor());
        MigrationAnalyzer analyzer = new MigrationAnalyzer(entityType, rolesToSwap, targetRoles);
        ImmutableSetMultimap<BatchUpdate, PersonId> batchUpdates = analyzer.doAnalyze(this._memberReadDataService);
        for (Map.Entry entries : batchUpdates.asMap().entrySet()) {
            MigrationJob job = new MigrationJob((BatchUpdate)entries.getKey(), (ImmutableSet<PersonId>)ImmutableSet.copyOf((Collection)((Collection)entries.getValue())), MIGRATION_NOTIFICATION_OPTIONS);
            this._taskExecutor.execute((Runnable)new MigrationWorkerTask(job));
        }
    }

    private static final class TargetRolesVisitor
    implements EntityMemberWorkflow.Visitor<ImmutableSet<EntityMemberRole>> {
        private TargetRolesVisitor() {
        }

        @Override
        public ImmutableSet<EntityMemberRole> visitMember() {
            return EntityMemberRoles.ALL_MEMBER_STATUS;
        }

        @Override
        public ImmutableSet<EntityMemberRole> visitEvent() {
            return EntityMemberRoles.ALL_EVENT_STATUS;
        }
    }

    private static final class RolesToSwapVisitor
    implements EntityMemberWorkflow.Visitor<ImmutableMap<EntityMemberRole, EntityMemberRole>> {
        private final EntityMemberRole _configurableMemberOnEvents;

        private RolesToSwapVisitor(@Nonnull EntityMemberRole configurableMemberOnEvents) {
            this._configurableMemberOnEvents = configurableMemberOnEvents;
        }

        @Override
        public ImmutableMap<EntityMemberRole, EntityMemberRole> visitMember() {
            return ImmutableMap.builder().put((Object)EntityMemberRole.EVENT_IS_ATTENDING, (Object)EntityMemberRole.MEMBER).put((Object)EntityMemberRole.EVENT_IS_MAYBE_ATTENDING, (Object)EntityMemberRole.MEMBER).put((Object)EntityMemberRole.EVENT_IS_NOT_ATTENDING, (Object)EntityMemberRole.MEMBER).put((Object)EntityMemberRole.EVENT_IS_ON_WAITINGLIST, (Object)EntityMemberRole.HAS_SENT_JOINREQUEST).put((Object)EntityMemberRole.EVENT_IS_INVITED, (Object)EntityMemberRole.HAS_INVITATION).put((Object)EntityMemberRole.EVENT_HAS_REJECTED_INVITATION, (Object)EntityMemberRole.HAS_REJECTED).build();
        }

        @Override
        public ImmutableMap<EntityMemberRole, EntityMemberRole> visitEvent() {
            return ImmutableMap.builder().put((Object)EntityMemberRole.MEMBER, (Object)this._configurableMemberOnEvents).put((Object)EntityMemberRole.HAS_SENT_JOINREQUEST, (Object)EntityMemberRole.EVENT_IS_ON_WAITINGLIST).put((Object)EntityMemberRole.HAS_INVITATION, (Object)EntityMemberRole.EVENT_IS_INVITED).put((Object)EntityMemberRole.HAS_REJECTED, (Object)EntityMemberRole.EVENT_HAS_REJECTED_INVITATION).put((Object)EntityMemberRole.IS_UNDECIDED, (Object)EntityMemberRole.EVENT_IS_MAYBE_ATTENDING).build();
        }
    }

    @ParametersAreNonnullByDefault
    private final class MigrationWorkerTask
    implements Runnable {
        private final MigrationJob _job;

        public MigrationWorkerTask(MigrationJob job) {
            this._job = job;
        }

        @Override
        public void run() {
            BatchUpdate batchUpdate = this._job.getBatchUpdate();
            LOG.info("Process migration job for entity {} and {} members", (Object)batchUpdate.getEntityId(), (Object)this._job.getMembers().size());
            try {
                EntityMembershipChangedEventOptimizer collector = new EntityMembershipChangedEventOptimizer();
                EntityMemberWorkflowMigrationServiceImpl.this._transactionHelper.doInTransactionWithoutResult(status -> EntityMemberWorkflowMigrationServiceImpl.this._memberService.updateMemberRoles(batchUpdate.getEntityId(), (Set<PersonId>)this._job.getMembers(), (Set<EntityMemberRole>)batchUpdate.getRolesToRemove(), (Set<EntityMemberRole>)batchUpdate.getRolesToAdd(), collector::add, this._job.getNotificationOptions(), (EntityMemberChangedCallback)EntityMemberWorkflowMigrationServiceImpl.this._eventWorkflowService));
                collector.optimizeEvents(EntityMemberWorkflowMigrationServiceImpl.this._eventBus);
            }
            catch (RuntimeException e) {
                LOG.error("Fatal error while migrating members of Entity " + batchUpdate.getEntityId(), (Throwable)e);
            }
            LOG.info("Job for entity {} finished.", (Object)batchUpdate.getEntityId());
        }

        @Nonnull
        private Multimap<PersonId, EntityMemberRole> getOrCreateValue(Map<EntityId, Multimap<PersonId, EntityMemberRole>> roleMap, EntityId entityId) {
            Multimap<PersonId, EntityMemberRole> roles = roleMap.get(entityId);
            if (roles != null) {
                return roles;
            }
            HashMultimap newMap = HashMultimap.create();
            roleMap.put(entityId, (Multimap<PersonId, EntityMemberRole>)newMap);
            return newMap;
        }
    }

    @ParametersAreNonnullByDefault
    private static class EntityMembershipChangedEventOptimizer {
        private final LinkedList<ServerEvent> _events = new LinkedList();
        private final Map<EntityId, HashMultimap<PersonId, EntityMemberRole>> _newRoles = new HashMap<EntityId, HashMultimap<PersonId, EntityMemberRole>>();
        private final Map<EntityId, HashMultimap<PersonId, EntityMemberRole>> _oldRoles = new HashMap<EntityId, HashMultimap<PersonId, EntityMemberRole>>();

        private EntityMembershipChangedEventOptimizer() {
        }

        private void optimizeEvents(JCEventBus eventBus) {
            eventBus.post(this._events);
            this._newRoles.forEach((entityId, roles) -> {
                ImmutableSetMultimap newEntityRoles = ImmutableSetMultimap.copyOf((Multimap)roles);
                HashMultimap oldEntityRoles = this._oldRoles.computeIfAbsent((EntityId)entityId, e -> HashMultimap.create());
                ImmutableSetMultimap filteredOldEntityRoles = ImmutableSetMultimap.builder().putAll((Iterable)Sets.difference((Set)oldEntityRoles.entries(), (Set)newEntityRoles.entries())).build();
                eventBus.post(new EntityMembershipChangedEvent((EntityId)entityId, (ImmutableSetMultimap<PersonId, EntityMemberRole>)newEntityRoles, (ImmutableSetMultimap<PersonId, EntityMemberRole>)filteredOldEntityRoles, true));
            });
        }

        public void add(ServerEvent event) {
            if (event instanceof EntityMembershipChangedEvent) {
                EntityMembershipChangedEvent entityMembershipChangedEvent = (EntityMembershipChangedEvent)event;
                EntityId entityId = entityMembershipChangedEvent.getEntityId();
                HashMultimap newRolesOfEntity = this._newRoles.computeIfAbsent(entityId, e -> HashMultimap.create());
                HashMultimap oldRolesOfEntity = this._oldRoles.computeIfAbsent(entityId, e -> HashMultimap.create());
                entityMembershipChangedEvent.getNewRoles().asMap().forEach((personId, roles) -> newRolesOfEntity.replaceValues(personId, (Iterable)roles));
                entityMembershipChangedEvent.getOldRoles().asMap().forEach((personId, roles) -> oldRolesOfEntity.putAll(personId, (Iterable)roles));
            } else {
                this._events.add(event);
            }
        }
    }

    @ParametersAreNonnullByDefault
    private static class MigrationAnalyzer {
        private static final Ordering<EntityMemberWithPerson> ORDERING_BY_NAME = Ordering.natural().onResultOf(EntityMemberWithPerson.LASTNAME);
        private final EntityType _entityType;
        private final ImmutableSet<EntityMemberRole> _rolesToRemove;
        private final Function<EntityMemberRole, EntityMemberRole> _swapFunction;
        private final ImmutableSet<EntityMemberRole> _targetRoles;

        public MigrationAnalyzer(EntityType entityType, ImmutableMap<EntityMemberRole, EntityMemberRole> rolesToSwap, ImmutableSet<EntityMemberRole> targetRoles) {
            this._entityType = entityType;
            this._targetRoles = targetRoles;
            this._rolesToRemove = rolesToSwap.keySet();
            this._swapFunction = Functions.forMap(rolesToSwap);
        }

        @Nonnull
        public ImmutableSetMultimap<BatchUpdate, PersonId> doAnalyze(EntityMemberReadDataService readDataService) {
            LOG.info("analyzation started for workflow migration of entity type: {}", (Object)this._entityType);
            ImmutableSetMultimap<EntityId, PersonId> membersToMigrate = readDataService.getMembersByEntityTypesAndRoles((Set<EntityType>)ImmutableSet.of((Object)this._entityType), (Set<EntityMemberRole>)this._rolesToRemove);
            ImmutableListMultimap<EntityId, EntityMemberWithPerson> membersByEntityId = readDataService.getByEntityIds((Set<EntityId>)membersToMigrate.keySet());
            ImmutableSetMultimap.Builder batchMapBuilder = ImmutableSetMultimap.builder();
            long overallUpdateCount = 0L;
            for (EntityMemberWithPerson member : ORDERING_BY_NAME.immutableSortedCopy((Iterable)membersByEntityId.values())) {
                Sets.SetView rolesToRemove = Sets.intersection(this._rolesToRemove, member.getRoles());
                Sets.SetView existingRoles = Sets.intersection(member.getRoles(), this._targetRoles);
                if (rolesToRemove.isEmpty()) continue;
                ImmutableSet rolesToAdd = existingRoles.isEmpty() ? FluentIterable.from((Iterable)rolesToRemove).transform(this._swapFunction).limit(1).toSet() : ImmutableSet.of();
                batchMapBuilder.put((Object)new BatchUpdate(member.getEntityId(), (ImmutableSet<EntityMemberRole>)rolesToRemove.immutableCopy(), (ImmutableSet<EntityMemberRole>)rolesToAdd), (Object)member.getPersonId());
                ++overallUpdateCount;
            }
            LOG.info("analyzation completed for workflow migration of entity type: {} found {} membership updates.", (Object)this._entityType, (Object)overallUpdateCount);
            return batchMapBuilder.build();
        }

        @Nonnull
        public EntityType getEntityType() {
            return this._entityType;
        }
    }

    @ParametersAreNonnullByDefault
    private static final class MigrationJob {
        private final BatchUpdate _batchUpdate;
        private final ImmutableSet<PersonId> _members;
        private final MemberChangeOptions _notificationOptions;

        public MigrationJob(BatchUpdate batchUpdate, ImmutableSet<PersonId> members, MemberChangeOptions notificationOptions) {
            this._batchUpdate = batchUpdate;
            this._members = members;
            this._notificationOptions = notificationOptions;
        }

        @Nonnull
        public BatchUpdate getBatchUpdate() {
            return this._batchUpdate;
        }

        @Nonnull
        public ImmutableSet<PersonId> getMembers() {
            return this._members;
        }

        @Nonnull
        public MemberChangeOptions getNotificationOptions() {
            return this._notificationOptions;
        }
    }

    private static class BatchUpdate
    extends AbstractImmutableEqualsObject {
        private final EntityId _entityId;
        private final ImmutableSet<EntityMemberRole> _rolesToRemove;
        private final ImmutableSet<EntityMemberRole> _rolesToAdd;

        @ParametersAreNonnullByDefault
        public BatchUpdate(EntityId entityId, ImmutableSet<EntityMemberRole> rolesToRemove, ImmutableSet<EntityMemberRole> rolesToAdd) {
            super(entityId, rolesToAdd, rolesToRemove);
            this._entityId = entityId;
            this._rolesToRemove = rolesToRemove;
            this._rolesToAdd = rolesToAdd;
        }

        @Nonnull
        public EntityId getEntityId() {
            return this._entityId;
        }

        @Nonnull
        public ImmutableSet<EntityMemberRole> getRolesToAdd() {
            return this._rolesToAdd;
        }

        @Nonnull
        public ImmutableSet<EntityMemberRole> getRolesToRemove() {
            return this._rolesToRemove;
        }
    }
}

