/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.freiheit.toro.common.shared.util.ClientStringUtil;
import com.freiheit.toro.common.shared.util.UrlUtil;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.ServerUrlUtil;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.server.util.HTMLEscaper;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.common.shared.util.UrlDetector;
import de.justsoftware.onx.container.business.EntityChildrenService;
import de.justsoftware.onx.container.business.EntityMemberNotificationService;
import de.justsoftware.onx.container.business.EntityMemberReadDataService;
import de.justsoftware.onx.container.business.EntityMemberReadWriteDataService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.events.EntityAdminChangedEvent;
import de.justsoftware.onx.container.business.events.EntityCreatedEvent;
import de.justsoftware.onx.container.business.events.EntityJoinRequestProcessedEvent;
import de.justsoftware.onx.container.business.events.EntityParentsChangedEvent;
import de.justsoftware.onx.container.business.events.NewMembershipEvent;
import de.justsoftware.onx.container.shared.i18n.EntityMessages;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMember;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberRoles;
import de.justsoftware.onx.container.shared.model.EntityMemberWithPerson;
import de.justsoftware.onx.container.shared.model.InheritsRole;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.MemberChangeOptions;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.db.EmailModel;
import de.justsoftware.onx.container.shared.model.util.EntityMemberUtil;
import de.justsoftware.onx.like.business.LikeWriteDataService;
import de.justsoftware.onx.like.shared.model.SubscriptionState;
import de.justsoftware.onx.like.shared.model.SubscriptionType;
import de.justsoftware.onx.mail.business.EMailTemplate;
import de.justsoftware.onx.mail.business.EntityJoinRequestAcceptedMailService;
import de.justsoftware.onx.mail.business.GlobalMailTemplateKeys;
import de.justsoftware.onx.mail.business.MailManager;
import de.justsoftware.onx.mail.business.MailTemplateContext;
import de.justsoftware.onx.mail.business.MailType;
import de.justsoftware.onx.mail.business.MultipartEMailTemplate;
import de.justsoftware.onx.mail.business.SendMailException;
import de.justsoftware.onx.mail.i18n.EntityMails;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import de.justsoftware.onx.util.server.EncodingUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class EntityMemberNotificationServiceImpl
implements ServerEventHandler,
EntityMemberNotificationService {
    private static final Logger LOG = LoggerFactory.getLogger(EntityMemberNotificationServiceImpl.class);
    private final EntityService _entityService;
    private final MailManager _mailManager;
    private final I18nService _i18nService;
    private final PersonService _personService;
    private final ProfileTeaserService _profileTeaserService;
    private final EntityConfigService _entityConfig;
    private final EntityMemberReadWriteDataService _entityMemberReadWriteDataService;
    private final EntityMemberReadDataService _entityMemberReadDataService;
    private final EntityChildrenService _entityChildrenService;
    private final LikeWriteDataService _likeWriteDataService;
    private final Settings _settings;
    private final ServerUrlUtil _serverUrlUtil;
    private final EntityJoinRequestAcceptedMailService _entityJoinRequestAcceptedMailService;

    @Autowired
    public EntityMemberNotificationServiceImpl(EntityService entityService, @Qualifier(value="mailManager") MailManager mailManager, I18nService i18nService, PersonService personService, ProfileTeaserService profileTeaserService, EntityConfigService entityConfig, EntityMemberReadWriteDataService entityMemberReadWriteDataService, EntityMemberReadDataService entityMemberReadDataService, EntityChildrenService entityChildrenService, LikeWriteDataService likeWriteDataService, Settings settings, ServerUrlUtil serverUrlUtil, EntityJoinRequestAcceptedMailService entityJoinRequestAcceptedMailService) {
        this._entityService = entityService;
        this._mailManager = mailManager;
        this._i18nService = i18nService;
        this._personService = personService;
        this._profileTeaserService = profileTeaserService;
        this._entityConfig = entityConfig;
        this._entityMemberReadWriteDataService = entityMemberReadWriteDataService;
        this._entityMemberReadDataService = entityMemberReadDataService;
        this._entityChildrenService = entityChildrenService;
        this._likeWriteDataService = likeWriteDataService;
        this._settings = settings;
        this._serverUrlUtil = serverUrlUtil;
        this._entityJoinRequestAcceptedMailService = entityJoinRequestAcceptedMailService;
    }

    @Subscribe
    public void onNewMembership(NewMembershipEvent e) {
        EntityId entityId;
        ImmutableSet children;
        MemberChangeOptions membershipChangeOptions = e.getOptions();
        if (!membershipChangeOptions.isEntityCreation() && membershipChangeOptions.isUpdateSubscriptions() && this._settings.getInheritedSubscriptionForMembersOnJoin() && !(children = this._entityChildrenService.getMemberInheritedEntityChildrenByParentIds((ImmutableSet<EntityId>)ImmutableSet.of((Object)(entityId = e.getEntityId()))).get((Object)entityId)).isEmpty()) {
            this.subscribeOnInheritedEntities(e.getPersonId(), (Set<EntityId>)children);
        }
    }

    @Subscribe
    public void onAdminChanged(EntityAdminChangedEvent e) {
        EntityId entityId;
        ImmutableSet children;
        if ((e.isAdmin() || e.isCoAdmin()) && this._settings.getInheritedSubscriptionForAdminsOnJoin() && !(children = this._entityChildrenService.getAdminInheritedEntityChildrenByParentIds((ImmutableSet<EntityId>)ImmutableSet.of((Object)(entityId = e.getEntityId()))).get((Object)entityId)).isEmpty()) {
            this.subscribeOnInheritedEntities(e.getPersonId(), (Set<EntityId>)children);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityParentsChanged(EntityParentsChangedEvent e) {
        this.onEntityParentInheritanceChanged(e.getEntityId(), e.isAdminInheritanceChanged(), e.isMemberInheritanceChanged());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityCreated(EntityCreatedEvent e) {
        this.onEntityParentInheritanceChanged(e.getEntityId(), true, true);
    }

    private void onEntityParentInheritanceChanged(EntityId entityId, boolean adminInheritanceChanged, boolean memberInheritanceChanged) {
        if (adminInheritanceChanged && this._settings.getInheritedSubscriptionForAdminsOnEntityUpdate()) {
            this.subscribeOnParentInheritanceConfigurationChanged(entityId, InheritsRole.INHERIT_ADMINS);
        }
        if (memberInheritanceChanged && this._settings.getInheritedSubscriptionForMembersOnEntityUpdate()) {
            this.subscribeOnParentInheritanceConfigurationChanged(entityId, InheritsRole.INHERIT_MEMBERS);
        }
    }

    private void subscribeOnInheritedEntities(PersonId personId, Set<EntityId> entities) {
        this._likeWriteDataService.setSubscriptionStateAndType((SetMultimap<? extends ItemId, PersonId>)ImmutableSetMultimap.builder().putAll((Object)personId, entities).build().inverse(), SubscriptionState.SUBSCRIBED, SubscriptionType.DEFAULT, false);
    }

    private void subscribeOnParentInheritanceConfigurationChanged(EntityId baseEntityId, InheritsRole inheritsRole) {
        ImmutableSet baseSet = ImmutableSet.of((Object)baseEntityId);
        ImmutableSetMultimap<EntityId, EntityId> bequeathingEntityParentsByChildIds = this._entityChildrenService.getBequeathingEntityParentsByChildIds((Set<EntityId>)baseSet, inheritsRole);
        ImmutableSetMultimap<EntityId, EntityId> inheritedEntityChildrenByParentIds = this._entityChildrenService.getInheritedEntityChildrenByParentIds((ImmutableSet<EntityId>)baseSet, null, inheritsRole);
        ImmutableSet parentEntities = ImmutableSet.copyOf((Collection)bequeathingEntityParentsByChildIds.values());
        ImmutableSet childEntities = ImmutableSet.builder().addAll((Iterable)inheritedEntityChildrenByParentIds.values()).addAll((Iterable)baseSet).build();
        ImmutableListMultimap<EntityId, EntityMemberWithPerson> memberMapOfParents = this._entityMemberReadDataService.getByEntityIds((Set<EntityId>)parentEntities);
        HashSet bequeathedMember = Sets.newHashSet();
        for (EntityId entityId : parentEntities) {
            bequeathedMember.addAll(EntityMemberUtil.transformToPersonIdSet(EntityMemberUtil.filterByRoles(memberMapOfParents.get((Object)entityId), this.getConcreteRoleSet(inheritsRole))));
        }
        for (EntityId entityId : childEntities) {
            this._likeWriteDataService.setSubscriptionStateAndType((SetMultimap<? extends ItemId, PersonId>)ImmutableSetMultimap.builder().putAll((Object)entityId, (Iterable)bequeathedMember).build(), SubscriptionState.SUBSCRIBED, SubscriptionType.DEFAULT, false);
        }
    }

    @Nonnull
    private ImmutableSet<EntityMemberRole> getConcreteRoleSet(InheritsRole inheritsRole) {
        switch (inheritsRole) {
            case INHERIT_ADMINS: {
                return EntityMemberRoles.ADMIN_OR_COADMIN;
            }
            case INHERIT_MEMBERS: {
                return EntityMemberRoles.HAS_MEMBER_RIGHTS;
            }
        }
        return ImmutableSet.of();
    }

    @Subscribe
    public void onEntityJoinRequestProcessed(EntityJoinRequestProcessedEvent event) {
        if (!event.isSendMailNotification()) {
            return;
        }
        DBPerson person = this._personService.getPersonByIdNotNull(event.getRequesterId());
        DBPerson sender = this._personService.getPersonByIdNotNull(event.getAdminId());
        DBEntity entity = this._entityService.getByIdNotNull(event.getEntityId());
        if (event.isAccepted()) {
            this._entityJoinRequestAcceptedMailService.sendJoinRequestAcceptedMail(sender, person, entity);
        }
    }

    @Override
    public void sendMembersNotifyMail(MailTemplateContext context, DBPerson sender, DBEntity entity, Set<PersonId> receivers, MailType mailType, EntityMemberNotificationService.MailI18nResolver i18nResolver) {
        ImmutableSet filteredReceivers = FluentIterable.from(receivers).filter(Predicates.not((Predicate)Predicates.equalTo((Object)sender.getId()))).toSet();
        ImmutableMap<PersonId, DBPerson> receiversMap = this._personService.getPersonsByIds((Set<PersonId>)filteredReceivers);
        ArrayListMultimap receiverEmailsGroupByLocale = ArrayListMultimap.create();
        for (DBPerson p : receiversMap.values()) {
            if (!p.canLogin()) continue;
            receiverEmailsGroupByLocale.put((Object)p.getLanguageId(), (Object)p);
        }
        context.put(GlobalMailTemplateKeys.SENDER, (Object)sender);
        context.put(GlobalMailTemplateKeys.ENTITY, (Object)entity);
        String domain = this._serverUrlUtil.getHtmlClientBaseUrl();
        for (Map.Entry entry : receiverEmailsGroupByLocale.asMap().entrySet()) {
            String locale = (String)entry.getKey();
            Collection persons = (Collection)entry.getValue();
            context.put(GlobalMailTemplateKeys.STARTPAGE_URI, (Object)(domain + "?&locale=" + locale + "#start"));
            i18nResolver.addI18nDependedContextAttribute(locale, context);
            EMailTemplate email = new EMailTemplate(mailType, entity.getType(), context, i18nResolver.getSubject(locale), (Collection<DBPerson>)persons);
            try {
                this._mailManager.sendMail(email);
            }
            catch (SendMailException e) {
                LOG.error("Failed to send notification to:" + e.getRecipients());
            }
        }
    }

    @Override
    public void sendMessageToEntityMembers(PersonId senderId, EntityId entityId, ImmutableSet<EntityMemberRole> toMemberOfRoles, String subject, String message, String language) {
        if (CollectionUtil.isEmpty(toMemberOfRoles)) {
            throw new ServiceException("Set of target EntityMemberRoles must not be null/empty");
        }
        DBEntity entity = this._entityService.getByIdNotNull(entityId);
        DBPerson sender = this._personService.getPersonByIdNotNull(senderId);
        Iterable<EntityMemberWithPerson> recipients = EntityMemberUtil.filterByRoles(this._entityMemberReadWriteDataService.getEntityMemberByEntityId(entityId), toMemberOfRoles);
        HashSet participantsIds = Sets.newHashSet();
        for (EntityMember entityMember : recipients) {
            participantsIds.add(entityMember.getPersonId());
        }
        participantsIds.remove(senderId);
        ImmutableMap<PersonId, DBPerson> persons = this._personService.getPersonsByIds(participantsIds);
        Map map = Maps.filterValues(persons, p -> p != null && p.isActive());
        this.sendMessageTo(sender, map, entity, subject, message);
        EntityMessages entityMessages = this._i18nService.getEntityMessagesByEntityType(entity.getType(), language);
        String text = entityMessages.entityMessageText(entity.getName(), map.size(), StringUtil.limitStringWithDots(message, this._settings.getMaxDirectMessageLength()));
        this.sendMessageTo(sender, (Map<PersonId, DBPerson>)ImmutableMap.of((Object)sender.getId(), (Object)sender), entity, subject, text);
    }

    private void sendMessageTo(DBPerson sender, Map<PersonId, DBPerson> members, DBEntity entity, String subject, String message) {
        ImmutableSet<PersonId> mailRecipients = this._personService.getEmailNotificationEnabledPersons(members.keySet());
        if (mailRecipients.isEmpty()) {
            return;
        }
        ArrayListMultimap emailsGroupByLocale = ArrayListMultimap.create();
        for (PersonId recipientId : mailRecipients) {
            DBPerson recipient = members.get(recipientId);
            if (recipient == null || !recipient.canLogin()) continue;
            emailsGroupByLocale.put((Object)recipient.getLanguageId(), (Object)recipient);
        }
        MailTemplateContext context = new MailTemplateContext();
        context.put(GlobalMailTemplateKeys.MESSAGE, (Object)message);
        context.put(GlobalMailTemplateKeys.MESSAGE_HTML, (Object)UrlDetector.addAnchorTagsUnsafe(HTMLEscaper.escape(ClientStringUtil.nullToEmpty(message)), 9999999, UrlDetector.LinkToNewWindow.NEVER, null, null).replaceAll("\n", "<br />"));
        context.put(GlobalMailTemplateKeys.SUBJECT, (Object)subject);
        context.put(GlobalMailTemplateKeys.ENTITY, (Object)entity);
        context.put(GlobalMailTemplateKeys.SENDER, (Object)sender);
        String domain = this._serverUrlUtil.getHtmlClientBaseUrl();
        String link = domain + "?#entity." + entity.getId().getId();
        context.put(GlobalMailTemplateKeys.ENTITY_URI, (Object)link);
        for (Map.Entry e : emailsGroupByLocale.asMap().entrySet()) {
            MultipartEMailTemplate email = new MultipartEMailTemplate(entity.getType(), MailType.MESSAGE_ENTITY, MailType.MESSAGE_ENTITY_HTML, context, context, subject, (Collection)e.getValue());
            try {
                this._mailManager.sendMail(email);
            }
            catch (SendMailException se) {
                LOG.error("couldn't send message to " + e.getValue(), (Throwable)se);
            }
        }
    }

    @Override
    public EmailModel getEmailModelForFeedbackEmailToAdmins(AuthorizationCheckContextWithUserId authorizationContext, EntityId entityId) {
        authorizationContext.check((ItemId)entityId, (Action)StaticEntityAction.ENTITY_SEND_FEEDBACK);
        DBEntity entity = this._entityService.getByIdNotNull(entityId);
        EntityMessages entityMessages = this._i18nService.getEntityMessagesByEntityType(entity.getType(), authorizationContext.getLocale());
        BasicConstants basicConstants = this._i18nService.createProxy(BasicConstants.class, authorizationContext.getLocale());
        PersonId personId = authorizationContext.getUserId();
        String userFullname = InvalidIdServiceException.check(this._profileTeaserService.getPersonTeaserById(personId, authorizationContext)).getFullName();
        String entityOverviewUrl = UrlUtil.getEntityOverviewUrl(entity, this._serverUrlUtil.getHtmlClientBaseUrl());
        EmailModel href = new EmailModel();
        href.setParticiants((List<String>)this.getParticipantForFeedbackEmailToAdmins(entityId));
        href.setSubject(EncodingUtil.encodeURI(entityMessages.feedbackEmailToAdminsSubject(userFullname, entity.getName())));
        href.setBody(EncodingUtil.encodeURI(entityMessages.feedbackEmailToAdminsBody(userFullname, entity.getName(), entityId.getId(), entityOverviewUrl)));
        return href;
    }

    @Nonnull
    private ImmutableList<String> getParticipantForFeedbackEmailToAdmins(EntityId entityId) {
        return FluentIterable.from((Iterable)Ordering.natural().nullsLast().onResultOf(DBPerson.TO_SHORTNAME).sortedCopy((Iterable)this._personService.getPersonsByIds((Set<PersonId>)FluentIterable.from(this._entityMemberReadWriteDataService.getEntityMemberByEntityId(entityId)).filter(EntityMemberUtil.composeRoleFilterPredicate(EntityMemberRoles.ADMIN_OR_COADMIN)).transform(EntityMember.GET_PERSON_ID).toSet()).values())).transform(DBPerson.TO_EMAIL).filter(Predicates.notNull()).toList();
    }

    @Nonnull
    private String getMailSubject(ImmutableSet<EntityMemberRole> newRoles, EntityMails entityMails, String name) {
        if (EntityMemberRoles.isMember(newRoles)) {
            return entityMails.mailSubjectParticipantList(name);
        }
        if (EntityMemberRoles.isUndecided(newRoles)) {
            return entityMails.mailSubjectUndecidedList(name);
        }
        if (EntityMemberRoles.hasInvitation(newRoles)) {
            throw new UnsupportedOperationException("invitations mails are handled other ways");
        }
        if (EntityMemberRoles.hasRejected(newRoles)) {
            return entityMails.mailSubjectRejectorList(name);
        }
        if (EntityMemberRoles.hasSentJoinRequest(newRoles)) {
            return entityMails.mailSubjectRequesterList(name);
        }
        return entityMails.mailSubjectMemberStatusRemoved(name);
    }
}

