/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.business.EntityMemberInvitationReadWriteDataService;
import de.justsoftware.onx.container.integration.persistence.EntityMemberInvitationDAO;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMemberInternalInvitation;
import de.justsoftware.onx.container.shared.model.EntityType;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EntityMemberInvitationReadWriteDataServiceImpl
implements EntityMemberInvitationReadWriteDataService {
    private final EntityMemberInvitationDAO _dao;

    @Autowired
    @ParametersAreNonnullByDefault
    public EntityMemberInvitationReadWriteDataServiceImpl(EntityMemberInvitationDAO entityMemberInvitationDAO) {
        this._dao = entityMemberInvitationDAO;
    }

    @Override
    public void persistInternalInvitation(EntityId entityId, PersonId personId, PersonId inviterId, String invitationMessage) {
        if (this.getInternalInvitationByMemberId(entityId, personId) != null) {
            this._dao.updateInvitation(entityId, personId, inviterId, invitationMessage);
        } else {
            this._dao.insertInvitation(entityId, personId, inviterId, invitationMessage);
        }
    }

    @Override
    public EntityMemberInternalInvitation getInternalInvitationByMemberId(EntityId entityId, PersonId personId) {
        return this._dao.getInvitationById(entityId, personId);
    }

    @Override
    public ImmutableList<EntityMemberInternalInvitation> getInvitationsForUser(PersonId currentUserId, ImmutableSet<EntityType> entityTypes) {
        return this._dao.getInvitationsForUser(currentUserId, entityTypes);
    }
}

