/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.common.business.events.ServerEvent;
import de.justsoftware.onx.common.business.events.util.CollectingServerEventCollector;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.business.EntityAdministrationWorkflowService;
import de.justsoftware.onx.container.business.EntityMemberDeletionHandler;
import de.justsoftware.onx.container.business.EntityMemberReadDataService;
import de.justsoftware.onx.container.business.EntityMemberService;
import de.justsoftware.onx.container.business.EntityMemberWriteDataService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMember;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberRoles;
import de.justsoftware.onx.container.shared.model.EntityMemberWithEntityType;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.MemberChangeOptions;
import de.justsoftware.onx.container.shared.model.util.EntityMemberUtil;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EntityMemberDeletionHandlerImpl
implements EntityMemberDeletionHandler {
    @Autowired
    private EntityMemberService _entityMemberService;
    @Autowired
    private EntityAdministrationWorkflowService _entityAdministrationService;
    @Autowired
    private EntityMemberWriteDataService _entityMemberWriteDataService;
    @Autowired
    private EntityMemberReadDataService _entityMemberReadDataService;

    @Override
    public void handleCascadeDelete(Set<? extends ItemId> parentIds, DeletionContext deletionContext) {
        this.handleProfileDeletions(Iterables.filter(parentIds, ProfileId.class), deletionContext);
    }

    private void handleProfileDeletions(@Nonnull Iterable<ProfileId> profileIds, DeletionContext deletionContext) {
        MemberChangeOptions noNotifications = MemberChangeOptions.builder().disableEmailNotification().build();
        if (!CollectionUtil.isEmpty(profileIds)) {
            Iterable personIds = Iterables.transform(profileIds, ProfileId.TO_PERSON_ID);
            ImmutableListMultimap<PersonId, EntityMemberWithEntityType> memberShipsToRemove = this._entityMemberReadDataService.getByPersonIds((Set<PersonId>)ImmutableSet.copyOf((Iterable)personIds));
            ImmutableCollection members = memberShipsToRemove.values();
            this._entityMemberWriteDataService.persistMemberRoles((Set<EntityId>)EntityMemberUtil.transformToEntityIdSet(members), (Set<PersonId>)memberShipsToRemove.keySet(), (Set<EntityMemberRole>)EntityMemberRoles.EMPTY);
            CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
            this._entityMemberService.notifyRoleChangeAfterBatchUpdate((Iterable<? extends EntityMember>)members, EntityMemberRoles.EMPTY, noNotifications, eventCollector);
            this._entityAdministrationService.transferAdminRightsToDefaultAdmin(EntityMemberUtil.transformToEntityIdSet(EntityMemberUtil.filterByRoles(members, new EntityMemberRole[]{EntityMemberRole.ADMIN})), noNotifications, eventCollector);
            for (ServerEvent serverEvent : eventCollector.getEvents()) {
                deletionContext.addServerEvent(serverEvent);
            }
        }
    }
}

