/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.business.events.util.CollectingServerEventCollector;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.business.EntityEventWorkflowService;
import de.justsoftware.onx.container.business.EntityInvitationWorkflowService;
import de.justsoftware.onx.container.business.EntityMemberChangedCallback;
import de.justsoftware.onx.container.business.EntityMemberInvitationReadDataService;
import de.justsoftware.onx.container.business.EntityMemberInvitationWriteDataService;
import de.justsoftware.onx.container.business.EntityMemberReadDataService;
import de.justsoftware.onx.container.business.EntityMemberService;
import de.justsoftware.onx.container.business.EntityMemberWorkflowService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.events.NewEntityMembershipInternalInvitationsEvent;
import de.justsoftware.onx.container.shared.model.EntityBadge;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInvitationBadge;
import de.justsoftware.onx.container.shared.model.EntityMemberInternalInvitation;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberRoles;
import de.justsoftware.onx.container.shared.model.EntityMemberWithEntityType;
import de.justsoftware.onx.container.shared.model.EntityMemberWithPerson;
import de.justsoftware.onx.container.shared.model.EntityMemberWorkflow;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.InvitationResultKey;
import de.justsoftware.onx.container.shared.model.MemberChangeOptions;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.util.EntityMemberUtil;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import de.justsoftware.onx.util.server.SecureRandomUtil;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@Service
@ParametersAreNonnullByDefault
public class EntityInvitationWorkflowServiceImpl
implements EntityInvitationWorkflowService {
    private static final Logger LOG = LoggerFactory.getLogger(EntityInvitationWorkflowServiceImpl.class);
    private final EntityService _entityService;
    private final TransactionHelper _transactionHelper;
    private final ProfileTeaserService _profileTeaserService;
    private final JCEventBus _eventBus;
    private final EntityConfigService _entityConfig;
    private final EntityMemberReadDataService _entityMemberReadDataService;
    private final EntityMemberInvitationReadDataService _entityMemberInvitationReadDataService;
    private final EntityMemberInvitationWriteDataService _entityMemberInvitationWriteDataService;
    private final EntityMemberService _entityMemberService;
    private final EntityMemberWorkflowService _memberWorkflowService;
    private final EntityEventWorkflowService _eventWorkflowService;

    @Autowired
    public EntityInvitationWorkflowServiceImpl(EntityService entityService, TransactionHelper transactionHelper, ProfileTeaserService profileTeaserService, JCEventBus eventBus, EntityConfigService entityConfig, EntityMemberReadDataService entityMemberReadDataService, EntityMemberInvitationReadDataService entityMemberInvitationReadDataService, EntityMemberInvitationWriteDataService entityMemberInvitationWriteDataService, EntityMemberService entityMemberService, EntityMemberWorkflowService memberWorkflowService, EntityEventWorkflowService eventWorkflowService) {
        this._entityService = entityService;
        this._transactionHelper = transactionHelper;
        this._profileTeaserService = profileTeaserService;
        this._eventBus = eventBus;
        this._entityConfig = entityConfig;
        this._entityMemberReadDataService = entityMemberReadDataService;
        this._entityMemberInvitationReadDataService = entityMemberInvitationReadDataService;
        this._entityMemberInvitationWriteDataService = entityMemberInvitationWriteDataService;
        this._entityMemberService = entityMemberService;
        this._memberWorkflowService = memberWorkflowService;
        this._eventWorkflowService = eventWorkflowService;
    }

    @Override
    public void rejectInvitation(EntityId entityId, AuthorizationCheckContextWithUserId authCtx) {
        PersonId inviteeId = authCtx.getUserId();
        CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
        this.rejectInvitationInternal(entityId, inviteeId, eventCollector, authCtx);
        eventCollector.fireEvents(this._eventBus);
    }

    private void rejectInvitationInternal(EntityId entityId, PersonId inviteeId, ServerEventCollector eventCollector, AuthorizationCheckContextWithUserId authCtx) {
        EntityMemberWithEntityType entityMember = this._entityMemberService.getMemberByPersonIdAndEntityId(inviteeId, entityId);
        if (entityMember == null || !EntityMemberRoles.hasInvitation(entityMember.getRoles())) {
            return;
        }
        EntityMemberWorkflow workflow = this._entityConfig.getEntityMemberWorkflow(entityMember.getEntityType());
        if (workflow == EntityMemberWorkflow.EVENT) {
            this._eventWorkflowService.rejectInvitationToEvent(entityId, eventCollector, authCtx);
        } else {
            this._memberWorkflowService.rejectInvitationToEntity(entityId, eventCollector, authCtx);
        }
    }

    @Override
    public ImmutableMap<EntityId, EntityMemberInternalInvitation> getInvitationsForUser(AuthorizationCheckContextWithUserId authorizationContext) {
        PersonId currentUserId = authorizationContext.getUserId();
        ImmutableList<EntityMemberInternalInvitation> invitations = this._entityMemberInvitationReadDataService.getInvitationsForUser(currentUserId, this._entityConfig.getOrderedEntityTypes());
        ImmutableList<EntityMemberWithEntityType> entityMembersByPersonId = this._entityMemberReadDataService.getEntityMembersByPersonId(currentUserId);
        ImmutableSet invitedTo = ImmutableSet.copyOf((Collection)Sets.intersection((Set)ImmutableSet.copyOf((Iterable)Iterables.transform(invitations, EntityMemberInternalInvitation.GET_ENTITY_ID)), EntityMemberUtil.transformToEntityIdSet(EntityMemberUtil.filterByRoles(entityMembersByPersonId, EntityMemberRoles.HAS_INVITATION))));
        Iterable filter = Iterables.filter(invitations, input -> input != null && invitedTo.contains((Object)input.getEntityId()));
        return Maps.uniqueIndex((Iterable)filter, EntityMemberInternalInvitation.GET_ENTITY_ID);
    }

    @Nonnull
    private ImmutableMap<String, String> createNewHashes(Set<String> nonExistingMails) {
        return ImmutableMap.copyOf((Map)Maps.asMap(nonExistingMails, (Function)new NullPermeableFunction<String, String>(){

            @Override
            protected String applySafe(String input) {
                return SecureRandomUtil.randomHex();
            }
        }));
    }

    public ImmutableMultiset<InvitationResultKey> invitePersons(AuthorizationCheckContextWithUserId authCtx, Set<PersonId> invitedPersonIds, EntityId entityId, String inviteMessage, Set<? extends ComponentType> selectedComponentTypes) {
        DBEntity entity = this._entityService.getByIdNotNull(entityId);
        EntityMemberWorkflow workflow = this._entityConfig.getEntityMemberWorkflow(entity.getType());
        ImmutableMap<PersonId, EntityMemberWithPerson> currentMembers = this._entityMemberService.getEntityMembersMappedByEntityId(entityId);
        ImmutableSet.Builder invitable = ImmutableSet.builder();
        ImmutableSet.Builder alreadyInvited = ImmutableSet.builder();
        ImmutableSet.Builder sendJoinRequest = ImmutableSet.builder();
        for (PersonId inviteeId : invitedPersonIds) {
            EntityMemberWithPerson member = (EntityMemberWithPerson)currentMembers.get(inviteeId);
            ImmutableSet<EntityMemberRole> roles = member != null ? member.getRoles() : EntityMemberRoles.EMPTY;
            switch (workflow) {
                case EVENT: {
                    this.collectEventInvitationStatus(inviteeId, roles, (ImmutableSet.Builder<PersonId>)invitable, (ImmutableSet.Builder<PersonId>)alreadyInvited);
                    break;
                }
                case MEMBER: {
                    this.collectMemberInvitationStatus(inviteeId, roles, (ImmutableSet.Builder<PersonId>)invitable, (ImmutableSet.Builder<PersonId>)alreadyInvited, (ImmutableSet.Builder<PersonId>)sendJoinRequest);
                }
            }
        }
        ImmutableSet invitablePersons = invitable.build();
        ImmutableSet skipPersons = alreadyInvited.build();
        ImmutableSet newMemberPersons = sendJoinRequest.build();
        ImmutableMultiset.Builder result = ImmutableMultiset.builder();
        result.addCopies((Object)InvitationResultKey.ALREADY_INVITED_INTERNAL, skipPersons.size());
        result.addCopies((Object)InvitationResultKey.GRANT_TO_MEMBER, newMemberPersons.size());
        CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
        this.invitePersonsInternal(workflow, entity.getId(), (Set<PersonId>)newMemberPersons, (Set<PersonId>)invitablePersons, authCtx.getUserId(), inviteMessage, eventCollector);
        eventCollector.fireEvents(this._eventBus);
        result.addCopies((Object)InvitationResultKey.INVITED_INTERNAL, invitablePersons.size());
        return result.build();
    }

    private void collectMemberInvitationStatus(PersonId inviteeId, ImmutableSet<EntityMemberRole> roles, ImmutableSet.Builder<PersonId> invitable, ImmutableSet.Builder<PersonId> alreadyInvited, ImmutableSet.Builder<PersonId> sendJoinRequest) {
        if (EntityMemberRoles.hasSentJoinRequest(roles)) {
            sendJoinRequest.add((Object)inviteeId);
        } else if (!EntityMemberRoles.hasAnyRoleOf(roles, EntityMemberRoles.ALL_MEMBER_STATUS) && !EntityMemberRoles.hasAnyRoleOf(roles, EntityMemberRoles.HAS_MEMBER_RIGHTS)) {
            invitable.add((Object)inviteeId);
        } else {
            alreadyInvited.add((Object)inviteeId);
        }
    }

    private void collectEventInvitationStatus(PersonId inviteeId, ImmutableSet<EntityMemberRole> roles, ImmutableSet.Builder<PersonId> invitable, ImmutableSet.Builder<PersonId> alreadyInvited) {
        if (!EntityMemberRoles.hasAnyRoleOf(roles, EntityMemberRoles.ALL_EVENT_STATUS)) {
            invitable.add((Object)inviteeId);
        } else {
            alreadyInvited.add((Object)inviteeId);
        }
    }

    private void invitePersonsInternal(final EntityMemberWorkflow workflow, final EntityId entityId, final Set<PersonId> makeMemberPersonIds, final Set<PersonId> invitePersonIds, final PersonId inviterId, final String invitationMessage, final ServerEventCollector eventCollector) {
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                switch (workflow) {
                    case EVENT: {
                        EntityInvitationWorkflowServiceImpl.this._entityMemberService.updateMemberRoles(entityId, invitePersonIds, (Set<EntityMemberRole>)EntityMemberRoles.EMPTY, (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.EVENT_IS_INVITED), eventCollector, MemberChangeOptions.buildDefaultWith(inviterId), EntityMemberChangedCallback.NOTHING);
                        break;
                    }
                    case MEMBER: {
                        EntityInvitationWorkflowServiceImpl.this._entityMemberService.updateMemberRoles(entityId, makeMemberPersonIds, (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.HAS_SENT_JOINREQUEST), (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.MEMBER), eventCollector, MemberChangeOptions.buildDefaultWith(inviterId), EntityMemberChangedCallback.NOTHING);
                        EntityInvitationWorkflowServiceImpl.this._entityMemberService.updateMemberRoles(entityId, invitePersonIds, (Set<EntityMemberRole>)EntityMemberRoles.EMPTY, (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.HAS_INVITATION), eventCollector, MemberChangeOptions.buildDefaultWith(inviterId), EntityMemberChangedCallback.NOTHING);
                    }
                }
                for (PersonId personId : invitePersonIds) {
                    EntityInvitationWorkflowServiceImpl.this._entityMemberInvitationWriteDataService.persistInternalInvitation(entityId, personId, inviterId, invitationMessage);
                }
                if (!invitePersonIds.isEmpty()) {
                    eventCollector.add(new NewEntityMembershipInternalInvitationsEvent(inviterId, invitePersonIds, entityId, invitationMessage));
                }
            }
        });
    }

    @Override
    public ImmutableListMultimap<EntityType, EntityInvitationBadge> getInvitationsForUser(ImmutableSet<EntityType> entityTypes, AuthorizationCheckContextWithUserId authorizationContext) {
        if (CollectionUtil.isEmpty(entityTypes)) {
            return ImmutableListMultimap.of();
        }
        PersonId currentUserId = authorizationContext.getUserId();
        ImmutableList<EntityMemberInternalInvitation> invitations = this._entityMemberInvitationReadDataService.getInvitationsForUser(currentUserId, entityTypes);
        ImmutableList<EntityMemberWithEntityType> entityMembersByPersonId = this._entityMemberReadDataService.getEntityMembersByPersonId(currentUserId);
        ImmutableSet invitedTo = ImmutableSet.copyOf((Collection)Sets.intersection((Set)ImmutableSet.copyOf((Iterable)Iterables.transform(invitations, EntityMemberInternalInvitation.GET_ENTITY_ID)), EntityMemberUtil.transformToEntityIdSet(EntityMemberUtil.filterByRoles(entityMembersByPersonId, EntityMemberRoles.HAS_INVITATION))));
        ImmutableSet personIds = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)Iterables.filter(invitations, input -> input != null && invitedTo.contains((Object)input.getEntityId())), EntityMemberInternalInvitation.GET_INVITER_ID));
        ImmutableMap<PersonId, PersonTeaserModel> inviters = this._profileTeaserService.getPersonTeasersByIds((Set<PersonId>)personIds, authorizationContext);
        ImmutableMap<EntityId, EntityBadge> entityBadges = this._entityService.getBadgesByIds((Set<EntityId>)invitedTo, authorizationContext);
        Iterable invitationBadges = Iterables.filter((Iterable)Iterables.transform(invitations, (Function)new EntityInvitationBadgeConverterFunction((Map<EntityId, EntityBadge>)entityBadges, (Map<PersonId, PersonTeaserModel>)inviters)), (Predicate)Predicates.notNull());
        return ImmutableListMultimap.copyOf((Multimap)Multimaps.index((Iterable)Ordering.natural().onResultOf(EntityInvitationBadge.GET_ENTITY_NAME_NONNULL).sortedCopy(invitationBadges), EntityInvitationBadge.GET_TYPE));
    }

    private static class EntityInvitationBadgeConverterFunction
    implements Function<EntityMemberInternalInvitation, EntityInvitationBadge> {
        private final Map<EntityId, EntityBadge> _entityBadges;
        private final Map<PersonId, PersonTeaserModel> _inviters;

        @ParametersAreNonnullByDefault
        public EntityInvitationBadgeConverterFunction(Map<EntityId, EntityBadge> entityBadges, Map<PersonId, PersonTeaserModel> inviters) {
            this._entityBadges = entityBadges;
            this._inviters = inviters;
        }

        public EntityInvitationBadge apply(EntityMemberInternalInvitation invitation) {
            EntityBadge entityBadge;
            if (invitation != null && (entityBadge = this._entityBadges.get(invitation.getEntityId())) != null) {
                return new EntityInvitationBadge(entityBadge, this._inviters.get(invitation.getInviterId()), invitation.getInviteMessage());
            }
            return null;
        }
    }
}

