/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.business.events.util.CollectingServerEventCollector;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.util.Numbers;
import de.justsoftware.onx.container.business.EntityAdministrationWorkflowService;
import de.justsoftware.onx.container.business.EntityEventWorkflowService;
import de.justsoftware.onx.container.business.EntityMemberChangedCallback;
import de.justsoftware.onx.container.business.EntityMemberService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.EventWaitlistService;
import de.justsoftware.onx.container.business.events.EntityMemberMovedToWaitinglistEvent;
import de.justsoftware.onx.container.business.events.EntityMemberRemovedFromWaitinglistEvent;
import de.justsoftware.onx.container.business.events.EntityParticipantCountDecreasedEvent;
import de.justsoftware.onx.container.business.events.EntityParticipantLimitIncreasedEvent;
import de.justsoftware.onx.container.shared.model.AddMemberResultKey;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberRoles;
import de.justsoftware.onx.container.shared.model.EntityMemberWithPerson;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.MemberChangeOptions;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.util.EntityMemberUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class EntityEventWorkflowServiceImpl
implements ServerEventHandler,
EntityEventWorkflowService {
    private final EntityMemberService _memberService;
    private final JCEventBus _eventBus;
    private final EventWaitlistService _waitlistService;
    private final EntityService _entityService;
    private final EntityAdministrationWorkflowService _entityAdministrationService;

    @Autowired
    public EntityEventWorkflowServiceImpl(EntityMemberService memberService, JCEventBus eventBus, EventWaitlistService waitlistService, EntityService entityService, EntityAdministrationWorkflowService entityAdministrationService) {
        this._memberService = memberService;
        this._eventBus = eventBus;
        this._waitlistService = waitlistService;
        this._entityService = entityService;
        this._entityAdministrationService = entityAdministrationService;
    }

    private boolean setEventStatus(EntityId entityId, Set<? extends Action> actions, Set<EntityMemberRole> assignTo, AuthorizationCheckContextWithUserId authorizationContext) {
        CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
        boolean result = this.setEventStatus(entityId, actions, assignTo, eventCollector, authorizationContext);
        eventCollector.fireEvents(this._eventBus);
        return result;
    }

    private boolean setEventStatus(EntityId entityId, Set<? extends Action> actions, Set<EntityMemberRole> assignTo, ServerEventCollector eventCollector, AuthorizationCheckContextWithUserId authorizationContext) {
        ImmutableSet<EntityMemberRole> removeRoles = EntityMemberRoles.removeRoles(EntityMemberRoles.ALL_EVENT_STATUS, assignTo);
        return this._memberService.updateMemberRoles(entityId, actions, (Set<EntityMemberRole>)removeRoles, assignTo, authorizationContext, eventCollector, MemberChangeOptions.buildDefaultWith(authorizationContext), this);
    }

    @Override
    public void attendEvent(EntityId entityId, AuthorizationCheckContextWithUserId authorizationContext) {
        boolean closingDateInFuture;
        DBEntity entity = this._entityService.getById(entityId);
        if (entity == null) {
            return;
        }
        int freeSlots = this._waitlistService.getFreeEntityParticipantSlots(entity);
        DateWithoutTimezone closingDate = entity.getClosingDate();
        boolean bl = closingDateInFuture = closingDate == null || closingDate.compareTo(new DateWithoutTimezone()) > 0;
        if (freeSlots != 0 && closingDateInFuture) {
            this.setEventStatus(entityId, (Set<? extends Action>)ImmutableSet.of((Object)StaticEntityAction.EVENT_ATTEND), (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.EVENT_IS_ATTENDING), authorizationContext);
        } else {
            this.enlistOnEventWaitinglist(entityId, authorizationContext);
        }
    }

    @Override
    public void maybeAttendEvent(EntityId entityId, AuthorizationCheckContextWithUserId authorizationContext) {
        this.setEventStatus(entityId, (Set<? extends Action>)ImmutableSet.of((Object)StaticEntityAction.EVENT_ATTEND, (Object)StaticEntityAction.EVENT_DONT_ATTEND, (Object)StaticEntityAction.EVENT_MAYBE_ATTEND), (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.EVENT_IS_MAYBE_ATTENDING), authorizationContext);
    }

    @Override
    public void dontAttendEvent(EntityId entityId, AuthorizationCheckContextWithUserId authorizationContext) {
        this.setEventStatus(entityId, (Set<? extends Action>)ImmutableSet.of((Object)StaticEntityAction.EVENT_DONT_ATTEND), (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.EVENT_IS_NOT_ATTENDING), authorizationContext);
    }

    @Override
    public void enlistOnEventWaitinglist(EntityId entityId, AuthorizationCheckContextWithUserId authorizationContext) {
        this.setEventStatus(entityId, (Set<? extends Action>)ImmutableSet.of((Object)StaticEntityAction.EVENT_ATTEND), (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.EVENT_IS_ON_WAITINGLIST), authorizationContext);
    }

    @Override
    public void leaveEvent(EntityId entityId, AuthorizationCheckContextWithUserId authorizationContext) {
        this.setEventStatus(entityId, (Set<? extends Action>)ImmutableSet.of((Object)StaticEntityAction.ENTITY_LEAVE), (Set<EntityMemberRole>)EntityMemberRoles.EMPTY, authorizationContext);
        this._entityAdministrationService.deleteCoAdmins((Set<EntityId>)ImmutableSet.of((Object)entityId), authorizationContext.getUserId());
    }

    @Override
    public void rejectInvitationToEvent(EntityId entityId, AuthorizationCheckContextWithUserId authorizationContext) {
        CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
        this.rejectInvitationToEvent(entityId, eventCollector, authorizationContext);
        eventCollector.fireEvents(this._eventBus);
    }

    @Override
    public void rejectInvitationToEvent(EntityId entityId, ServerEventCollector eventCollector, AuthorizationCheckContextWithUserId authorizationContext) {
        this.setEventStatus(entityId, (Set<? extends Action>)ImmutableSet.of(), (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.EVENT_HAS_REJECTED_INVITATION), eventCollector, authorizationContext);
    }

    @Override
    public void managerMovePersonsToList(EntityId entityId, ImmutableSet<PersonId> personIds, EntityMemberRole statusToassign, AuthorizationCheckContextWithUserId authorizationContext) {
        ImmutableSet assignTo = ImmutableSet.of((Object)statusToassign);
        CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
        authorizationContext.check((ItemId)entityId, (Action)StaticEntityAction.ENTITY_MANAGE_MEMBER);
        this._memberService.updateMemberRoles(entityId, (Set<PersonId>)personIds, (Set<EntityMemberRole>)EntityMemberRoles.removeRoles(EntityMemberRoles.ALL_EVENT_STATUS, (Set<EntityMemberRole>)assignTo), (Set<EntityMemberRole>)assignTo, (ServerEventCollector)eventCollector, MemberChangeOptions.buildDefaultWith(authorizationContext), (EntityMemberChangedCallback)this);
        eventCollector.fireEvents(this._eventBus);
    }

    @Override
    public void managerRemoveMovePersonsFromEvent(EntityId entityId, Set<PersonId> personsToModify, AuthorizationCheckContextWithUserId authorizationContext) {
        CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
        authorizationContext.check((ItemId)entityId, (Action)StaticEntityAction.ENTITY_MANAGE_MEMBER);
        this._memberService.updateMemberRoles(entityId, personsToModify, (Set<EntityMemberRole>)EntityMemberRoles.ALL_EVENT_STATUS, (Set<EntityMemberRole>)ImmutableSet.of(), (ServerEventCollector)eventCollector, MemberChangeOptions.buildDefaultWith(authorizationContext), (EntityMemberChangedCallback)this);
        eventCollector.fireEvents(this._eventBus);
    }

    @Override
    public void onMemberRolesChanged(EntityId entityId, PersonId personId, ImmutableSet<EntityMemberRole> newRoles, ImmutableSet<EntityMemberRole> oldRoles, MemberChangeOptions options, ServerEventCollector eventCollector) {
        boolean wasOnWaitinglist;
        boolean isOnWaitinglist = EntityMemberRoles.isOnWaitinglist(newRoles);
        if (isOnWaitinglist != (wasOnWaitinglist = EntityMemberRoles.isOnWaitinglist(oldRoles))) {
            if (!isOnWaitinglist) {
                this._waitlistService.removeFromWaitlist((Set<EntityId>)ImmutableSet.of((Object)entityId), personId);
                eventCollector.add(new EntityMemberRemovedFromWaitinglistEvent(entityId, personId, newRoles));
            } else {
                this._waitlistService.addToWaitlist((Set<EntityId>)ImmutableSet.of((Object)entityId), personId);
                eventCollector.add(new EntityMemberMovedToWaitinglistEvent(entityId, personId));
            }
        }
        boolean isEventAttendee = EntityMemberRoles.isAttendingEvent(newRoles);
        boolean wasEventAttendee = EntityMemberRoles.isAttendingEvent(oldRoles);
        if (wasEventAttendee && !isEventAttendee) {
            eventCollector.add(new EntityParticipantCountDecreasedEvent((ImmutableSet<EntityId>)ImmutableSet.of((Object)entityId)));
        }
    }

    @Subscribe
    public void onEntityParticipantCountDecreased(EntityParticipantCountDecreasedEvent e) {
        this.fillUpParticipantsFromWaitlist(e.getEntities());
    }

    @Subscribe
    public void onEntityParticipantLimitIncreased(EntityParticipantLimitIncreasedEvent e) {
        this.fillUpParticipantsFromWaitlist((ImmutableSet<EntityId>)ImmutableSet.of((Object)e.getEntityId()));
    }

    private void fillUpParticipantsFromWaitlist(ImmutableSet<EntityId> entityIds) {
        Map<EntityId, DBEntity> entities = this._entityService.getByIds((Set<EntityId>)entityIds);
        ImmutableMap<EntityId, Integer> freeSlots = this._waitlistService.getFreeEntityParticipantSlots(entities);
        ImmutableSetMultimap<EntityId, PersonId> participantsToAttend = this._waitlistService.getParticipantsFromWaitlist((Set<EntityId>)ImmutableSet.copyOf((Collection)freeSlots.keySet()));
        if (participantsToAttend.isEmpty()) {
            return;
        }
        EntityClosingDateInFuturePredicate isClosingDateInFuture = new EntityClosingDateInFuturePredicate(entities);
        for (EntityId entityId : participantsToAttend.keySet()) {
            ImmutableSet participants;
            int limit;
            if (!isClosingDateInFuture.apply(entityId) || (limit = Numbers.intValue((Number)freeSlots.get((Object)entityId), -1)) == 0 || (participants = limit < 0 ? participantsToAttend.get((Object)entityId) : ImmutableSet.copyOf((Iterable)Iterables.limit((Iterable)participantsToAttend.get((Object)entityId), (int)limit))) == null) continue;
            CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
            this._memberService.updateMemberRoles(entityId, (Set<PersonId>)participants, (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.EVENT_IS_ON_WAITINGLIST), (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.EVENT_IS_ATTENDING), (ServerEventCollector)eventCollector, MemberChangeOptions.buildDefault(), (EntityMemberChangedCallback)this);
            eventCollector.fireEvents(this._eventBus);
        }
    }

    @Override
    public ImmutableMultiset<AddMemberResultKey> managerAssignRoleToPerson(EntityId entityId, Set<PersonId> personIds, EntityMemberRole roleToAssign, AuthorizationCheckContextWithUserId authorizationContext) {
        if (!EntityMemberRoles.ALL_EVENT_STATUS.contains((Object)roleToAssign)) {
            throw new IllegalArgumentException("role to assing is not an event role");
        }
        authorizationContext.check((ItemId)entityId, (Action)StaticEntityAction.ENTITY_MANAGE_MEMBER);
        ImmutableMap<PersonId, EntityMemberWithPerson> allEntityMembers = this._memberService.getEntityMembersMappedByEntityId(entityId);
        ImmutableMultiset.Builder result = ImmutableMultiset.builder();
        ImmutableSet.Builder makeMemberBuilder = ImmutableSet.builder();
        for (PersonId personId : personIds) {
            EntityMemberWithPerson memberWithPerson = (EntityMemberWithPerson)allEntityMembers.get((Object)personId);
            if (memberWithPerson != null && EntityMemberUtil.isMember(memberWithPerson)) {
                result.add((Object)AddMemberResultKey.ALREADY_MEMBER);
                continue;
            }
            result.add((Object)AddMemberResultKey.MEMBER_ADDED);
            makeMemberBuilder.add((Object)personId);
        }
        CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
        this._memberService.updateMemberRoles(entityId, (Set<PersonId>)makeMemberBuilder.build(), (Set<EntityMemberRole>)EntityMemberRoles.ALL_EVENT_STATUS, (Set<EntityMemberRole>)ImmutableSet.of((Object)roleToAssign), (ServerEventCollector)eventCollector, MemberChangeOptions.buildDefaultWith(authorizationContext), (EntityMemberChangedCallback)this);
        eventCollector.fireEvents(this._eventBus);
        return result.build();
    }

    private static final class EntityClosingDateInFuturePredicate
    implements Predicate<EntityId> {
        private final Map<EntityId, DBEntity> _entities;

        public EntityClosingDateInFuturePredicate(@Nonnull Map<EntityId, DBEntity> entities) {
            this._entities = entities;
        }

        public boolean apply(EntityId input) {
            if (input == null) {
                return false;
            }
            DBEntity entity = this._entities.get(input);
            if (entity == null) {
                return false;
            }
            DateWithoutTimezone closingDate = entity.getClosingDate();
            return closingDate == null || closingDate.compareTo(new DateWithoutTimezone()) > 0;
        }
    }
}

