/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.util.RelationUtil;
import de.justsoftware.onx.container.business.EntityChildrenService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.integration.persistence.EntityChildrenDAO;
import de.justsoftware.onx.container.integration.persistence.model.ParentChildEntityType;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.InheritsRole;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.db.DBEntityLink;
import de.justsoftware.onx.searchnew.business.EntityChildrenSearchService;
import de.justsoftware.onx.searchnew.business.criteria.Criterion;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypeCountType;
import de.justsoftware.onx.searchnew.shared.model.SearchResult;
import de.justsoftware.onx.searchnew.shared.model.SortType;
import de.justsoftware.onx.searchnew.shared.model.SubFilter;
import de.justsoftware.onx.searchnew.shared.model.SuggestModel;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EntityChildrenServiceImpl
implements EntityChildrenService {
    private static final Logger LOG = LoggerFactory.getLogger(EntityChildrenServiceImpl.class);
    @Autowired
    private EntityConfigService _entityConfigService;
    @Autowired
    private EntityChildrenSearchService _searchService;
    @Autowired
    private EntityChildrenDAO _entityChildrenDAO;
    @Autowired
    private EntityService _entityService;

    @Override
    public ImmutableSetMultimap<EntityId, EntityId> getAllEntityChildrenByParentIds(ImmutableSet<EntityId> parentIds) {
        return this._entityChildrenDAO.getEntityChildren((Set<EntityId>)parentIds);
    }

    @Override
    public ImmutableSetMultimap<EntityId, EntityId> getAdminInheritedEntityChildrenByParentIds(ImmutableSet<EntityId> parentIds) {
        return this.getInheritedEntityChildrenByParentIds(parentIds, null, InheritsRole.INHERIT_ADMINS);
    }

    @Nonnull
    private ImmutableList<ParentChildEntityType> getAllowedParentInheritance(@Nonnull InheritsRole inheritsRole) {
        ImmutableSet<EntityType> orderedEntityTypes = this._entityConfigService.getOrderedEntityTypes();
        ImmutableSet activated = ImmutableSet.copyOf((Iterable)Iterables.filter(orderedEntityTypes, this._entityConfigService.entityTypeActivated()));
        ImmutableList.Builder builder = ImmutableList.builder();
        for (EntityType parentType : activated) {
            for (EntityType childType : activated) {
                switch (inheritsRole) {
                    case INHERIT_ADMINS: {
                        if (!this._entityConfigService.inheritsAdminEnabled(parentType, childType)) break;
                        builder.add((Object)new ParentChildEntityType(parentType, childType));
                        break;
                    }
                    case INHERIT_MEMBERS: {
                        if (!this._entityConfigService.inheritsMemberEnabled(parentType, childType)) break;
                        builder.add((Object)new ParentChildEntityType(parentType, childType));
                    }
                }
            }
        }
        return builder.build();
    }

    @Override
    public ImmutableSetMultimap<EntityId, EntityId> getMemberInheritedEntityChildrenByParentIds(ImmutableSet<EntityId> parentIds) {
        return this.getInheritedEntityChildrenByParentIds(parentIds, null, InheritsRole.INHERIT_MEMBERS);
    }

    @Override
    public ImmutableSetMultimap<EntityId, EntityId> getInheritedEntityChildrenByParentIds(ImmutableSet<EntityId> parentIds, ImmutableSet<EntityType> childEntityTypes, InheritsRole inheritsRole) {
        ImmutableList<ParentChildEntityType> allowedParentInheritance = this.getAllowedParentInheritance(inheritsRole);
        return this._entityChildrenDAO.getInheritedEntityChildren(parentIds, (Collection<ParentChildEntityType>)allowedParentInheritance, childEntityTypes, inheritsRole);
    }

    @Override
    public ImmutableMap<FilterType, ImmutableMultiset<FilterTypeCountType>> getVisibleChildrenCounts(SearchAuthorizationCheckContext authorizationContext, Iterable<EntityId> parentIds) {
        return this._searchService.getVisibleChildrenCounts(authorizationContext, parentIds);
    }

    @Override
    public ImmutableMap<EntityId, Long> getVisibleChildrenCountsMappedByEntityId(SearchAuthorizationCheckContext authorizationContext, Set<EntityType> entityTypes, Set<EntityId> parentIds, boolean direct) {
        return this._searchService.getVisibleChildrenCountsMappedByEntityId(authorizationContext, entityTypes, parentIds, direct);
    }

    @Override
    public ImmutableMap<EntityId, Long> getVisibleChildrenCountsMappedByEntityId(SearchAuthorizationCheckContext authorizationContext, Set<EntityId> parentIds, boolean direct, Set<FilterType> filterTypes, Iterable<? extends SubFilter> subFilter) {
        return this._searchService.getVisibleChildrenCountsMappedByEntityId(authorizationContext, parentIds, direct, filterTypes, subFilter);
    }

    @Override
    public Collection<EntityId> getChildrenIds(EntityId entityId, Iterable<EntityType> entityTypes, boolean returnDirectChildren, SortType sortType) {
        return this._searchService.getChildrenIds(entityId, entityTypes, returnDirectChildren, sortType);
    }

    @Override
    public ListAndCount<EntityId> getVisibleChildrenIds(SearchAuthorizationCheckContext authorizationContext, EntityId entityId, Iterable<EntityType> entityType, int offset, int numberOfResults, SortType sortType, Iterable<? extends SubFilter> subFilter) {
        return this._searchService.getVisibleChildrenIds(authorizationContext, entityId, entityType, offset, numberOfResults, sortType, subFilter);
    }

    @Override
    @Deprecated
    public ImmutableSet<ItemId> getChildrenOfEntities(boolean directChildren, Iterable<ItemType> types, Set<EntityId> parentIds, Criterion additionalCriterion) {
        return this._searchService.getChildrenOfEntities(directChildren, types, parentIds, additionalCriterion);
    }

    @Override
    public ImmutableSet<FilterType> getAllEntityFilterTypes() {
        return this._searchService.getAllEntityFilterTypes();
    }

    @Override
    public ImmutableSet<EntityId> findMyContentChildEntities(EntityId entityId, ImmutableSet<EntityType> entityTypes, SearchAuthorizationCheckContext authorizationContext) {
        return this._searchService.findMyContentChildEntities(entityId, entityTypes, authorizationContext);
    }

    @Override
    public ImmutableSetMultimap<EntityId, EntityId> getAllEntityParents(Set<EntityId> childIds) {
        return this._entityChildrenDAO.getAllEntityParents(childIds);
    }

    @Override
    public SearchResult<SuggestModel<?, ?>> findVisibleDirectChildren(EntityId parentEntityId, ImmutableSet<FilterType> filterTypes, Iterable<? extends SubFilter> subFilter, SortType sortType, int offset, int numberOfResults, SearchAuthorizationCheckContext authorizationContext) {
        return this._searchService.findVisibleDirectChildren(parentEntityId, filterTypes, subFilter, sortType, offset, numberOfResults, authorizationContext);
    }

    @Override
    public ImmutableSetMultimap<EntityId, EntityId> getBequeathingEntityParentsByChildIds(Set<EntityId> entityIds, InheritsRole role) {
        ImmutableSetMultimap.Builder allRelations = ImmutableSetMultimap.builder();
        Map<EntityId, DBEntity> entities = this._entityService.getByIds(entityIds);
        HashSet<EntityId> handled = new HashSet<EntityId>(entities.keySet());
        while (!entities.isEmpty()) {
            HashSet<EntityId> parentIds = new HashSet<EntityId>();
            for (DBEntity e : entities.values()) {
                for (DBEntityLink l : e.getLinkedEntities()) {
                    if (!this.inherits(role, l)) continue;
                    parentIds.add(l.getLinkedEntityId());
                }
            }
            Map<EntityId, DBEntity> parents = this._entityService.getByIds(parentIds);
            HashMap<EntityId, DBEntity> nextRoundEntities = new HashMap<EntityId, DBEntity>();
            for (DBEntity e : entities.values()) {
                for (DBEntityLink l : e.getLinkedEntities()) {
                    EntityId parentId = l.getLinkedEntityId();
                    DBEntity parent = parents.get(parentId);
                    if (parent == null || !this.inherits(role, l) || !this.inheritanceEnabled(role, parent.getType(), e.getType())) continue;
                    allRelations.put((Object)e.getId(), (Object)parentId);
                    if (!handled.add(parentId)) continue;
                    nextRoundEntities.put(parentId, parent);
                }
            }
            entities = nextRoundEntities;
        }
        return RelationUtil.flattenTransitiveRelations(entityIds, allRelations.build());
    }

    private boolean inherits(@Nonnull InheritsRole role, @Nonnull DBEntityLink l) {
        switch (role) {
            case INHERIT_ADMINS: {
                return l.isInheritsAdmins();
            }
            case INHERIT_MEMBERS: {
                return l.isInheritsMembers();
            }
        }
        LOG.error("no behavior for " + role + " defined returning false");
        return false;
    }

    private boolean inheritanceEnabled(@Nonnull InheritsRole role, @Nonnull EntityType parentType, @Nonnull EntityType childType) {
        switch (role) {
            case INHERIT_ADMINS: {
                return this._entityConfigService.inheritsAdminEnabled(parentType, childType);
            }
            case INHERIT_MEMBERS: {
                return this._entityConfigService.inheritsMemberEnabled(parentType, childType);
            }
        }
        LOG.error("no behavior for " + role + " defined returning false");
        return false;
    }
}

