/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.common.shared.util.Multimaps2;
import de.justsoftware.onx.container.business.AnchorExtractor;
import de.justsoftware.onx.container.business.EntityAnchorService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.integration.persistence.EntityAnchorDAO;
import de.justsoftware.onx.container.shared.model.EntityAnchorComponent;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityTab;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.StaticEntityTab;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.multiwiki.business.MultiWikiService;
import de.justsoftware.onx.multiwiki.shared.server.model.IMultiWikiVersionSection;
import de.justsoftware.onx.raweditor.business.RawEditorService;
import de.justsoftware.onx.raweditor.shared.model.db.DBRawEditorVersion;
import de.justsoftware.onx.wikieditor.business.WikiEditorService;
import de.justsoftware.onx.wikieditor.shared.server.model.DBWikiVersion;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class EntityAnchorServiceImpl
implements EntityAnchorService {
    private static final int CHUNK_SIZE = 20;
    private final EntityService _entityService;
    private final MultiWikiService _multiWikiService;
    private final RawEditorService _rawEditorService;
    private final WikiEditorService _wikiEditorService;
    private final EntityAnchorDAO _entityAnchorDAO;

    @Autowired
    public EntityAnchorServiceImpl(EntityService entityService, MultiWikiService multiWikiService, RawEditorService rawEditorService, WikiEditorService wikiEditorService, EntityAnchorDAO entityAnchorDAO) {
        this._entityService = entityService;
        this._multiWikiService = multiWikiService;
        this._rawEditorService = rawEditorService;
        this._wikiEditorService = wikiEditorService;
        this._entityAnchorDAO = entityAnchorDAO;
    }

    @Override
    public void indexComponents(SetMultimap<EntityAnchorComponent, EntityId> entitiesPerComponent) {
        this.description(entitiesPerComponent);
        this.multiwiki(entitiesPerComponent);
        this.wiki(entitiesPerComponent);
        this.rawEditors(entitiesPerComponent);
    }

    private void wiki(SetMultimap<EntityAnchorComponent, EntityId> entitiesPerComponent) {
        Set entityIds = entitiesPerComponent.get((Object)EntityAnchorComponent.WIKI_EDITOR);
        for (List chunk : Iterables.partition((Iterable)entityIds, (int)20)) {
            ImmutableMap<GlobalId, DBWikiVersion> wikis = this._wikiEditorService.getCurrentDBWikiVersionByParentId((Set<? extends GlobalId>)ImmutableSet.copyOf((Collection)chunk));
            for (EntityId entityId : chunk) {
                DBWikiVersion wikiVersion = (DBWikiVersion)wikis.get((Object)entityId);
                ImmutableSet text = wikiVersion != null ? ImmutableSet.of((Object)wikiVersion.getText()) : ImmutableSet.of();
                ImmutableSet<String> anchors = AnchorExtractor.extractAnchors((Iterable<String>)text);
                this._entityAnchorDAO.insertEntityAnchors(entityId, EntityAnchorComponent.WIKI_EDITOR, (Set<String>)anchors);
            }
        }
    }

    private void multiwiki(SetMultimap<EntityAnchorComponent, EntityId> entitiesPerComponent) {
        Set entityIds = entitiesPerComponent.get((Object)EntityAnchorComponent.MULTI_WIKI);
        for (List chunk : Iterables.partition((Iterable)entityIds, (int)20)) {
            ImmutableListMultimap<EntityId, IMultiWikiVersionSection> sections = this._multiWikiService.getNewestSections((Set<EntityId>)ImmutableSet.copyOf((Collection)chunk));
            for (EntityId entityId : chunk) {
                FluentIterable contents = FluentIterable.from((Iterable)sections.get((Object)entityId)).transform(IMultiWikiVersionSection.TEXT);
                ImmutableSet<String> anchors = AnchorExtractor.extractAnchors((Iterable<String>)contents);
                this._entityAnchorDAO.insertEntityAnchors(entityId, EntityAnchorComponent.MULTI_WIKI, (Set<String>)anchors);
            }
        }
    }

    private void description(SetMultimap<EntityAnchorComponent, EntityId> entitiesPerComponent) {
        Set entityIds = entitiesPerComponent.get((Object)EntityAnchorComponent.DESCRIPTION);
        for (List chunk : Iterables.partition((Iterable)entityIds, (int)20)) {
            Map<EntityId, DBEntity> entities = this._entityService.getByIds((Set<EntityId>)ImmutableSet.copyOf((Collection)chunk));
            for (EntityId entityId : chunk) {
                DBEntity entity = entities.get(entityId);
                String description = entity != null ? entity.getDescription() : null;
                ImmutableSet<String> anchors = AnchorExtractor.extractAnchors(description);
                this._entityAnchorDAO.insertEntityAnchors(entityId, EntityAnchorComponent.DESCRIPTION, (Set<String>)anchors);
            }
        }
    }

    private void rawEditors(SetMultimap<EntityAnchorComponent, EntityId> entitiesPerComponent) {
        ImmutableSetMultimap parentsAndComponents = ImmutableSetMultimap.builder().putAll((Object)StaticComponentType.RAW_EDITOR1, (Iterable)entitiesPerComponent.get((Object)EntityAnchorComponent.RAW_EDITOR1)).putAll((Object)StaticComponentType.RAW_EDITOR2, (Iterable)entitiesPerComponent.get((Object)EntityAnchorComponent.RAW_EDITOR2)).putAll((Object)StaticComponentType.RAW_EDITOR3, (Iterable)entitiesPerComponent.get((Object)EntityAnchorComponent.RAW_EDITOR3)).putAll((Object)StaticComponentType.RAW_EDITOR4, (Iterable)entitiesPerComponent.get((Object)EntityAnchorComponent.RAW_EDITOR4)).build().inverse();
        for (ImmutableSetMultimap chunk : Multimaps2.partition(parentsAndComponents, 20)) {
            ImmutableTable<GlobalId, ComponentType, DBRawEditorVersion> rawEditorVersions = this._rawEditorService.getCurrentDBVersionsByParents((SetMultimap<? extends GlobalId, ? extends ComponentType>)chunk);
            for (Map.Entry entry : chunk.entries()) {
                StaticComponentType componentType = (StaticComponentType)entry.getValue();
                Optional<EntityAnchorComponent> entityAnchorComponent = EntityAnchorComponent.fromComponentType(componentType);
                if (!entityAnchorComponent.isPresent()) continue;
                EntityId entityId = (EntityId)entry.getKey();
                DBRawEditorVersion rawEditorVersion = (DBRawEditorVersion)rawEditorVersions.get((Object)entityId, (Object)componentType);
                String text = rawEditorVersion != null ? rawEditorVersion.getText() : null;
                ImmutableSet<String> anchors = AnchorExtractor.extractAnchors(text);
                this._entityAnchorDAO.insertEntityAnchors(entityId, (EntityAnchorComponent)((Object)entityAnchorComponent.get()), (Set<String>)anchors);
            }
        }
    }

    @Override
    public ImmutableSetMultimap<EntityId, String> getAnchors(ImmutableSet<EntityId> entities, AuthorizationCheckContext authCtx) {
        ImmutableSet<EntityId> visible = authCtx.filterAllowedIds(entities, StaticEntityAction.ENTITY_READ_DETAILS);
        return this._entityAnchorDAO.getAnchorsByEntityIds((Set<EntityId>)visible);
    }

    @Override
    public EntityTab getTabForHash(EntityId entityId, String hash, AuthorizationCheckContext authCtx) {
        ImmutableSet<EntityAnchorComponent> components = this.getComponentsForHash(entityId, hash, authCtx);
        if (components.isEmpty()) {
            return null;
        }
        switch ((EntityAnchorComponent)((Object)Iterables.getFirst(components, (Object)((Object)EntityAnchorComponent.DESCRIPTION)))) {
            case DESCRIPTION: {
                return StaticEntityTab.INFORMATION;
            }
            case MULTI_WIKI: 
            case RAW_EDITOR1: 
            case RAW_EDITOR2: 
            case RAW_EDITOR3: 
            case RAW_EDITOR4: 
            case WIKI_EDITOR: {
                return StaticEntityTab.DASHBOARD;
            }
        }
        return null;
    }

    @Override
    public ImmutableSet<EntityAnchorComponent> getComponentsForHash(EntityId entityId, String hash, AuthorizationCheckContext authCtx) {
        if (!authCtx.may((ItemId)entityId, (Action)StaticEntityAction.ENTITY_READ_DETAILS)) {
            return ImmutableSet.of();
        }
        return this._entityAnchorDAO.getComponentTypeByEntityIdAndAnchor(entityId, hash);
    }
}

