/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.business.events.ServerEvent;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.business.EntityVersionService;
import de.justsoftware.onx.container.business.model.NewDriveChangeEntityVersionModel;
import de.justsoftware.onx.container.shared.model.DriveChangeId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.drive.business.model.DriveChangePurpose;
import de.justsoftware.onx.kafka.AbstractKafkaConsumer;
import de.justsoftware.onx.kafka.KafkaConfigurationProvider;
import de.justsoftware.onx.kafka.KafkaConsumerContext;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy(value=false)
@ParametersAreNonnullByDefault
public class DriveChangeEntityVersionConsumer
extends AbstractKafkaConsumer<String, String> {
    static final String TOPIC = "just.drive.changes";
    private static final Logger LOG = LoggerFactory.getLogger(DriveChangeEntityVersionConsumer.class);
    private final EntityVersionService _entityVersionService;
    private final JCEventBus _eventBus;

    @Autowired
    public DriveChangeEntityVersionConsumer(TransactionHelper transactionHelper, KafkaConfigurationProvider kafkaConfigurationProvider, EntityVersionService entityVersionService, JCEventBus eventBus) {
        this(kafkaConfigurationProvider.stringConsumer("just.toro.DriveChangeEntityVersion"), transactionHelper, entityVersionService, eventBus);
    }

    @VisibleForTesting
    DriveChangeEntityVersionConsumer(@Nullable Consumer<String, String> consumer, TransactionHelper transactionHelper, EntityVersionService entityVersionService, JCEventBus eventBus) {
        super(consumer, transactionHelper, TOPIC);
        this._entityVersionService = entityVersionService;
        this._eventBus = eventBus;
    }

    @Override
    protected Logger getLog() {
        return LOG;
    }

    @CheckForNull
    private NewDriveChangeEntityVersionModel parse(ConsumerRecord<String, String> input) {
        if (input.value() == null) {
            return null;
        }
        JsonNode parsedJson = this.parseJson((String)input.value());
        if (parsedJson == null) {
            return null;
        }
        ItemId entityId = ItemId.parseSafe(parsedJson.findValue("itemId").asText());
        if (!(entityId instanceof EntityId)) {
            return null;
        }
        Optional<DriveChangePurpose> purpose = DriveChangeEntityVersionConsumer.parseChangePurpose(parsedJson, "purpose");
        DriveChangeId driveChangeId = new DriveChangeId((String)input.key());
        int version = parsedJson.findValue("version").asInt();
        Optional<DateTime> changeDate = DriveChangeEntityVersionConsumer.parseDate(parsedJson, "changeDate");
        PersonId executedBy = DriveChangeEntityVersionConsumer.parsePerson(parsedJson, "executedBy").orElseGet(() -> DriveChangeEntityVersionConsumer.parsePerson(parsedJson, "ownerId").orElse(null));
        if (executedBy == null) {
            LOG.warn("could not find any executor / owner for change {}", (Object)parsedJson.toString());
            return null;
        }
        return new NewDriveChangeEntityVersionModel((EntityId)entityId, driveChangeId, executedBy, version, (DriveChangePurpose)purpose.orNull(), (DateTime)changeDate.orNull());
    }

    @Override
    protected void process(ConsumerRecords<String, String> records, KafkaConsumerContext context) {
        ImmutableList.Builder events = ImmutableList.builder();
        this._entityVersionService.createEntityVersionsForDriveChanges((Iterable<NewDriveChangeEntityVersionModel>)FluentIterable.from(records).transform(this::parse).filter(Predicates.notNull()), arg_0 -> ((ImmutableList.Builder)events).add(arg_0));
        context.afterCommit(() -> this._eventBus.post((Iterable<? extends ServerEvent>)events.build()));
    }
}

