/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.container.business.DriveChangeDeletionHandler;
import de.justsoftware.onx.container.business.DriveChangeVersionPublisher;
import de.justsoftware.onx.container.integration.persistence.EntityVersionDriveChangeDAO;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.ItemId;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class DriveChangeDeletionHandlerImpl
implements DriveChangeDeletionHandler {
    private final EntityVersionDriveChangeDAO _entityVersionDriveChangeDAO;
    private final DriveChangeVersionPublisher _driveChangePublicityPublisher;

    @Autowired
    public DriveChangeDeletionHandlerImpl(EntityVersionDriveChangeDAO entityVersionDriveChangeDAO, DriveChangeVersionPublisher driveChangePublicityPublisher) {
        this._entityVersionDriveChangeDAO = entityVersionDriveChangeDAO;
        this._driveChangePublicityPublisher = driveChangePublicityPublisher;
    }

    @Override
    public void handleCascadeDelete(Set<? extends ItemId> parentIds, DeletionContext deletionContext) {
        ImmutableSet entityVersionIds = FluentIterable.from(parentIds).filter(EntityVersionId.class).toSet();
        this._driveChangePublicityPublisher.deleteEntityVersions((Set<EntityVersionId>)entityVersionIds);
        this._entityVersionDriveChangeDAO.deleteByEntityVersions((Set<EntityVersionId>)entityVersionIds);
    }
}

