/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import de.justsoftware.onx.album.shared.server.model.AlbumImageItem;
import de.justsoftware.onx.album.shared.server.model.AlbumItem;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.ProfileReadRole;
import de.justsoftware.onx.common.business.BreadcrumbLinkService;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.common.business.ServerLocalizedMessages;
import de.justsoftware.onx.common.shared.i18n.LocalizedMessages;
import de.justsoftware.onx.common.shared.model.EntityLink;
import de.justsoftware.onx.common.shared.model.Link;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.server.util.TokenUtilServer;
import de.justsoftware.onx.common.shared.util.HistoryToken;
import de.justsoftware.onx.container.business.BreadcrumbService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.ItemService;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.BreadCrumbLink;
import de.justsoftware.onx.container.shared.model.BreadCrumbViewData;
import de.justsoftware.onx.container.shared.model.DefaultItemIdVisitor;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.StaticEntityTab;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.container.shared.server.model.ItemVisitor;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.survey.shared.server.model.SurveyItem;
import de.justsoftware.onx.videolink.shared.server.model.VideolinkItem;
import de.justsoftware.onx.workstream.shared.server.model.WorkstreamItem;
import de.justsoftware.polls.model.pollid.item.PollItem;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="breadcrumbService")
public class BreadcrumbServiceImpl
implements BreadcrumbService {
    @Autowired
    private ItemService _itemService;
    @Autowired
    private I18nService _i18nService;
    @Autowired
    private EntityService _entityService;
    @Autowired
    private Settings _settings;
    @Autowired
    private BreadcrumbLinkService _breadcrumbLinkService;

    @Override
    public BreadCrumbViewData breadcrumb(GlobalId id, EntityId currentEntityId, EntityId currentLayoutEntityId, AuthorizationCheckContextWithLocale authorizationContext) {
        BreadCrumbViewData result = new BreadCrumbViewData();
        LinkedList<BreadCrumbLink> childs = new LinkedList<BreadCrumbLink>();
        ServerLocalizedMessages localizedMessages = this._i18nService.getLocalizedMessages(authorizationContext.getLocale());
        BreadcrumbVisitor visitorChild = new BreadcrumbVisitor(childs, this._settings.isDisplayEntityTypeInBreadCrumbs(), authorizationContext, localizedMessages);
        result.setChildren(childs);
        GlobalId lastExistingId = id;
        ItemId currentId = id;
        try {
            while (currentId != null) {
                Item<GlobalId> item = this._itemService.getByIdNonNull(currentId);
                item.accept(visitorChild);
                lastExistingId = currentId;
                currentId = item.getParentId();
            }
        }
        catch (InvalidIDException item) {
            // empty catch block
        }
        if (lastExistingId instanceof EntityId) {
            List<EntityId> path;
            EntityId nextEntityIdToSearch = (EntityId)lastExistingId;
            LinkedList<BreadCrumbLink> parents = new LinkedList<BreadCrumbLink>();
            BreadcrumbVisitor visitorParents = new BreadcrumbVisitor(parents, this._settings.isDisplayEntityTypeInBreadCrumbs(), authorizationContext, localizedMessages);
            result.setParents(parents);
            if (currentEntityId != null && !currentEntityId.equals(nextEntityIdToSearch) && (path = this._entityService.searchPathFromEntityToEntity(nextEntityIdToSearch, currentEntityId)) != null) {
                nextEntityIdToSearch = currentEntityId;
                this.addPathToBreadcrumb(visitorParents, path, true);
            }
            if (currentLayoutEntityId != null && !currentLayoutEntityId.equals(currentEntityId) && (path = this._entityService.searchPathFromEntityToEntity(nextEntityIdToSearch, currentLayoutEntityId)) != null) {
                nextEntityIdToSearch = currentLayoutEntityId;
                this.addPathToBreadcrumb(visitorParents, path, true);
            }
            path = this._entityService.searchShortesPathToRootEntity(nextEntityIdToSearch);
            this.addPathToBreadcrumb(visitorParents, path, true);
        }
        return result;
    }

    private void addPathToBreadcrumb(@Nonnull BreadcrumbVisitor visitor, @Nonnull List<EntityId> path, boolean skipFirst) {
        if (path != null) {
            boolean first = true;
            for (EntityId id : path) {
                if (first && skipFirst) {
                    first = false;
                    continue;
                }
                try {
                    this._itemService.getByIdNonNull(id).accept(visitor);
                }
                catch (InvalidIDException invalidIDException) {}
            }
        }
    }

    private class BreadcrumbVisitor
    extends ItemVisitor.DefaultItemVisitor<Object> {
        private final LinkedList<BreadCrumbLink> _breadcrumb;
        private final LocalizedMessages _localelLocalizedMessages;
        private final boolean _showEntityType;
        private final AuthorizationCheckContextWithLocale _authorizationContext;

        public BreadcrumbVisitor(LinkedList<BreadCrumbLink> breadcrumb, @Nonnull boolean showEntityType, AuthorizationCheckContextWithLocale authorizationContext, LocalizedMessages localizedMessages) {
            this._breadcrumb = breadcrumb;
            this._authorizationContext = authorizationContext;
            this._showEntityType = showEntityType;
            this._localelLocalizedMessages = localizedMessages;
        }

        @Override
        protected Object visitDefault(Item<?> item) {
            return this;
        }

        @Override
        public Object visit(AlbumItem item) {
            if (!this._authorizationContext.may((Item<?>)item, (Action)StaticAction.ALBUM_READ)) {
                return this.addNotVisibleItem();
            }
            this._breadcrumb.addFirst(new BreadCrumbLink(BreadcrumbServiceImpl.this._breadcrumbLinkService.link(item, this._localelLocalizedMessages)));
            final GlobalId parentId = item.getParentId();
            if (parentId != null) {
                String token = parentId.accept(new DefaultItemIdVisitor<String>(){

                    @Override
                    public String visitDefault(ItemId itemId) {
                        return TokenUtilServer.createToken(HistoryToken.ALBUMS, "LS", parentId, parentId.getType().name());
                    }

                    @Override
                    public String visit(EntityId entityId) {
                        return TokenUtilServer.createToken(HistoryToken.ENTITY, "LS", entityId, StaticEntityTab.ALBUMS.getName());
                    }
                });
                this._breadcrumb.addFirst(new BreadCrumbLink(new Link(this._localelLocalizedMessages.albumConstants().pictures(), token)));
            }
            return this;
        }

        @Override
        public Object visit(AlbumImageItem item) {
            if (!this._authorizationContext.may((Item<?>)item, (Action)StaticAction.ALBUM_READ)) {
                return this.addNotVisibleItem();
            }
            this._breadcrumb.addFirst(new BreadCrumbLink(BreadcrumbServiceImpl.this._breadcrumbLinkService.link(item, this._localelLocalizedMessages)));
            return this;
        }

        @Override
        public Object visit(EntityItem item) {
            if (!this._authorizationContext.may((Item<?>)item, (Action)StaticEntityAction.ENTITY_READ_DETAILS)) {
                return this.addNotVisibleItem();
            }
            EntityType entityType = item.getEntity().getType();
            EntityConstants entityConstants = this._localelLocalizedMessages.entityConstants(entityType);
            String text = this._showEntityType ? entityConstants.entity(entityType) + ": " : "";
            Link link = BreadcrumbServiceImpl.this._breadcrumbLinkService.link(item);
            this._breadcrumb.addFirst(new BreadCrumbLink(new EntityLink(text + link.getText(), link.getHref(), item.getId())));
            return this;
        }

        @Override
        public Object visit(ProfileItem profileItem) {
            if (!this._authorizationContext.may(ProfileReadRole.of(profileItem.getId()))) {
                return this.addNotVisibleItem();
            }
            this._breadcrumb.addFirst(new BreadCrumbLink(BreadcrumbServiceImpl.this._breadcrumbLinkService.link(profileItem)));
            return this;
        }

        @Override
        public Object visit(SurveyItem item) {
            if (!this._authorizationContext.may((Item<?>)item, (Action)StaticAction.SURVEY_READ)) {
                return this.addNotVisibleItem();
            }
            this._breadcrumb.addFirst(new BreadCrumbLink(BreadcrumbServiceImpl.this._breadcrumbLinkService.link(item)));
            return this;
        }

        @Override
        public Object visit(VideolinkItem item) {
            if (!this._authorizationContext.may((Item<?>)item, (Action)StaticAction.VIDEOLINK_READ)) {
                return this.addNotVisibleItem();
            }
            this._breadcrumb.addFirst(new BreadCrumbLink(BreadcrumbServiceImpl.this._breadcrumbLinkService.link(item)));
            GlobalId parentId = item.getParentId();
            if (parentId != null) {
                this._breadcrumb.addFirst(new BreadCrumbLink(new Link(this._localelLocalizedMessages.videolinkConstants().breadcrumbVideos(), TokenUtilServer.createToken(HistoryToken.MDL_VIDEOS, "LS", parentId, parentId.getType().name()))));
            }
            return this;
        }

        @Override
        public Object visit(WorkstreamItem workstreamMessage) {
            this._breadcrumb.addFirst(new BreadCrumbLink(BreadcrumbServiceImpl.this._breadcrumbLinkService.link(workstreamMessage, this._localelLocalizedMessages, this._authorizationContext)));
            return this;
        }

        @Override
        public Object visit(PollItem pollItem) {
            return this;
        }

        @Nonnull
        private Object addNotVisibleItem() {
            this._breadcrumb.addFirst(new BreadCrumbLink(new Link(this._localelLocalizedMessages.basicConstants().secretItem(), null)));
            return this;
        }
    }
}

