/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.events;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.common.business.events.ServerEvent;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.AbstractImmutableEqualsObject;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import javax.annotation.Nonnull;

public class EntityMembershipChangedEvent
extends AbstractImmutableEqualsObject
implements ServerEvent {
    private final EntityId _entityId;
    private final ImmutableSetMultimap<PersonId, EntityMemberRole> _newRoles;
    private final ImmutableSetMultimap<PersonId, EntityMemberRole> _oldRoles;
    private final boolean _bulk;

    public EntityMembershipChangedEvent(@Nonnull EntityId entityId, @Nonnull ImmutableSetMultimap<PersonId, EntityMemberRole> newRoles, @Nonnull ImmutableSetMultimap<PersonId, EntityMemberRole> oldRoles, boolean bulk) {
        super(entityId, newRoles, oldRoles, bulk);
        this._entityId = entityId;
        this._newRoles = newRoles;
        this._oldRoles = oldRoles;
        this._bulk = bulk;
    }

    @Nonnull
    public EntityId getEntityId() {
        return this._entityId;
    }

    public boolean isBulk() {
        return this._bulk;
    }

    @Nonnull
    public ImmutableSetMultimap<PersonId, EntityMemberRole> getNewRoles() {
        return this._newRoles;
    }

    @Nonnull
    public ImmutableSetMultimap<PersonId, EntityMemberRole> getOldRoles() {
        return this._oldRoles;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entityId", (Object)this._entityId).add("newRoles", this._newRoles).add("oldRoles", this._oldRoles).add("bulk", this._bulk).toString();
    }
}

