/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.events;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.business.events.ServerEvent;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberRoles;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityAdminChangedEvent
implements ServerEvent {
    private final EntityId _entityId;
    private final PersonId _personId;
    private final ImmutableSet<EntityMemberRole> _newRoles;
    private final ImmutableSet<EntityMemberRole> _oldRoles;

    public EntityAdminChangedEvent(EntityId entityId, PersonId personId, ImmutableSet<EntityMemberRole> newRoles, ImmutableSet<EntityMemberRole> oldRoles) {
        this._entityId = entityId;
        this._personId = personId;
        this._newRoles = newRoles;
        this._oldRoles = oldRoles;
    }

    @Nonnull
    public EntityId getEntityId() {
        return this._entityId;
    }

    @Nonnull
    public PersonId getPersonId() {
        return this._personId;
    }

    public boolean isAdmin() {
        return EntityMemberRoles.isAdmin(this._newRoles);
    }

    public boolean isCoAdmin() {
        return EntityMemberRoles.isCoAdmin(this._newRoles);
    }

    @Nonnull
    public ImmutableSet<EntityMemberRole> getNewRoles() {
        return this._newRoles;
    }

    @Nonnull
    public ImmutableSet<EntityMemberRole> getOldRoles() {
        return this._oldRoles;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entityId", (Object)this._entityId).add("personId", (Object)this._personId).add("newRoles", this._newRoles).add("oldRoles", this._oldRoles).toString();
    }
}

