/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.events;

import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.business.events.ServerEvent;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public class DriveDocumentUpdatedEvent
implements ServerEvent {
    private final DriveDocumentId _documentId;
    private final DateTime _documentChangeDate;

    public DriveDocumentUpdatedEvent(DriveDocumentId documentId, DateTime documentChangeDate) {
        this._documentId = documentId;
        this._documentChangeDate = documentChangeDate;
    }

    @Nonnull
    public DriveDocumentId getDocumentId() {
        return this._documentId;
    }

    @Nonnull
    public DateTime getDocumentChangeDate() {
        return this._documentChangeDate;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("documentId", (Object)this._documentId).add("documentChangeDate", (Object)this._documentChangeDate).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DriveDocumentUpdatedEvent that = (DriveDocumentUpdatedEvent)o;
        return Objects.equals(this._documentId, that._documentId) && Objects.equals(this._documentChangeDate, that._documentChangeDate);
    }

    public int hashCode() {
        return Objects.hash(this._documentId, this._documentChangeDate);
    }
}

