/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.csvexport;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.server.model.export.EntityExportData;
import de.justsoftware.onx.export.csv.server.i18n.CsvExportConstants;
import de.justsoftware.onx.person.business.attributes.i18n.Language;
import de.justsoftware.onx.person.business.attributes.i18n.Translation;
import de.justsoftware.onx.person.business.attributes.i18n.Translations;
import de.justsoftware.onx.person.shared.i18n.ProfileConstants;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface EntityDataExportService {
    public static final String BASIC_PREFIX = "BASIC";
    public static final String ATTRIBUTES_PART_SEPARATOR = ".";

    @Nonnull
    public List<EntityExportData> getEntityExportData(@Nullable Date var1, @Nullable Date var2);

    @Nonnull
    public ImmutableSet<ImmutableMap<String, String>> getEntityMemberExportData(EntityId var1, AuthorizationContext var2);

    @Nonnull
    public ImmutableSet<ImmutableMap<String, String>> getPlatformMembersExportData(AuthorizationCheckContextWithUserId var1);

    @ParametersAreNonnullByDefault
    public static class ExportColmnKeysTranslator
    extends NullPermeableFunction<ExportColumnKeys, Translation>
    implements ExportColumnKeysVisitor<String> {
        private final Language _language;
        private final CsvExportConstants _csvExportConstants;
        private final ProfileConstants _profileConstants;
        private final EntityConstants _entityConstants;

        public ExportColmnKeysTranslator(Language language, CsvExportConstants csvExportConstants, ProfileConstants profileConstants, EntityConstants entityConstants) {
            this._language = language;
            this._csvExportConstants = csvExportConstants;
            this._profileConstants = profileConstants;
            this._entityConstants = entityConstants;
        }

        @Nonnull
        public static Iterable<Translation> translateAll(Language language, CsvExportConstants csvExportConstants, ProfileConstants profileConstants, EntityConstants entityConstants) {
            return FluentIterable.from((Object[])ExportColumnKeys.values()).transform((Function)new ExportColmnKeysTranslator(language, csvExportConstants, profileConstants, entityConstants));
        }

        @Override
        protected Translation applySafe(ExportColumnKeys key) {
            return new Translation(this._language, key.name(), key.apply(this));
        }

        @Override
        public String visitPersonFullName() {
            return this._csvExportConstants.personFullname();
        }

        @Override
        public String visitPersonIsActive() {
            return this._csvExportConstants.personIsActive();
        }

        @Override
        public String visitPersonId() {
            return this._csvExportConstants.personId();
        }

        @Override
        public String visitPersonExternalId() {
            return this._csvExportConstants.personExternalId();
        }

        @Override
        public String visitPersonEmail() {
            return this._profileConstants.email();
        }

        @Override
        public String visitEntityName() {
            return this._csvExportConstants.entityName();
        }

        @Override
        public String visitEntityStartTime() {
            return this._csvExportConstants.entityStartTime();
        }

        @Override
        public String visitEntityEndTime() {
            return this._csvExportConstants.entityEndTime();
        }

        @Override
        public String visitEntityTimezone() {
            return this._entityConstants.timezone();
        }

        @Override
        public String visitMemberStatus() {
            return this._entityConstants.memberStatus();
        }

        @Override
        public String visitMemberRoles() {
            return this._csvExportConstants.memberRoles();
        }

        @Override
        public String visitPersonTitle() {
            return this._profileConstants.title();
        }

        @Override
        public String visitPersonAdditionalTitle() {
            return this._profileConstants.additionalTitle();
        }

        @Override
        public String visitPersonFirstName() {
            return this._profileConstants.firstName();
        }

        @Override
        public String visitPersonLastName() {
            return this._profileConstants.lastName();
        }

        @Override
        public String visitSurveyParticipantNumber() {
            return this._csvExportConstants.surveyParticipantNumber();
        }

        @Override
        public String visitSurveyParticipationDate() {
            return this._csvExportConstants.surveyParticipationDate();
        }
    }

    @ParametersAreNonnullByDefault
    public static enum ExportColumnKeys {
        PERSON_FULL_NAME{

            @Override
            public <T> T apply(ExportColumnKeysVisitor<T> visitor) {
                return visitor.visitPersonFullName();
            }
        }
        ,
        PERSON_IS_ACTIVE{

            @Override
            public <T> T apply(ExportColumnKeysVisitor<T> visitor) {
                return visitor.visitPersonIsActive();
            }
        }
        ,
        PERSON_ID{

            @Override
            public <T> T apply(ExportColumnKeysVisitor<T> visitor) {
                return visitor.visitPersonId();
            }
        }
        ,
        PERSON_EXTERNAL_ID{

            @Override
            public <T> T apply(ExportColumnKeysVisitor<T> visitor) {
                return visitor.visitPersonExternalId();
            }
        }
        ,
        PERSON_EMAIL{

            @Override
            public <T> T apply(ExportColumnKeysVisitor<T> visitor) {
                return visitor.visitPersonEmail();
            }
        }
        ,
        ENTITY_NAME{

            @Override
            public <T> T apply(ExportColumnKeysVisitor<T> visitor) {
                return visitor.visitEntityName();
            }
        }
        ,
        ENTITY_START_TIME{

            @Override
            public <T> T apply(ExportColumnKeysVisitor<T> visitor) {
                return visitor.visitEntityStartTime();
            }
        }
        ,
        ENTITY_END_TIME{

            @Override
            public <T> T apply(ExportColumnKeysVisitor<T> visitor) {
                return visitor.visitEntityEndTime();
            }
        }
        ,
        ENTITY_TIMEZONE{

            @Override
            public <T> T apply(ExportColumnKeysVisitor<T> visitor) {
                return visitor.visitEntityTimezone();
            }
        }
        ,
        MEMBER_STATUS{

            @Override
            public <T> T apply(ExportColumnKeysVisitor<T> visitor) {
                return visitor.visitMemberStatus();
            }
        }
        ,
        MEMBER_ROLES{

            @Override
            public <T> T apply(ExportColumnKeysVisitor<T> visitor) {
                return visitor.visitMemberRoles();
            }
        }
        ,
        PERSON_ADDITIONAL_TITLE{

            @Override
            public <T> T apply(ExportColumnKeysVisitor<T> visitor) {
                return visitor.visitPersonAdditionalTitle();
            }
        }
        ,
        PERSON_FIRST_NAME{

            @Override
            public <T> T apply(ExportColumnKeysVisitor<T> visitor) {
                return visitor.visitPersonFirstName();
            }
        }
        ,
        PERSON_LAST_NAME{

            @Override
            public <T> T apply(ExportColumnKeysVisitor<T> visitor) {
                return visitor.visitPersonLastName();
            }
        }
        ,
        PERSON_TITLE{

            @Override
            public <T> T apply(ExportColumnKeysVisitor<T> visitor) {
                return visitor.visitPersonTitle();
            }
        }
        ,
        SURVEY_PARTICIPANT_NUMBER{

            @Override
            public <T> T apply(ExportColumnKeysVisitor<T> visitor) {
                return visitor.visitSurveyParticipantNumber();
            }
        }
        ,
        SURVEY_PARTICIPANT_DATE{

            @Override
            public <T> T apply(ExportColumnKeysVisitor<T> visitor) {
                return visitor.visitSurveyParticipationDate();
            }
        };


        @Nonnull
        public abstract <T> T apply(ExportColumnKeysVisitor<T> var1);
    }

    public static interface ExportColumnKeysVisitor<T> {
        @Nonnull
        public T visitPersonFullName();

        @Nonnull
        public T visitPersonIsActive();

        @Nonnull
        public T visitPersonId();

        @Nonnull
        public T visitPersonExternalId();

        @Nonnull
        public T visitPersonEmail();

        @Nonnull
        public T visitPersonTitle();

        @Nonnull
        public T visitPersonFirstName();

        @Nonnull
        public T visitPersonLastName();

        @Nonnull
        public T visitPersonAdditionalTitle();

        @Nonnull
        public T visitEntityName();

        @Nonnull
        public T visitEntityStartTime();

        @Nonnull
        public T visitEntityEndTime();

        @Nonnull
        public T visitEntityTimezone();

        @Nonnull
        public T visitMemberStatus();

        @Nonnull
        public T visitMemberRoles();

        @Nonnull
        public T visitSurveyParticipantNumber();

        @Nonnull
        public T visitSurveyParticipationDate();
    }

    @ParametersAreNonnullByDefault
    public static final class CSVHeaderTranslator
    extends NullPermeableFunction<String, String> {
        private final Translations _overridenHeaderNames;
        private final Translations _platformTranslations;

        public CSVHeaderTranslator(Translations overridenHeaderNames, Translations platformTranslations) {
            this._overridenHeaderNames = overridenHeaderNames;
            this._platformTranslations = platformTranslations;
        }

        @Override
        protected String applySafe(String input) {
            String overriddenTranslation = this._overridenHeaderNames.translate(input);
            if (!StringUtil.isEmpty(overriddenTranslation)) {
                return overriddenTranslation;
            }
            String defaultTranslation = this._platformTranslations.translate(input);
            if (!StringUtil.isEmpty(defaultTranslation)) {
                return defaultTranslation;
            }
            return input;
        }
    }
}

