/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business;

import de.justsoftware.onx.common.business.configfile.ConfFilePosition;
import de.justsoftware.onx.common.business.configfile.nodes.MapNode;
import de.justsoftware.onx.container.business.OptionType;
import de.justsoftware.onx.container.shared.model.teasers.MemoTeaser;
import de.justsoftware.onx.container.shared.model.teasers.StaticTeaser;
import de.justsoftware.onx.container.shared.model.teasers.TeaserType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum OptionTeaserType {
    ICON_WITH_TEASER_TEXT(StaticTeaser.ICON_WITH_TEASER_TEXT),
    ONE_LINE_ENTITY_NAME(StaticTeaser.ONE_LINE_ENTITY_NAME),
    ICON_WITH_ENTITY_NAME(StaticTeaser.ICON_WITH_ENTITY_NAME),
    NEWS_TEASER(StaticTeaser.NEWS_TEASER),
    NEWS_TEASER_WITH_TEASER_TEXT(StaticTeaser.NEWS_TEASER_WITH_TEASER_TEXT),
    SEARCH_RESULT_WITH_TEASER_TEXT(StaticTeaser.SEARCH_RESULT_WITH_TEASER_TEXT),
    MEMO_TEASER{

        @Override
        public TeaserType createTeaserType(ConfFilePosition confFilePosition, MapNode map) throws OptionType.OptionTypeException {
            if (map == null) {
                throw new OptionType.OptionTypeException(confFilePosition, "MemoTeaser must contain an ICON");
            }
            String icon = OptionType.readRequiredFromMap("ICON", OptionType.STRING_TYPE, map);
            String color = OptionType.readFromMapWithDefault("COLOR", OptionType.STRING_TYPE, map, "#ffffff");
            Long collapsedDescLength = OptionType.readFromMapWithDefault("COLLAPSED_DESC_LENGTH", OptionType.LONG_TYPE, map, 100L);
            return new MemoTeaser(icon, color, collapsedDescLength.intValue());
        }
    }
    ,
    SLIDESHOW_TEASER(StaticTeaser.SLIDESHOW_TEASER);

    private final StaticTeaser _staticTeaser;

    private OptionTeaserType() {
        this(null);
    }

    private OptionTeaserType(StaticTeaser staticTeaser) {
        this._staticTeaser = staticTeaser;
    }

    @Nonnull
    public TeaserType createTeaserType(@Nullable ConfFilePosition confFilePosition, @Nullable MapNode map) throws OptionType.OptionTypeException {
        if (this._staticTeaser != null) {
            return this._staticTeaser;
        }
        throw new UnsupportedOperationException("you have to override this method or supply a StaticTeaser");
    }
}

