/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.business.configfile.ConfFilePosition;
import de.justsoftware.onx.common.business.configfile.LoadConfigFileException;
import de.justsoftware.onx.common.business.configfile.model.EntityVersionReviewerConfigModel;
import de.justsoftware.onx.common.shared.model.attributes.Range;
import de.justsoftware.onx.container.business.OptionValidator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EntityVersionReviewerConfigValidator implements OptionValidator<EntityVersionReviewerConfigModel>
{
    INSTANCE;


    @Override
    public void validate(ConfFilePosition pos, EntityVersionReviewerConfigModel config) throws EntityVersionReviewerConfigValidatonException {
        ImmutableList build;
        ImmutableList.Builder result = ImmutableList.builder();
        result.addAll(this.validateRange(config.getReviewerRange()));
        String reviewerResult = this.validateReviewers(config);
        if (reviewerResult != null) {
            result.add((Object)reviewerResult);
        }
        if (!(build = result.build()).isEmpty()) {
            throw new EntityVersionReviewerConfigValidatonException(pos, "Invalid entity version reviewer config: " + Joiner.on((char)'\n').skipNulls().join((Iterable)build.asList()));
        }
    }

    @Nonnull
    private ImmutableList<String> validateRange(@Nonnull Range range) {
        Long max;
        ImmutableList.Builder result = ImmutableList.builder();
        if (range.getMin().intValue() < 1) {
            result.add((Object)"Entity reviewer range MIN must not be less than 1.");
        }
        if ((max = range.getMax()) != null && range.getMin().intValue() > max.intValue()) {
            result.add((Object)"Entity reviewer range MAX must be equal or greater than MIN.");
        }
        return result.build();
    }

    @CheckForNull
    private String validateReviewers(@Nonnull EntityVersionReviewerConfigModel config) {
        Range range;
        ImmutableList<ImmutableSet<String>> reviewers = config.getReviewers();
        if (!this.stagesRespectRange(reviewers, range = config.getReviewerRange())) {
            return "Expected Range.MIN <= NumberOfDefinedReviewStages <= Range.MAX.";
        }
        for (ImmutableSet reviewersForStage : reviewers) {
            if (!reviewersForStage.isEmpty()) continue;
            return "The set of reviewers for a stage must not be empty.";
        }
        return null;
    }

    private boolean stagesRespectRange(@Nonnull ImmutableList<ImmutableSet<String>> reviewers, @Nonnull Range range) {
        Long max = range.getMax();
        return max == null || reviewers.size() <= max.intValue();
    }

    public static class EntityVersionReviewerConfigValidatonException
    extends LoadConfigFileException {
        private static final long serialVersionUID = 3948390274857595206L;

        public EntityVersionReviewerConfigValidatonException(@Nullable ConfFilePosition pos, @Nonnull String message) {
            super(pos, message);
        }

        public EntityVersionReviewerConfigValidatonException(@Nullable ConfFilePosition pos, @Nonnull Throwable cause) {
            super(pos, cause);
        }
    }
}

