/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business;

import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.business.model.EntityVersion;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import de.justsoftware.onx.container.shared.model.EntityStatusId;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.EntityVersionType;
import de.justsoftware.onx.container.shared.model.db.DBEntityVersion;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface EntityVersionReadWriteDataService {
    @Nonnull
    public ImmutableMultimap<EntityId, EntityVersion> getNewestVersionByStatus(Set<EntityId> var1, Set<EntityStatus> var2);

    @Nonnull
    public ImmutableSetMultimap<EntityId, EntityVersion> getNewestVersions(Set<EntityId> var1);

    @Nonnull
    public ImmutableMap<EntityStatus, EntityVersion> getNewestVersionByStatus(EntityId var1, Set<EntityStatus> var2);

    @Nonnull
    public ImmutableSet<EntityVersion> getNewestVersions(EntityId var1);

    @Nonnull
    public EntityVersionId create(DBEntityVersion var1);

    public void update(DBEntityVersion var1);

    public void delete(EntityVersionId var1);

    public void deleteVersions(Set<EntityVersionId> var1);

    public void updateStatusForEntityVersions(EntityId var1, Set<EntityStatus> var2, EntityStatus var3);

    public void updateStatus(EntityVersionId var1, EntityStatus var2);

    @Nonnull
    public ImmutableMap<EntityVersionId, EntityVersion> getByIdsAsMap(Set<EntityVersionId> var1);

    @CheckForNull
    public EntityVersion getById(EntityVersionId var1);

    public void clearCacheForEntityId(Set<EntityId> var1);

    public void clearIdCacheForVersions(Set<EntityVersionId> var1);

    public void updateStatusOfVersionsWithStatus(Set<EntityStatusId> var1, EntityStatus var2);

    @Nonnull
    public ListAndCount<EntityVersion> getDeclinedForPerson(int var1, int var2, PersonId var3);

    public void updateReadDateByEntityVersionId(EntityVersionId var1, DateWithoutTimezone var2);

    public int countVersionsForEntity(EntityId var1, Iterable<EntityStatus> var2);

    @Nonnull
    public ImmutableList<EntityVersion> getVersionsForEntity(EntityId var1, Iterable<EntityStatus> var2, int var3, int var4);

    @CheckForNull
    public EntityVersionId getLatestVersionByType(EntityId var1, EntityVersionType var2);

    public void updateForImport(DBEntityVersion var1);

    @CheckForNull
    public EntityVersion getLastNonDraftVersionBefore(EntityVersionId var1);

    @Nonnull
    public ListAndCount<EntityId> getEntityDraftsForAuthor(int var1, int var2, PersonId var3);

    public int getDraftCountForAuthor(PersonId var1);

    @CheckForNull
    public EntityVersionId getFirstVersionForEntity(EntityId var1);
}

