/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business;

import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.business.EntityMemberChangedCallback;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMember;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberWithEntityType;
import de.justsoftware.onx.container.shared.model.EntityMemberWithPerson;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.InheritsRole;
import de.justsoftware.onx.container.shared.model.MemberChangeOptions;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface EntityMemberService {
    @Nonnull
    public ImmutableList<EntityMemberWithPerson> getEntityMembersByEntityId(EntityId var1);

    @Nonnull
    public ImmutableMap<PersonId, EntityMemberWithPerson> getEntityMembersMappedByEntityId(EntityId var1);

    @CheckForNull
    public EntityMemberWithEntityType getMemberByPersonIdAndEntityId(@Nullable PersonId var1, EntityId var2);

    @Nonnull
    public Map<EntityId, EntityMemberWithEntityType> getMemberByPersonIdAndEntityIds(PersonId var1, Set<EntityId> var2);

    @Nonnull
    public Map<PersonId, EntityMemberWithPerson> getMemberByEntityIdAndPersonIds(EntityId var1, Set<PersonId> var2);

    @Nonnull
    public ListAndCount<EntityMemberWithPerson> getInheritPersons(EntityId var1, InheritsRole var2, String var3, boolean var4, AuthorizationCheckContextWithLocale var5, int var6, int var7);

    public void insertMemberToParticipantOrWaitlist(Set<EntityId> var1, PersonId var2);

    public void deleteMember(PersonId var1, EntityId var2);

    public void addMembersToEntity(EntityId var1, Set<PersonId> var2, Set<EntityMemberRole> var3);

    @Nonnull
    public ImmutableSetMultimap<PersonId, EntityId> getEntityIdsByPersonIdAndMemberRoles(Set<PersonId> var1, Set<EntityMemberRole> var2);

    @Nonnull
    public ImmutableSetMultimap<PersonId, EntityId> getPersonIdsByEntityIdAndMemberRoles(Set<EntityId> var1, Set<EntityMemberRole> var2);

    @Nonnull
    public ImmutableList<EntityMemberWithEntityType> getEntityMembershipsByPersonId(PersonId var1);

    public boolean isMemberOfSameEntity(PersonId var1, PersonId var2);

    @Nonnull
    public ImmutableSetMultimap<PersonId, PersonId> getMembersOfSameEntityOfPersons(Set<PersonId> var1);

    @Nonnull
    public ImmutableListMultimap<EntityId, EntityMemberWithPerson> getEntityMembersByEntityIds(Set<EntityId> var1);

    @Nonnull
    public ImmutableListMultimap<PersonId, EntityMemberWithEntityType> getEntityMembersByPersonIds(Set<PersonId> var1);

    @Nonnull
    public ImmutableSetMultimap<EntityId, EntityMemberRole> getMemberRolesByPersonIdAndEntityTypes(PersonId var1, ImmutableSet<EntityType> var2, AuthorizationCheckContextWithUserId var3);

    @Nonnull
    public ImmutableListMultimap<PersonId, EntityMemberWithPerson> getEntityAndInheritedMembersByEntityId(EntityId var1);

    public void notifyRoleChangeAfterBatchUpdate(Iterable<? extends EntityMember> var1, ImmutableSet<EntityMemberRole> var2, MemberChangeOptions var3, ServerEventCollector var4);

    public void deleteAllRoles(PersonId var1, EntityId var2) throws ServiceException;

    @Nonnull
    public ImmutableSetMultimap<EntityId, PersonId> getInheritedMembers(InheritsRole var1, Set<EntityId> var2);

    public boolean updateMemberRoles(EntityId var1, Set<? extends Action> var2, Set<EntityMemberRole> var3, Set<EntityMemberRole> var4, AuthorizationCheckContextWithUserId var5, ServerEventCollector var6, MemberChangeOptions var7, EntityMemberChangedCallback var8);

    public void updateMemberRoles(Set<EntityId> var1, PersonId var2, Set<EntityMemberRole> var3, Set<EntityMemberRole> var4, ServerEventCollector var5, MemberChangeOptions var6, @Nullable EntityMemberChangedCallback var7);

    public void updateMemberRoles(EntityId var1, Set<PersonId> var2, Set<EntityMemberRole> var3, Set<EntityMemberRole> var4, ServerEventCollector var5, MemberChangeOptions var6, @Nullable EntityMemberChangedCallback var7);

    @Nonnull
    public ImmutableSetMultimap<EntityId, PersonId> getEntityMembersByEntityTypesAndPersonIdsAndRoles(Set<EntityType> var1, Set<PersonId> var2, Set<EntityMemberRole> var3);

    @Nonnull
    public ImmutableList<EntityId> getEntityMembersByEntityTypesAndPersonIdAndRoles(Set<EntityType> var1, PersonId var2, Set<EntityMemberRole> var3, int var4, int var5);

    public int getExistingCountForEntityMembersByEntityTypesAndPersonIdAndRoles(Set<EntityType> var1, PersonId var2, Set<EntityMemberRole> var3);

    @GwtIncompatible(value="for transitional use on server only")
    public static class NonExistingEntityMember
    implements EntityMember {
        private static final long serialVersionUID = 1L;
        private final PersonId _personId;
        private final EntityId _entityId;

        @ParametersAreNonnullByDefault
        public NonExistingEntityMember(PersonId personId, EntityId entityId) {
            this._entityId = entityId;
            this._personId = personId;
        }

        @Override
        public EntityId getEntityId() {
            return this._entityId;
        }

        @Override
        public PersonId getPersonId() {
            return this._personId;
        }

        @Override
        public ImmutableSet<EntityMemberRole> getRoles() {
            return ImmutableSet.of();
        }

        @Override
        public EntityMember.InheritanceType getInheritanceType() {
            return EntityMember.InheritanceType.NONE;
        }
    }
}

