/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.AdminRoleForEntitiesException;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityMember;
import de.justsoftware.onx.container.shared.model.EntityMemberWithPerson;
import de.justsoftware.onx.container.shared.model.MakeCoAdminStatusKey;
import de.justsoftware.onx.container.shared.model.MemberChangeOptions;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

public interface EntityAdministrationWorkflowService {
    @Nonnull
    public List<EntityInfo> getAdminEntities(@Nonnull PersonId var1, @Nonnull AuthorizationCheckContextWithLocale var2);

    @Nonnull
    public ImmutableList<EntityMemberWithPerson> getJoinRequestsForUser(@Nonnull AuthorizationCheckContextWithUserId var1);

    public ListAndCount<PersonTeaserModel> getActiveAdminsByEntityId(EntityId var1, int var2, int var3, @Nonnull AuthorizationCheckContextWithLocale var4);

    @CheckForNull
    public EntityMember getAdmin(EntityId var1);

    public void deleteCoAdmins(@Nonnull EntityId var1, @Nonnull ImmutableSet<PersonId> var2);

    public void deleteCoAdmins(@Nonnull Set<EntityId> var1, @Nonnull PersonId var2);

    @ParametersAreNonnullByDefault
    public void deleteCoAdmins(Set<EntityId> var1, PersonId var2, ServerEventCollector var3, MemberChangeOptions var4);

    public void grantMemberToAdmin(@Nonnull EntityId var1, @Nonnull PersonId var2, MemberChangeOptions var3, ServerEventCollector var4);

    public void grantMemberToAdmin(@Nonnull EntityId var1, @Nonnull PersonId var2, MemberChangeOptions var3);

    public ImmutableMap<MakeCoAdminStatusKey, Integer> grantMembersToCoAdmin(@Nonnull EntityId var1, @Nonnull Set<PersonId> var2, MemberChangeOptions var3);

    public void makeCoAdminWithMeAsAdminFallback(@Nonnull EntityId var1, @Nonnull Set<PersonId> var2, @Nonnull AuthorizationCheckContextWithUserId var3);

    public void transferAdminRightsToDefaultAdmin(@Nonnull PersonId var1, @Nonnull MemberChangeOptions var2) throws AdminRoleForEntitiesException;

    public void transferAdminRightsToDefaultAdmin(@Nonnull ImmutableSet<EntityId> var1, @Nonnull MemberChangeOptions var2, ServerEventCollector var3) throws AdminRoleForEntitiesException;

    public void transferAdminRightsToDefaultAdmin(@Nonnull EntityId var1, @Nonnull PersonId var2, @Nonnull MemberChangeOptions var3);

    public void transferAdminRightsToDefaultAdmin(@Nonnull EntityMember var1, @Nonnull MemberChangeOptions var2) throws AdminRoleForEntitiesException;

    @CheckForNull
    public PersonTeaserModel getPersonForAdminRightsTransfer(@Nonnull AuthorizationCheckContextWithLocale var1);

    @Nonnull
    public ImmutableSetMultimap<EntityId, PersonId> getDirectAdminsAndCoAdmins(@Nonnull Set<EntityId> var1);

    @Nonnull
    public Iterable<EntityMemberWithPerson> getDirectCoAdmins(@Nonnull EntityId var1);
}

