/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.util;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public abstract class ValueOfMap<K, V>
implements Function<K, V> {
    private static final int MAX_CONTENT = 200;
    private final ConcurrentMap<K, V> _map = Maps.newConcurrentMap();
    private final int _maxContent;

    protected ValueOfMap() {
        this(200);
    }

    protected ValueOfMap(int maxContent) {
        this._maxContent = maxContent;
    }

    @Nonnull
    public final V get(@Nonnull K key) {
        V newResult;
        V existing;
        Object result = this._map.get(key);
        if (result != null) {
            return result;
        }
        if (this._map.size() > this._maxContent) {
            this._map.clear();
        }
        return (existing = this._map.putIfAbsent(key, newResult = this.create(key))) != null ? existing : newResult;
    }

    public final V apply(K input) {
        return input != null ? (V)this.get(input) : null;
    }

    @Nonnull
    protected abstract V create(@Nonnull K var1);

    @CheckForNull
    protected final V put(@Nonnull K key, @Nonnull V value) {
        return this._map.put(key, value);
    }

    protected final void putAll(@Nonnull Map<? extends K, ? extends V> m) {
        this._map.putAll(m);
    }

    @Nonnull
    public static <K, V> ValueOfMap<K, V> wrap(final @Nonnull Function<K, V> f) {
        return new ValueOfMap<K, V>(){

            @Override
            protected V create(K key) {
                return f.apply(key);
            }
        };
    }
}

