/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.util;

import com.freiheit.toro.common.shared.util.ClientStringUtil;
import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import de.justsoftware.onx.common.shared.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UrlDetector {
    private static final String PATTERN = "\\b((?:((?:https?|ftp|file):(?://|[a-z0-9%]))|ww\\d{1,3}|www\\d{0,3}[.])(?:[^\\s()<>]+|\\(?:([^\\s()<>]+|(?:\\([^\\s()<>]+\\)))*\\))+(?:\\(([^\\s()<>]+|(?:\\([^\\s()<>]+\\)))*\\)|[^\\s`!()\\[\\]{};:'\".,<>?\u00ab\u00bb\u201c\u201d\u2018\u2019]))|((mailto:)?([A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,63}))";
    private static final RegExp URL_PATTERN = RegExp.compile((String)"\\b((?:((?:https?|ftp|file):(?://|[a-z0-9%]))|ww\\d{1,3}|www\\d{0,3}[.])(?:[^\\s()<>]+|\\(?:([^\\s()<>]+|(?:\\([^\\s()<>]+\\)))*\\))+(?:\\(([^\\s()<>]+|(?:\\([^\\s()<>]+\\)))*\\)|[^\\s`!()\\[\\]{};:'\".,<>?\u00ab\u00bb\u201c\u201d\u2018\u2019]))|((mailto:)?([A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,63}))", (String)"i");
    private static final int GROUP_FULL_MATCH = 0;
    private static final int GROUP_URL_PROTOCOL = 2;
    private static final int GROUP_MAIL = 5;
    private static final int GROUP_MAILTO = 6;

    public static String replaceUrls(String input, String replacement) {
        return input.replaceAll(URL_PATTERN.toString(), replacement);
    }

    private static final List<MatchResultOrRestString> findAllMatches(String input, RegExp pattern) {
        String tmp = input;
        MatchResult m = pattern.exec(tmp);
        ArrayList<MatchResultOrRestString> result = new ArrayList<MatchResultOrRestString>();
        while (m != null) {
            if (m.getIndex() > 0) {
                result.add(new MatchResultOrRestString(null, tmp.substring(0, m.getIndex())));
            }
            result.add(new MatchResultOrRestString(m, null));
            tmp = tmp.substring(m.getIndex() + m.getGroup(0).length());
            m = pattern.exec(tmp);
        }
        result.add(new MatchResultOrRestString(null, tmp));
        return result;
    }

    @Nonnull
    public static String shorten(@Nullable Integer maxLength, @Nonnull String s, int start) {
        int l = s.length();
        if (maxLength != null && maxLength < l - start) {
            int i = (maxLength - 3) / 2;
            int j = i + (maxLength - 3) % 2;
            int s2 = Math.min(start + j, l);
            int s3 = Math.min(l - i, l);
            return s.substring(start, s2) + "..." + s.substring(s3, l);
        }
        return s.substring(start, l);
    }

    public static List<String> findUrls(String input) {
        List<MatchResultOrRestString> allMatches = UrlDetector.findAllMatches(input, URL_PATTERN);
        ArrayList<String> result = new ArrayList<String>(allMatches.size());
        for (MatchResultOrRestString m : allMatches) {
            if (m._matchResult == null) continue;
            result.add(m._matchResult.getGroup(0));
        }
        return result;
    }

    public static String getDomain(String urlString, boolean withProtocoll) {
        String domain = urlString;
        domain = domain.replaceFirst("(.+)://", "");
        RegExp rexp = RegExp.compile((String)"[/?!#]+");
        MatchResult m = rexp.exec(domain);
        if (m != null) {
            domain = domain.substring(0, m.getIndex());
        }
        if (!withProtocoll) {
            return domain;
        }
        String cDomain = urlString;
        return cDomain.substring(0, cDomain.indexOf(domain) + domain.length());
    }

    public static boolean urlOnSameDomain(String url, String domain) {
        if (domain == null || url == null) {
            return false;
        }
        String lowerDomain = domain.toLowerCase();
        return UrlDetector.getDomain(url, true).toLowerCase().equals(lowerDomain) || UrlDetector.getDomain(url, false).toLowerCase().equals(lowerDomain);
    }

    @Nonnull
    public static String addAnchorTags(@Nonnull String input, @Nullable Integer maxLength, @Nonnull LinkToNewWindow linkingRule, @Nullable String domain, @Nullable String additionalLinkClassname, boolean replaceNewlines) {
        String safeText = ClientStringUtil.htmlEscape(input);
        if (replaceNewlines) {
            safeText = safeText.replaceAll("\n", "<br/>");
        }
        return UrlDetector.addAnchorTagsUnsafe(safeText, maxLength, linkingRule, domain, additionalLinkClassname);
    }

    @Nonnull
    public static String addAnchorTagsUnsafe(@Nonnull String input, @Nullable Integer maxLength, @Nonnull LinkToNewWindow linkingRule, @Nullable String domain, @Nullable String additionalLinkClassname) {
        List<MatchResultOrRestString> allMatches = UrlDetector.findAllMatches(input, URL_PATTERN);
        StringBuilder sb = new StringBuilder(input.length() + 100 * allMatches.size());
        for (MatchResultOrRestString mr : allMatches) {
            MatchResult m = mr._matchResult;
            if (m == null) {
                sb.append(mr._restString);
                continue;
            }
            String completeUrl = UrlDetector.getProtocoIfMissing(m) + m.getGroup(0);
            int start = UrlDetector.getProtocolLength(m);
            String displayUrl = UrlDetector.shorten(maxLength, completeUrl, start);
            sb.append("<a href=\"").append(completeUrl).append("\"");
            if (UrlDetector.addTargetBlank(linkingRule, domain, completeUrl, m)) {
                sb.append(" target=\"_blank\"");
                sb.append(" rel=\"noreferrer noopener\"");
            }
            if (!StringUtil.isEmpty(additionalLinkClassname)) {
                sb.append(" class=\"" + additionalLinkClassname + "\"");
            }
            sb.append(" title=\"").append(completeUrl).append("\">").append(displayUrl).append("</a>");
        }
        return sb.toString();
    }

    private static boolean addTargetBlank(@Nonnull LinkToNewWindow linkingRule, @Nullable String domain, @Nonnull String completeUrl, @Nonnull MatchResult m) {
        if (UrlDetector.isMailUrl(m)) {
            return true;
        }
        switch (linkingRule) {
            case NEVER: {
                return false;
            }
            case ONLY_ON_FOREIGN_DOMAIN: {
                return !UrlDetector.urlOnSameDomain(completeUrl, domain);
            }
            case ALWAYS: {
                return true;
            }
        }
        return true;
    }

    private static String getProtocoIfMissing(@Nonnull MatchResult m) {
        if (UrlDetector.isMailUrl(m)) {
            return StringUtil.isEmpty(m.getGroup(6)) ? "mailto:" : "";
        }
        if (StringUtil.isEmpty(m.getGroup(2))) {
            return "http://";
        }
        return "";
    }

    private static int getProtocolLength(@Nonnull MatchResult m) {
        if (!StringUtil.isEmpty(m.getGroup(2))) {
            return m.getGroup(2).length();
        }
        return 7;
    }

    private static boolean isMailUrl(@Nonnull MatchResult m) {
        return !StringUtil.isEmpty(m.getGroup(5));
    }

    private static final class MatchResultOrRestString {
        private final MatchResult _matchResult;
        private final String _restString;

        private MatchResultOrRestString(MatchResult mr, String rest) {
            this._matchResult = mr;
            this._restString = rest;
        }

        public String toString() {
            return this._matchResult != null ? this._matchResult.getGroup(0) : this._restString;
        }
    }

    public static enum LinkToNewWindow {
        ALWAYS,
        ONLY_ON_FOREIGN_DOMAIN,
        NEVER;

    }
}

