/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.util;

import com.google.common.base.CharMatcher;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class StringUtil {
    public static final String EMPTY = "";
    private static final char ZERO_WIDTH_SPACE = '\u200b';
    private static final int NO_BREAK_MAX_LEN = 10;
    private static final String NORMALIZE_TO_SINGLE_WHITE_SPACE = "\\s+";

    @Nonnull
    public static String limitStringWithDots(@Nullable String s, int maxChars) {
        if (s == null) {
            return EMPTY;
        }
        if (s.length() <= maxChars) {
            return s;
        }
        return s.substring(0, maxChars - 3) + "...";
    }

    public static boolean isBlank(@Nullable String string) {
        return string == null || string.trim().length() == 0;
    }

    public static boolean isEmpty(@Nullable String string) {
        return string == null || string.length() == 0;
    }

    @Nonnull
    public static String join(List<?> strings, String delimiter) {
        if (strings.isEmpty()) {
            return EMPTY;
        }
        if (strings.size() == 1) {
            return strings.get(0).toString();
        }
        Iterator<?> iterator = strings.iterator();
        StringBuilder sb = new StringBuilder();
        sb.append(iterator.next());
        while (iterator.hasNext()) {
            sb.append(delimiter);
            sb.append(iterator.next());
        }
        return sb.toString();
    }

    @Nonnull
    public static String breakWord(String s) {
        StringBuilder result = new StringBuilder();
        int noBreak = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            result.append(c);
            noBreak = CharMatcher.whitespace().matches(c) ? 0 : ++noBreak;
            if (noBreak < 10) continue;
            result.append('\u200b');
            noBreak = 0;
        }
        return result.toString();
    }

    public static int countWords(@Nullable String s) {
        if (s == null) {
            return 0;
        }
        String[] parts = s.split(NORMALIZE_TO_SINGLE_WHITE_SPACE);
        int count = 0;
        for (String part : parts) {
            if (part.matches("\\s*")) continue;
            ++count;
        }
        return count;
    }

    public static int parsePixels(@Nullable String px) throws NumberFormatException {
        if (px == null) {
            throw new NumberFormatException();
        }
        String clean = px.trim();
        if (clean.endsWith("px")) {
            clean = clean.substring(0, clean.length() - 2).trim();
        }
        return Integer.parseInt(clean);
    }

    public static int parsePixels(@Nullable String px, int def) {
        if (StringUtil.isBlank(px)) {
            return def;
        }
        try {
            return StringUtil.parsePixels(px);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    @Nonnull
    public static String defaultIfBlank(@Nullable String s, String defaultValue) {
        return StringUtil.isBlank(s) ? defaultValue : s;
    }

    @Nonnull
    public static String normalizeSearch(@Nullable String search) {
        if (search == null) {
            return EMPTY;
        }
        return search.toLowerCase().replaceAll(NORMALIZE_TO_SINGLE_WHITE_SPACE, " ").trim();
    }

    @Nonnull
    public static String squeezeHtml(String text) {
        StringBuilder result = new StringBuilder(text.length());
        boolean lastWs = false;
        boolean lineBreak = false;
        for (char ch : text.toCharArray()) {
            lineBreak |= ch == '\n';
            if (CharMatcher.whitespace().matches(ch)) {
                lastWs = true;
                continue;
            }
            if (lineBreak) {
                result.append('\n').append(ch);
                lineBreak = false;
                lastWs = false;
                continue;
            }
            if (lastWs) {
                result.append(' ').append(ch);
                lastWs = false;
                continue;
            }
            result.append(ch);
            lastWs = false;
        }
        return result.toString();
    }
}

