/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.util;

import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.onx.common.shared.i18n.LocalizedMessages;
import de.justsoftware.onx.common.shared.util.Dates;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class RelativeDateUtil {
    private static final double SECOND = 1000.0;
    private static final double MINUTE = 60000.0;
    private static final double HOUR = 3600000.0;
    private final LocalizedMessages _localizedMessages;

    public RelativeDateUtil(LocalizedMessages localizedMessages) {
        this._localizedMessages = localizedMessages;
    }

    @Nonnull
    protected abstract String formatAbsolute(String var1, Date var2);

    @Nonnull
    public String getRelativeTime(Date d) {
        return this.getRelativeTime(d, new Date());
    }

    @Nonnull
    public String getRelativeTime(Date start, Date now) {
        long diff = now.getTime() - start.getTime();
        if (diff >= 0L) {
            if ((double)diff < 60000.0) {
                return this._localizedMessages.dateAndTimeConstants().recently();
            }
            if ((double)diff < 3600000.0) {
                long minutes = Math.round((double)diff / 60000.0);
                return minutes == 1L ? this._localizedMessages.dateAndTimeConstants().oneMinuteAgo() : this._localizedMessages.dateAndTimeConstants().minutesAgo(minutes);
            }
            if (Dates.areOnTheSameDay(start, now)) {
                long hour = Math.round((double)diff / 3600000.0);
                return hour == 1L ? this._localizedMessages.dateAndTimeConstants().oneHourAgo() : this._localizedMessages.dateAndTimeConstants().hoursAgo(hour);
            }
        }
        if (Dates.areOnTheSameDay(start, Dates.getPreviousDay(now))) {
            return this.formatAbsolute(this._localizedMessages.dateAndTimeConstants().relDateFormatYesterday(), start);
        }
        if (Dates.areOnTheSameYear(start, now)) {
            return this.formatAbsolute(this._localizedMessages.dateAndTimeConstants().relDateFormatSameYear(), start);
        }
        return this.formatAbsolute(this._localizedMessages.dateAndTimeConstants().relDateTimeFormat(), start);
    }

    @Nonnull
    public String getYearAndMonthDuration(Date startAt, @Nullable Date endAt) {
        Date newEndAt = endAt != null ? endAt : new Date();
        return this.getYearAndMonthDurationInternal(startAt, endAt, newEndAt);
    }

    @Nonnull
    @VisibleForTesting
    String getYearAndMonthDurationInternal(Date startAt, @Nullable Date endAt, Date newEndAt) {
        boolean roundUp;
        int totalMonths = (newEndAt.getYear() - startAt.getYear()) * 12 + newEndAt.getMonth() - startAt.getMonth();
        if (totalMonths == 0 && endAt == null) {
            return this._localizedMessages.dateAndTimeConstants().fewerThanOneMonth();
        }
        boolean bl = roundUp = newEndAt.getDate() > 14;
        if (roundUp || endAt != null) {
            ++totalMonths;
        }
        int years = totalMonths / 12;
        int months = totalMonths - years * 12;
        StringBuilder sb = new StringBuilder();
        if (years > 0) {
            sb.append(years).append(" ");
            if (years == 1) {
                sb.append(this._localizedMessages.dateAndTimeConstants().year());
            } else {
                sb.append(this._localizedMessages.dateAndTimeConstants().years());
            }
        }
        if (months > 0) {
            if (years > 0) {
                sb.append(", ");
            }
            sb.append(months).append(" ");
            if (months == 1) {
                sb.append(this._localizedMessages.dateAndTimeConstants().month());
            } else {
                sb.append(this._localizedMessages.dateAndTimeConstants().months());
            }
        }
        return sb.toString();
    }
}

