/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.util;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class RelationUtil {
    private RelationUtil() {
    }

    @Nonnull
    public static <K> ImmutableSetMultimap<K, K> loadTransitiveRelations(Set<K> keys, Function<? super HashSet<K>, ? extends Multimap<? extends K, ? extends K>> loadRelationFunction) {
        ImmutableSetMultimap.Builder allRelations = ImmutableSetMultimap.builder();
        HashSet<K> loadedKeys = new HashSet<K>();
        HashSet<K> missingKeys = new HashSet<K>(keys);
        while (!missingKeys.isEmpty()) {
            Multimap directRelations = (Multimap)loadRelationFunction.apply(missingKeys);
            allRelations.putAll(directRelations);
            loadedKeys.addAll(missingKeys);
            missingKeys.addAll(directRelations.values());
            missingKeys.removeAll(loadedKeys);
        }
        return RelationUtil.flattenTransitiveRelations(keys, allRelations.build());
    }

    @Nonnull
    public static <K> ImmutableSetMultimap<K, K> flattenTransitiveRelations(Set<K> keys, final Multimap<K, ? extends K> relations) {
        NullPermeableFunction indirectFunction = new NullPermeableFunction<K, Iterable<K>>(){

            @Override
            protected Iterable<K> applySafe(K input) {
                Collection direct = relations.get(input);
                return FluentIterable.from((Iterable)direct).transformAndConcat((Function)this).append((Iterable)direct);
            }
        };
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        for (K key : keys) {
            result.putAll(key, (Iterable)indirectFunction.apply(key));
        }
        return result.build();
    }
}

