/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.util;

import javax.annotation.Nonnull;

public final class RegExUtil {
    private RegExUtil() {
    }

    @Nonnull
    public static String wildcardsListToRegExString(@Nonnull String wildcards) {
        String[] ws = wildcards.split("\\s|;|,");
        StringBuffer r = new StringBuffer();
        boolean first = true;
        for (String w : ws) {
            if (w.equals("")) continue;
            if (!first) {
                r.append("|");
            }
            r.append("(");
            r.append(RegExUtil.wildcardsToRegExString(w));
            r.append(")");
            first = false;
        }
        return r.toString();
    }

    @Nonnull
    public static String wildcardsToRegExString(@Nonnull String w) {
        StringBuffer r = new StringBuffer();
        r.append('^');
        block5: for (int i = 0; i < w.length(); ++i) {
            char c = w.charAt(i);
            switch (c) {
                case '?': {
                    r.append("(.)");
                    continue block5;
                }
                case '*': {
                    r.append("(.*)");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '[': 
                case '\\': 
                case '^': 
                case '{': 
                case '|': {
                    r.append('\\').append(c);
                    continue block5;
                }
                default: {
                    r.append(c);
                }
            }
        }
        r.append('$');
        return r.toString();
    }
}

